/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for
 * an Event API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventConfig implements SdkPojo, Serializable, ToCopyableBuilder<EventConfig.Builder, EventConfig> {
    private static final SdkField<List<AuthProvider>> AUTH_PROVIDERS_FIELD = SdkField
            .<List<AuthProvider>> builder(MarshallingType.LIST)
            .memberName("authProviders")
            .getter(getter(EventConfig::authProviders))
            .setter(setter(Builder::authProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthProvider> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthProvider::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AuthMode>> CONNECTION_AUTH_MODES_FIELD = SdkField
            .<List<AuthMode>> builder(MarshallingType.LIST)
            .memberName("connectionAuthModes")
            .getter(getter(EventConfig::connectionAuthModes))
            .setter(setter(Builder::connectionAuthModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionAuthModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthMode> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthMode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AuthMode>> DEFAULT_PUBLISH_AUTH_MODES_FIELD = SdkField
            .<List<AuthMode>> builder(MarshallingType.LIST)
            .memberName("defaultPublishAuthModes")
            .getter(getter(EventConfig::defaultPublishAuthModes))
            .setter(setter(Builder::defaultPublishAuthModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultPublishAuthModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthMode> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthMode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AuthMode>> DEFAULT_SUBSCRIBE_AUTH_MODES_FIELD = SdkField
            .<List<AuthMode>> builder(MarshallingType.LIST)
            .memberName("defaultSubscribeAuthModes")
            .getter(getter(EventConfig::defaultSubscribeAuthModes))
            .setter(setter(Builder::defaultSubscribeAuthModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultSubscribeAuthModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthMode> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthMode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EventLogConfig> LOG_CONFIG_FIELD = SdkField.<EventLogConfig> builder(MarshallingType.SDK_POJO)
            .memberName("logConfig").getter(getter(EventConfig::logConfig)).setter(setter(Builder::logConfig))
            .constructor(EventLogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_PROVIDERS_FIELD,
            CONNECTION_AUTH_MODES_FIELD, DEFAULT_PUBLISH_AUTH_MODES_FIELD, DEFAULT_SUBSCRIBE_AUTH_MODES_FIELD, LOG_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AuthProvider> authProviders;

    private final List<AuthMode> connectionAuthModes;

    private final List<AuthMode> defaultPublishAuthModes;

    private final List<AuthMode> defaultSubscribeAuthModes;

    private final EventLogConfig logConfig;

    private EventConfig(BuilderImpl builder) {
        this.authProviders = builder.authProviders;
        this.connectionAuthModes = builder.connectionAuthModes;
        this.defaultPublishAuthModes = builder.defaultPublishAuthModes;
        this.defaultSubscribeAuthModes = builder.defaultSubscribeAuthModes;
        this.logConfig = builder.logConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthProviders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthProviders() {
        return authProviders != null && !(authProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of authorization providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthProviders} method.
     * </p>
     * 
     * @return A list of authorization providers.
     */
    public final List<AuthProvider> authProviders() {
        return authProviders;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionAuthModes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionAuthModes() {
        return connectionAuthModes != null && !(connectionAuthModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of valid authorization modes for the Event API connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionAuthModes} method.
     * </p>
     * 
     * @return A list of valid authorization modes for the Event API connections.
     */
    public final List<AuthMode> connectionAuthModes() {
        return connectionAuthModes;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultPublishAuthModes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDefaultPublishAuthModes() {
        return defaultPublishAuthModes != null && !(defaultPublishAuthModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of valid authorization modes for the Event API publishing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultPublishAuthModes} method.
     * </p>
     * 
     * @return A list of valid authorization modes for the Event API publishing.
     */
    public final List<AuthMode> defaultPublishAuthModes() {
        return defaultPublishAuthModes;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultSubscribeAuthModes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDefaultSubscribeAuthModes() {
        return defaultSubscribeAuthModes != null && !(defaultSubscribeAuthModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of valid authorization modes for the Event API subscriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultSubscribeAuthModes} method.
     * </p>
     * 
     * @return A list of valid authorization modes for the Event API subscriptions.
     */
    public final List<AuthMode> defaultSubscribeAuthModes() {
        return defaultSubscribeAuthModes;
    }

    /**
     * <p>
     * The CloudWatch Logs configuration for the Event API.
     * </p>
     * 
     * @return The CloudWatch Logs configuration for the Event API.
     */
    public final EventLogConfig logConfig() {
        return logConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthProviders() ? authProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionAuthModes() ? connectionAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultPublishAuthModes() ? defaultPublishAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultSubscribeAuthModes() ? defaultSubscribeAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventConfig)) {
            return false;
        }
        EventConfig other = (EventConfig) obj;
        return hasAuthProviders() == other.hasAuthProviders() && Objects.equals(authProviders(), other.authProviders())
                && hasConnectionAuthModes() == other.hasConnectionAuthModes()
                && Objects.equals(connectionAuthModes(), other.connectionAuthModes())
                && hasDefaultPublishAuthModes() == other.hasDefaultPublishAuthModes()
                && Objects.equals(defaultPublishAuthModes(), other.defaultPublishAuthModes())
                && hasDefaultSubscribeAuthModes() == other.hasDefaultSubscribeAuthModes()
                && Objects.equals(defaultSubscribeAuthModes(), other.defaultSubscribeAuthModes())
                && Objects.equals(logConfig(), other.logConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventConfig").add("AuthProviders", hasAuthProviders() ? authProviders() : null)
                .add("ConnectionAuthModes", hasConnectionAuthModes() ? connectionAuthModes() : null)
                .add("DefaultPublishAuthModes", hasDefaultPublishAuthModes() ? defaultPublishAuthModes() : null)
                .add("DefaultSubscribeAuthModes", hasDefaultSubscribeAuthModes() ? defaultSubscribeAuthModes() : null)
                .add("LogConfig", logConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authProviders":
            return Optional.ofNullable(clazz.cast(authProviders()));
        case "connectionAuthModes":
            return Optional.ofNullable(clazz.cast(connectionAuthModes()));
        case "defaultPublishAuthModes":
            return Optional.ofNullable(clazz.cast(defaultPublishAuthModes()));
        case "defaultSubscribeAuthModes":
            return Optional.ofNullable(clazz.cast(defaultSubscribeAuthModes()));
        case "logConfig":
            return Optional.ofNullable(clazz.cast(logConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authProviders", AUTH_PROVIDERS_FIELD);
        map.put("connectionAuthModes", CONNECTION_AUTH_MODES_FIELD);
        map.put("defaultPublishAuthModes", DEFAULT_PUBLISH_AUTH_MODES_FIELD);
        map.put("defaultSubscribeAuthModes", DEFAULT_SUBSCRIBE_AUTH_MODES_FIELD);
        map.put("logConfig", LOG_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventConfig, T> g) {
        return obj -> g.apply((EventConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventConfig> {
        /**
         * <p>
         * A list of authorization providers.
         * </p>
         * 
         * @param authProviders
         *        A list of authorization providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authProviders(Collection<AuthProvider> authProviders);

        /**
         * <p>
         * A list of authorization providers.
         * </p>
         * 
         * @param authProviders
         *        A list of authorization providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authProviders(AuthProvider... authProviders);

        /**
         * <p>
         * A list of authorization providers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.AuthProvider.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appsync.model.AuthProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.AuthProvider.Builder#build()} is called immediately and
         * its result is passed to {@link #authProviders(List<AuthProvider>)}.
         * 
         * @param authProviders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.AuthProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authProviders(java.util.Collection<AuthProvider>)
         */
        Builder authProviders(Consumer<AuthProvider.Builder>... authProviders);

        /**
         * <p>
         * A list of valid authorization modes for the Event API connections.
         * </p>
         * 
         * @param connectionAuthModes
         *        A list of valid authorization modes for the Event API connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAuthModes(Collection<AuthMode> connectionAuthModes);

        /**
         * <p>
         * A list of valid authorization modes for the Event API connections.
         * </p>
         * 
         * @param connectionAuthModes
         *        A list of valid authorization modes for the Event API connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAuthModes(AuthMode... connectionAuthModes);

        /**
         * <p>
         * A list of valid authorization modes for the Event API connections.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appsync.model.AuthMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionAuthModes(List<AuthMode>)}.
         * 
         * @param connectionAuthModes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionAuthModes(java.util.Collection<AuthMode>)
         */
        Builder connectionAuthModes(Consumer<AuthMode.Builder>... connectionAuthModes);

        /**
         * <p>
         * A list of valid authorization modes for the Event API publishing.
         * </p>
         * 
         * @param defaultPublishAuthModes
         *        A list of valid authorization modes for the Event API publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPublishAuthModes(Collection<AuthMode> defaultPublishAuthModes);

        /**
         * <p>
         * A list of valid authorization modes for the Event API publishing.
         * </p>
         * 
         * @param defaultPublishAuthModes
         *        A list of valid authorization modes for the Event API publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPublishAuthModes(AuthMode... defaultPublishAuthModes);

        /**
         * <p>
         * A list of valid authorization modes for the Event API publishing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appsync.model.AuthMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultPublishAuthModes(List<AuthMode>)}.
         * 
         * @param defaultPublishAuthModes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultPublishAuthModes(java.util.Collection<AuthMode>)
         */
        Builder defaultPublishAuthModes(Consumer<AuthMode.Builder>... defaultPublishAuthModes);

        /**
         * <p>
         * A list of valid authorization modes for the Event API subscriptions.
         * </p>
         * 
         * @param defaultSubscribeAuthModes
         *        A list of valid authorization modes for the Event API subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubscribeAuthModes(Collection<AuthMode> defaultSubscribeAuthModes);

        /**
         * <p>
         * A list of valid authorization modes for the Event API subscriptions.
         * </p>
         * 
         * @param defaultSubscribeAuthModes
         *        A list of valid authorization modes for the Event API subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubscribeAuthModes(AuthMode... defaultSubscribeAuthModes);

        /**
         * <p>
         * A list of valid authorization modes for the Event API subscriptions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appsync.model.AuthMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultSubscribeAuthModes(List<AuthMode>)}.
         * 
         * @param defaultSubscribeAuthModes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultSubscribeAuthModes(java.util.Collection<AuthMode>)
         */
        Builder defaultSubscribeAuthModes(Consumer<AuthMode.Builder>... defaultSubscribeAuthModes);

        /**
         * <p>
         * The CloudWatch Logs configuration for the Event API.
         * </p>
         * 
         * @param logConfig
         *        The CloudWatch Logs configuration for the Event API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfig(EventLogConfig logConfig);

        /**
         * <p>
         * The CloudWatch Logs configuration for the Event API.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventLogConfig.Builder} avoiding the need
         * to create one manually via {@link EventLogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventLogConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfig(EventLogConfig)}.
         * 
         * @param logConfig
         *        a consumer that will call methods on {@link EventLogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfig(EventLogConfig)
         */
        default Builder logConfig(Consumer<EventLogConfig.Builder> logConfig) {
            return logConfig(EventLogConfig.builder().applyMutation(logConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AuthProvider> authProviders = DefaultSdkAutoConstructList.getInstance();

        private List<AuthMode> connectionAuthModes = DefaultSdkAutoConstructList.getInstance();

        private List<AuthMode> defaultPublishAuthModes = DefaultSdkAutoConstructList.getInstance();

        private List<AuthMode> defaultSubscribeAuthModes = DefaultSdkAutoConstructList.getInstance();

        private EventLogConfig logConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EventConfig model) {
            authProviders(model.authProviders);
            connectionAuthModes(model.connectionAuthModes);
            defaultPublishAuthModes(model.defaultPublishAuthModes);
            defaultSubscribeAuthModes(model.defaultSubscribeAuthModes);
            logConfig(model.logConfig);
        }

        public final List<AuthProvider.Builder> getAuthProviders() {
            List<AuthProvider.Builder> result = AuthProvidersCopier.copyToBuilder(this.authProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthProviders(Collection<AuthProvider.BuilderImpl> authProviders) {
            this.authProviders = AuthProvidersCopier.copyFromBuilder(authProviders);
        }

        @Override
        public final Builder authProviders(Collection<AuthProvider> authProviders) {
            this.authProviders = AuthProvidersCopier.copy(authProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authProviders(AuthProvider... authProviders) {
            authProviders(Arrays.asList(authProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authProviders(Consumer<AuthProvider.Builder>... authProviders) {
            authProviders(Stream.of(authProviders).map(c -> AuthProvider.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AuthMode.Builder> getConnectionAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.connectionAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionAuthModes(Collection<AuthMode.BuilderImpl> connectionAuthModes) {
            this.connectionAuthModes = AuthModesCopier.copyFromBuilder(connectionAuthModes);
        }

        @Override
        public final Builder connectionAuthModes(Collection<AuthMode> connectionAuthModes) {
            this.connectionAuthModes = AuthModesCopier.copy(connectionAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAuthModes(AuthMode... connectionAuthModes) {
            connectionAuthModes(Arrays.asList(connectionAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAuthModes(Consumer<AuthMode.Builder>... connectionAuthModes) {
            connectionAuthModes(Stream.of(connectionAuthModes).map(c -> AuthMode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AuthMode.Builder> getDefaultPublishAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.defaultPublishAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultPublishAuthModes(Collection<AuthMode.BuilderImpl> defaultPublishAuthModes) {
            this.defaultPublishAuthModes = AuthModesCopier.copyFromBuilder(defaultPublishAuthModes);
        }

        @Override
        public final Builder defaultPublishAuthModes(Collection<AuthMode> defaultPublishAuthModes) {
            this.defaultPublishAuthModes = AuthModesCopier.copy(defaultPublishAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultPublishAuthModes(AuthMode... defaultPublishAuthModes) {
            defaultPublishAuthModes(Arrays.asList(defaultPublishAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultPublishAuthModes(Consumer<AuthMode.Builder>... defaultPublishAuthModes) {
            defaultPublishAuthModes(Stream.of(defaultPublishAuthModes).map(c -> AuthMode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AuthMode.Builder> getDefaultSubscribeAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.defaultSubscribeAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultSubscribeAuthModes(Collection<AuthMode.BuilderImpl> defaultSubscribeAuthModes) {
            this.defaultSubscribeAuthModes = AuthModesCopier.copyFromBuilder(defaultSubscribeAuthModes);
        }

        @Override
        public final Builder defaultSubscribeAuthModes(Collection<AuthMode> defaultSubscribeAuthModes) {
            this.defaultSubscribeAuthModes = AuthModesCopier.copy(defaultSubscribeAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultSubscribeAuthModes(AuthMode... defaultSubscribeAuthModes) {
            defaultSubscribeAuthModes(Arrays.asList(defaultSubscribeAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultSubscribeAuthModes(Consumer<AuthMode.Builder>... defaultSubscribeAuthModes) {
            defaultSubscribeAuthModes(Stream.of(defaultSubscribeAuthModes).map(c -> AuthMode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final EventLogConfig.Builder getLogConfig() {
            return logConfig != null ? logConfig.toBuilder() : null;
        }

        public final void setLogConfig(EventLogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(EventLogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        @Override
        public EventConfig build() {
            return new EventConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
