/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetApiCache</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApiCacheResponse extends AppSyncResponse implements
        ToCopyableBuilder<GetApiCacheResponse.Builder, GetApiCacheResponse> {
    private static final SdkField<ApiCache> API_CACHE_FIELD = SdkField.<ApiCache> builder(MarshallingType.SDK_POJO)
            .memberName("apiCache").getter(getter(GetApiCacheResponse::apiCache)).setter(setter(Builder::apiCache))
            .constructor(ApiCache::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCache").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_CACHE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ApiCache apiCache;

    private GetApiCacheResponse(BuilderImpl builder) {
        super(builder);
        this.apiCache = builder.apiCache;
    }

    /**
     * <p>
     * The <code>ApiCache</code> object.
     * </p>
     * 
     * @return The <code>ApiCache</code> object.
     */
    public final ApiCache apiCache() {
        return apiCache;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiCache());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiCacheResponse)) {
            return false;
        }
        GetApiCacheResponse other = (GetApiCacheResponse) obj;
        return Objects.equals(apiCache(), other.apiCache());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApiCacheResponse").add("ApiCache", apiCache()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiCache":
            return Optional.ofNullable(clazz.cast(apiCache()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiCache", API_CACHE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApiCacheResponse, T> g) {
        return obj -> g.apply((GetApiCacheResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetApiCacheResponse> {
        /**
         * <p>
         * The <code>ApiCache</code> object.
         * </p>
         * 
         * @param apiCache
         *        The <code>ApiCache</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiCache(ApiCache apiCache);

        /**
         * <p>
         * The <code>ApiCache</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiCache.Builder} avoiding the need to
         * create one manually via {@link ApiCache#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiCache.Builder#build()} is called immediately and its result is
         * passed to {@link #apiCache(ApiCache)}.
         * 
         * @param apiCache
         *        a consumer that will call methods on {@link ApiCache.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiCache(ApiCache)
         */
        default Builder apiCache(Consumer<ApiCache.Builder> apiCache) {
            return apiCache(ApiCache.builder().applyMutation(apiCache).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private ApiCache apiCache;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiCacheResponse model) {
            super(model);
            apiCache(model.apiCache);
        }

        public final ApiCache.Builder getApiCache() {
            return apiCache != null ? apiCache.toBuilder() : null;
        }

        public final void setApiCache(ApiCache.BuilderImpl apiCache) {
            this.apiCache = apiCache != null ? apiCache.build() : null;
        }

        @Override
        public final Builder apiCache(ApiCache apiCache) {
            this.apiCache = apiCache;
            return this;
        }

        @Override
        public GetApiCacheResponse build() {
            return new GetApiCacheResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
