/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataSourceIntrospectionRequest extends AppSyncRequest implements
        ToCopyableBuilder<GetDataSourceIntrospectionRequest.Builder, GetDataSourceIntrospectionRequest> {
    private static final SdkField<String> INTROSPECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("introspectionId").getter(getter(GetDataSourceIntrospectionRequest::introspectionId))
            .setter(setter(Builder::introspectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("introspectionId").build()).build();

    private static final SdkField<Boolean> INCLUDE_MODELS_SDL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeModelsSDL").getter(getter(GetDataSourceIntrospectionRequest::includeModelsSDL))
            .setter(setter(Builder::includeModelsSDL))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeModelsSDL").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetDataSourceIntrospectionRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetDataSourceIntrospectionRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTROSPECTION_ID_FIELD,
            INCLUDE_MODELS_SDL_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String introspectionId;

    private final Boolean includeModelsSDL;

    private final String nextToken;

    private final Integer maxResults;

    private GetDataSourceIntrospectionRequest(BuilderImpl builder) {
        super(builder);
        this.introspectionId = builder.introspectionId;
        this.includeModelsSDL = builder.includeModelsSDL;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The introspection ID. Each introspection contains a unique ID that can be used to reference the instrospection
     * record.
     * </p>
     * 
     * @return The introspection ID. Each introspection contains a unique ID that can be used to reference the
     *         instrospection record.
     */
    public final String introspectionId() {
        return introspectionId;
    }

    /**
     * <p>
     * A boolean flag that determines whether SDL should be generated for introspected types. If set to
     * <code>true</code>, each model will contain an <code>sdl</code> property that contains the SDL for that type. The
     * SDL only contains the type data and no additional metadata or directives.
     * </p>
     * 
     * @return A boolean flag that determines whether SDL should be generated for introspected types. If set to
     *         <code>true</code>, each model will contain an <code>sdl</code> property that contains the SDL for that
     *         type. The SDL only contains the type data and no additional metadata or directives.
     */
    public final Boolean includeModelsSDL() {
        return includeModelsSDL;
    }

    /**
     * <p>
     * Determines the number of types to be returned in a single response before paginating. This value is typically
     * taken from <code>nextToken</code> value from the previous response.
     * </p>
     * 
     * @return Determines the number of types to be returned in a single response before paginating. This value is
     *         typically taken from <code>nextToken</code> value from the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of introspected types that will be returned in a single response.
     * </p>
     * 
     * @return The maximum number of introspected types that will be returned in a single response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(introspectionId());
        hashCode = 31 * hashCode + Objects.hashCode(includeModelsSDL());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceIntrospectionRequest)) {
            return false;
        }
        GetDataSourceIntrospectionRequest other = (GetDataSourceIntrospectionRequest) obj;
        return Objects.equals(introspectionId(), other.introspectionId())
                && Objects.equals(includeModelsSDL(), other.includeModelsSDL()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataSourceIntrospectionRequest").add("IntrospectionId", introspectionId())
                .add("IncludeModelsSDL", includeModelsSDL()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "introspectionId":
            return Optional.ofNullable(clazz.cast(introspectionId()));
        case "includeModelsSDL":
            return Optional.ofNullable(clazz.cast(includeModelsSDL()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("introspectionId", INTROSPECTION_ID_FIELD);
        map.put("includeModelsSDL", INCLUDE_MODELS_SDL_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataSourceIntrospectionRequest, T> g) {
        return obj -> g.apply((GetDataSourceIntrospectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDataSourceIntrospectionRequest> {
        /**
         * <p>
         * The introspection ID. Each introspection contains a unique ID that can be used to reference the
         * instrospection record.
         * </p>
         * 
         * @param introspectionId
         *        The introspection ID. Each introspection contains a unique ID that can be used to reference the
         *        instrospection record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder introspectionId(String introspectionId);

        /**
         * <p>
         * A boolean flag that determines whether SDL should be generated for introspected types. If set to
         * <code>true</code>, each model will contain an <code>sdl</code> property that contains the SDL for that type.
         * The SDL only contains the type data and no additional metadata or directives.
         * </p>
         * 
         * @param includeModelsSDL
         *        A boolean flag that determines whether SDL should be generated for introspected types. If set to
         *        <code>true</code>, each model will contain an <code>sdl</code> property that contains the SDL for that
         *        type. The SDL only contains the type data and no additional metadata or directives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeModelsSDL(Boolean includeModelsSDL);

        /**
         * <p>
         * Determines the number of types to be returned in a single response before paginating. This value is typically
         * taken from <code>nextToken</code> value from the previous response.
         * </p>
         * 
         * @param nextToken
         *        Determines the number of types to be returned in a single response before paginating. This value is
         *        typically taken from <code>nextToken</code> value from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of introspected types that will be returned in a single response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of introspected types that will be returned in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String introspectionId;

        private Boolean includeModelsSDL;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceIntrospectionRequest model) {
            super(model);
            introspectionId(model.introspectionId);
            includeModelsSDL(model.includeModelsSDL);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getIntrospectionId() {
            return introspectionId;
        }

        public final void setIntrospectionId(String introspectionId) {
            this.introspectionId = introspectionId;
        }

        @Override
        public final Builder introspectionId(String introspectionId) {
            this.introspectionId = introspectionId;
            return this;
        }

        public final Boolean getIncludeModelsSDL() {
            return includeModelsSDL;
        }

        public final void setIncludeModelsSDL(Boolean includeModelsSDL) {
            this.includeModelsSDL = includeModelsSDL;
        }

        @Override
        public final Builder includeModelsSDL(Boolean includeModelsSDL) {
            this.includeModelsSDL = includeModelsSDL;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataSourceIntrospectionRequest build() {
            return new GetDataSourceIntrospectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
