/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataSourceIntrospectionResponse extends AppSyncResponse implements
        ToCopyableBuilder<GetDataSourceIntrospectionResponse.Builder, GetDataSourceIntrospectionResponse> {
    private static final SdkField<String> INTROSPECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("introspectionId").getter(getter(GetDataSourceIntrospectionResponse::introspectionId))
            .setter(setter(Builder::introspectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("introspectionId").build()).build();

    private static final SdkField<String> INTROSPECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("introspectionStatus").getter(getter(GetDataSourceIntrospectionResponse::introspectionStatusAsString))
            .setter(setter(Builder::introspectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("introspectionStatus").build())
            .build();

    private static final SdkField<String> INTROSPECTION_STATUS_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("introspectionStatusDetail")
            .getter(getter(GetDataSourceIntrospectionResponse::introspectionStatusDetail))
            .setter(setter(Builder::introspectionStatusDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("introspectionStatusDetail").build())
            .build();

    private static final SdkField<DataSourceIntrospectionResult> INTROSPECTION_RESULT_FIELD = SdkField
            .<DataSourceIntrospectionResult> builder(MarshallingType.SDK_POJO).memberName("introspectionResult")
            .getter(getter(GetDataSourceIntrospectionResponse::introspectionResult)).setter(setter(Builder::introspectionResult))
            .constructor(DataSourceIntrospectionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("introspectionResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTROSPECTION_ID_FIELD,
            INTROSPECTION_STATUS_FIELD, INTROSPECTION_STATUS_DETAIL_FIELD, INTROSPECTION_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String introspectionId;

    private final String introspectionStatus;

    private final String introspectionStatusDetail;

    private final DataSourceIntrospectionResult introspectionResult;

    private GetDataSourceIntrospectionResponse(BuilderImpl builder) {
        super(builder);
        this.introspectionId = builder.introspectionId;
        this.introspectionStatus = builder.introspectionStatus;
        this.introspectionStatusDetail = builder.introspectionStatusDetail;
        this.introspectionResult = builder.introspectionResult;
    }

    /**
     * <p>
     * The introspection ID. Each introspection contains a unique ID that can be used to reference the instrospection
     * record.
     * </p>
     * 
     * @return The introspection ID. Each introspection contains a unique ID that can be used to reference the
     *         instrospection record.
     */
    public final String introspectionId() {
        return introspectionId;
    }

    /**
     * <p>
     * The status of the introspection during retrieval. By default, when a new instrospection is being retrieved, the
     * status will be set to <code>PROCESSING</code>. Once the operation has been completed, the status will change to
     * <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was parsed. A <code>FAILED</code> operation
     * will return an error and its details as an <code>introspectionStatusDetail</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #introspectionStatus} will return {@link DataSourceIntrospectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #introspectionStatusAsString}.
     * </p>
     * 
     * @return The status of the introspection during retrieval. By default, when a new instrospection is being
     *         retrieved, the status will be set to <code>PROCESSING</code>. Once the operation has been completed, the
     *         status will change to <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was parsed. A
     *         <code>FAILED</code> operation will return an error and its details as an
     *         <code>introspectionStatusDetail</code>.
     * @see DataSourceIntrospectionStatus
     */
    public final DataSourceIntrospectionStatus introspectionStatus() {
        return DataSourceIntrospectionStatus.fromValue(introspectionStatus);
    }

    /**
     * <p>
     * The status of the introspection during retrieval. By default, when a new instrospection is being retrieved, the
     * status will be set to <code>PROCESSING</code>. Once the operation has been completed, the status will change to
     * <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was parsed. A <code>FAILED</code> operation
     * will return an error and its details as an <code>introspectionStatusDetail</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #introspectionStatus} will return {@link DataSourceIntrospectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #introspectionStatusAsString}.
     * </p>
     * 
     * @return The status of the introspection during retrieval. By default, when a new instrospection is being
     *         retrieved, the status will be set to <code>PROCESSING</code>. Once the operation has been completed, the
     *         status will change to <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was parsed. A
     *         <code>FAILED</code> operation will return an error and its details as an
     *         <code>introspectionStatusDetail</code>.
     * @see DataSourceIntrospectionStatus
     */
    public final String introspectionStatusAsString() {
        return introspectionStatus;
    }

    /**
     * <p>
     * The error detail field. When a <code>FAILED</code> <code>introspectionStatus</code> is returned, the
     * <code>introspectionStatusDetail</code> will also return the exact error that was generated during the operation.
     * </p>
     * 
     * @return The error detail field. When a <code>FAILED</code> <code>introspectionStatus</code> is returned, the
     *         <code>introspectionStatusDetail</code> will also return the exact error that was generated during the
     *         operation.
     */
    public final String introspectionStatusDetail() {
        return introspectionStatusDetail;
    }

    /**
     * <p>
     * The <code>DataSourceIntrospectionResult</code> object data.
     * </p>
     * 
     * @return The <code>DataSourceIntrospectionResult</code> object data.
     */
    public final DataSourceIntrospectionResult introspectionResult() {
        return introspectionResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(introspectionId());
        hashCode = 31 * hashCode + Objects.hashCode(introspectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(introspectionStatusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(introspectionResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceIntrospectionResponse)) {
            return false;
        }
        GetDataSourceIntrospectionResponse other = (GetDataSourceIntrospectionResponse) obj;
        return Objects.equals(introspectionId(), other.introspectionId())
                && Objects.equals(introspectionStatusAsString(), other.introspectionStatusAsString())
                && Objects.equals(introspectionStatusDetail(), other.introspectionStatusDetail())
                && Objects.equals(introspectionResult(), other.introspectionResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataSourceIntrospectionResponse").add("IntrospectionId", introspectionId())
                .add("IntrospectionStatus", introspectionStatusAsString())
                .add("IntrospectionStatusDetail", introspectionStatusDetail()).add("IntrospectionResult", introspectionResult())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "introspectionId":
            return Optional.ofNullable(clazz.cast(introspectionId()));
        case "introspectionStatus":
            return Optional.ofNullable(clazz.cast(introspectionStatusAsString()));
        case "introspectionStatusDetail":
            return Optional.ofNullable(clazz.cast(introspectionStatusDetail()));
        case "introspectionResult":
            return Optional.ofNullable(clazz.cast(introspectionResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("introspectionId", INTROSPECTION_ID_FIELD);
        map.put("introspectionStatus", INTROSPECTION_STATUS_FIELD);
        map.put("introspectionStatusDetail", INTROSPECTION_STATUS_DETAIL_FIELD);
        map.put("introspectionResult", INTROSPECTION_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataSourceIntrospectionResponse, T> g) {
        return obj -> g.apply((GetDataSourceIntrospectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataSourceIntrospectionResponse> {
        /**
         * <p>
         * The introspection ID. Each introspection contains a unique ID that can be used to reference the
         * instrospection record.
         * </p>
         * 
         * @param introspectionId
         *        The introspection ID. Each introspection contains a unique ID that can be used to reference the
         *        instrospection record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder introspectionId(String introspectionId);

        /**
         * <p>
         * The status of the introspection during retrieval. By default, when a new instrospection is being retrieved,
         * the status will be set to <code>PROCESSING</code>. Once the operation has been completed, the status will
         * change to <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was parsed. A
         * <code>FAILED</code> operation will return an error and its details as an
         * <code>introspectionStatusDetail</code>.
         * </p>
         * 
         * @param introspectionStatus
         *        The status of the introspection during retrieval. By default, when a new instrospection is being
         *        retrieved, the status will be set to <code>PROCESSING</code>. Once the operation has been completed,
         *        the status will change to <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was
         *        parsed. A <code>FAILED</code> operation will return an error and its details as an
         *        <code>introspectionStatusDetail</code>.
         * @see DataSourceIntrospectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceIntrospectionStatus
         */
        Builder introspectionStatus(String introspectionStatus);

        /**
         * <p>
         * The status of the introspection during retrieval. By default, when a new instrospection is being retrieved,
         * the status will be set to <code>PROCESSING</code>. Once the operation has been completed, the status will
         * change to <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was parsed. A
         * <code>FAILED</code> operation will return an error and its details as an
         * <code>introspectionStatusDetail</code>.
         * </p>
         * 
         * @param introspectionStatus
         *        The status of the introspection during retrieval. By default, when a new instrospection is being
         *        retrieved, the status will be set to <code>PROCESSING</code>. Once the operation has been completed,
         *        the status will change to <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was
         *        parsed. A <code>FAILED</code> operation will return an error and its details as an
         *        <code>introspectionStatusDetail</code>.
         * @see DataSourceIntrospectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceIntrospectionStatus
         */
        Builder introspectionStatus(DataSourceIntrospectionStatus introspectionStatus);

        /**
         * <p>
         * The error detail field. When a <code>FAILED</code> <code>introspectionStatus</code> is returned, the
         * <code>introspectionStatusDetail</code> will also return the exact error that was generated during the
         * operation.
         * </p>
         * 
         * @param introspectionStatusDetail
         *        The error detail field. When a <code>FAILED</code> <code>introspectionStatus</code> is returned, the
         *        <code>introspectionStatusDetail</code> will also return the exact error that was generated during the
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder introspectionStatusDetail(String introspectionStatusDetail);

        /**
         * <p>
         * The <code>DataSourceIntrospectionResult</code> object data.
         * </p>
         * 
         * @param introspectionResult
         *        The <code>DataSourceIntrospectionResult</code> object data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder introspectionResult(DataSourceIntrospectionResult introspectionResult);

        /**
         * <p>
         * The <code>DataSourceIntrospectionResult</code> object data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceIntrospectionResult.Builder}
         * avoiding the need to create one manually via {@link DataSourceIntrospectionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceIntrospectionResult.Builder#build()} is called
         * immediately and its result is passed to {@link #introspectionResult(DataSourceIntrospectionResult)}.
         * 
         * @param introspectionResult
         *        a consumer that will call methods on {@link DataSourceIntrospectionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #introspectionResult(DataSourceIntrospectionResult)
         */
        default Builder introspectionResult(Consumer<DataSourceIntrospectionResult.Builder> introspectionResult) {
            return introspectionResult(DataSourceIntrospectionResult.builder().applyMutation(introspectionResult).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private String introspectionId;

        private String introspectionStatus;

        private String introspectionStatusDetail;

        private DataSourceIntrospectionResult introspectionResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceIntrospectionResponse model) {
            super(model);
            introspectionId(model.introspectionId);
            introspectionStatus(model.introspectionStatus);
            introspectionStatusDetail(model.introspectionStatusDetail);
            introspectionResult(model.introspectionResult);
        }

        public final String getIntrospectionId() {
            return introspectionId;
        }

        public final void setIntrospectionId(String introspectionId) {
            this.introspectionId = introspectionId;
        }

        @Override
        public final Builder introspectionId(String introspectionId) {
            this.introspectionId = introspectionId;
            return this;
        }

        public final String getIntrospectionStatus() {
            return introspectionStatus;
        }

        public final void setIntrospectionStatus(String introspectionStatus) {
            this.introspectionStatus = introspectionStatus;
        }

        @Override
        public final Builder introspectionStatus(String introspectionStatus) {
            this.introspectionStatus = introspectionStatus;
            return this;
        }

        @Override
        public final Builder introspectionStatus(DataSourceIntrospectionStatus introspectionStatus) {
            this.introspectionStatus(introspectionStatus == null ? null : introspectionStatus.toString());
            return this;
        }

        public final String getIntrospectionStatusDetail() {
            return introspectionStatusDetail;
        }

        public final void setIntrospectionStatusDetail(String introspectionStatusDetail) {
            this.introspectionStatusDetail = introspectionStatusDetail;
        }

        @Override
        public final Builder introspectionStatusDetail(String introspectionStatusDetail) {
            this.introspectionStatusDetail = introspectionStatusDetail;
            return this;
        }

        public final DataSourceIntrospectionResult.Builder getIntrospectionResult() {
            return introspectionResult != null ? introspectionResult.toBuilder() : null;
        }

        public final void setIntrospectionResult(DataSourceIntrospectionResult.BuilderImpl introspectionResult) {
            this.introspectionResult = introspectionResult != null ? introspectionResult.build() : null;
        }

        @Override
        public final Builder introspectionResult(DataSourceIntrospectionResult introspectionResult) {
            this.introspectionResult = introspectionResult;
            return this;
        }

        @Override
        public GetDataSourceIntrospectionResponse build() {
            return new GetDataSourceIntrospectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
