/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>LambdaConflictHandlerConfig</code> object when configuring <code>LAMBDA</code> as the Conflict Handler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaConflictHandlerConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaConflictHandlerConfig.Builder, LambdaConflictHandlerConfig> {
    private static final SdkField<String> LAMBDA_CONFLICT_HANDLER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaConflictHandlerArn").getter(getter(LambdaConflictHandlerConfig::lambdaConflictHandlerArn))
            .setter(setter(Builder::lambdaConflictHandlerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaConflictHandlerArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LAMBDA_CONFLICT_HANDLER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lambdaConflictHandlerArn;

    private LambdaConflictHandlerConfig(BuilderImpl builder) {
        this.lambdaConflictHandlerArn = builder.lambdaConflictHandlerArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
     */
    public final String lambdaConflictHandlerArn() {
        return lambdaConflictHandlerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConflictHandlerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaConflictHandlerConfig)) {
            return false;
        }
        LambdaConflictHandlerConfig other = (LambdaConflictHandlerConfig) obj;
        return Objects.equals(lambdaConflictHandlerArn(), other.lambdaConflictHandlerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaConflictHandlerConfig").add("LambdaConflictHandlerArn", lambdaConflictHandlerArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaConflictHandlerArn":
            return Optional.ofNullable(clazz.cast(lambdaConflictHandlerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lambdaConflictHandlerArn", LAMBDA_CONFLICT_HANDLER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaConflictHandlerConfig, T> g) {
        return obj -> g.apply((LambdaConflictHandlerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaConflictHandlerConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
         * </p>
         * 
         * @param lambdaConflictHandlerArn
         *        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConflictHandlerArn(String lambdaConflictHandlerArn);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaConflictHandlerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaConflictHandlerConfig model) {
            lambdaConflictHandlerArn(model.lambdaConflictHandlerArn);
        }

        public final String getLambdaConflictHandlerArn() {
            return lambdaConflictHandlerArn;
        }

        public final void setLambdaConflictHandlerArn(String lambdaConflictHandlerArn) {
            this.lambdaConflictHandlerArn = lambdaConflictHandlerArn;
        }

        @Override
        public final Builder lambdaConflictHandlerArn(String lambdaConflictHandlerArn) {
            this.lambdaConflictHandlerArn = lambdaConflictHandlerArn;
            return this;
        }

        @Override
        public LambdaConflictHandlerConfig build() {
            return new LambdaConflictHandlerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
