/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGraphqlApisRequest extends AppSyncRequest implements
        ToCopyableBuilder<ListGraphqlApisRequest.Builder, ListGraphqlApisRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListGraphqlApisRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListGraphqlApisRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> API_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiType").getter(getter(ListGraphqlApisRequest::apiTypeAsString)).setter(setter(Builder::apiType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("apiType").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(ListGraphqlApisRequest::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, API_TYPE_FIELD, OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String apiType;

    private final String owner;

    private ListGraphqlApisRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.apiType = builder.apiType;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which you can use to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which you can use to return the
     *         next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results that you want the request to return.
     * </p>
     * 
     * @return The maximum number of results that you want the request to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
     * <code>MERGED</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiType} will
     * return {@link GraphQLApiType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiTypeAsString}.
     * </p>
     * 
     * @return The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
     *         <code>MERGED</code>).
     * @see GraphQLApiType
     */
    public final GraphQLApiType apiType() {
        return GraphQLApiType.fromValue(apiType);
    }

    /**
     * <p>
     * The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
     * <code>MERGED</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiType} will
     * return {@link GraphQLApiType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiTypeAsString}.
     * </p>
     * 
     * @return The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
     *         <code>MERGED</code>).
     * @see GraphQLApiType
     */
    public final String apiTypeAsString() {
        return apiType;
    }

    /**
     * <p>
     * The account owner of the GraphQL API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Ownership#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The account owner of the GraphQL API.
     * @see Ownership
     */
    public final Ownership owner() {
        return Ownership.fromValue(owner);
    }

    /**
     * <p>
     * The account owner of the GraphQL API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Ownership#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The account owner of the GraphQL API.
     * @see Ownership
     */
    public final String ownerAsString() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(apiTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGraphqlApisRequest)) {
            return false;
        }
        ListGraphqlApisRequest other = (ListGraphqlApisRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(apiTypeAsString(), other.apiTypeAsString())
                && Objects.equals(ownerAsString(), other.ownerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGraphqlApisRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ApiType", apiTypeAsString()).add("Owner", ownerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "apiType":
            return Optional.ofNullable(clazz.cast(apiTypeAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("apiType", API_TYPE_FIELD);
        map.put("owner", OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGraphqlApisRequest, T> g) {
        return obj -> g.apply((ListGraphqlApisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListGraphqlApisRequest> {
        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which you can use to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which you can use to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results that you want the request to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that you want the request to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
         * <code>MERGED</code>).
         * </p>
         * 
         * @param apiType
         *        The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged
         *        API (<code>MERGED</code>).
         * @see GraphQLApiType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphQLApiType
         */
        Builder apiType(String apiType);

        /**
         * <p>
         * The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
         * <code>MERGED</code>).
         * </p>
         * 
         * @param apiType
         *        The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged
         *        API (<code>MERGED</code>).
         * @see GraphQLApiType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphQLApiType
         */
        Builder apiType(GraphQLApiType apiType);

        /**
         * <p>
         * The account owner of the GraphQL API.
         * </p>
         * 
         * @param owner
         *        The account owner of the GraphQL API.
         * @see Ownership
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ownership
         */
        Builder owner(String owner);

        /**
         * <p>
         * The account owner of the GraphQL API.
         * </p>
         * 
         * @param owner
         *        The account owner of the GraphQL API.
         * @see Ownership
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ownership
         */
        Builder owner(Ownership owner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String apiType;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGraphqlApisRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            apiType(model.apiType);
            owner(model.owner);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getApiType() {
            return apiType;
        }

        public final void setApiType(String apiType) {
            this.apiType = apiType;
        }

        @Override
        public final Builder apiType(String apiType) {
            this.apiType = apiType;
            return this;
        }

        @Override
        public final Builder apiType(GraphQLApiType apiType) {
            this.apiType(apiType == null ? null : apiType.toString());
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Ownership owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGraphqlApisRequest build() {
            return new ListGraphqlApisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
