/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTypesByAssociationRequest extends AppSyncRequest implements
        ToCopyableBuilder<ListTypesByAssociationRequest.Builder, ListTypesByAssociationRequest> {
    private static final SdkField<String> MERGED_API_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergedApiIdentifier").getter(getter(ListTypesByAssociationRequest::mergedApiIdentifier))
            .setter(setter(Builder::mergedApiIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("mergedApiIdentifier").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationId").getter(getter(ListTypesByAssociationRequest::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("associationId").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(ListTypesByAssociationRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTypesByAssociationRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTypesByAssociationRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGED_API_IDENTIFIER_FIELD,
            ASSOCIATION_ID_FIELD, FORMAT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mergedApiIdentifier;

    private final String associationId;

    private final String format;

    private final String nextToken;

    private final Integer maxResults;

    private ListTypesByAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.mergedApiIdentifier = builder.mergedApiIdentifier;
        this.associationId = builder.associationId;
        this.format = builder.format;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     * 
     * @return The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
     *         APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
     *         APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged
     *         API.
     */
    public final String mergedApiIdentifier() {
        return mergedApiIdentifier;
    }

    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     * 
     * @return The ID generated by the AppSync service for the source API association.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The format type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TypeDefinitionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format type.
     * @see TypeDefinitionFormat
     */
    public final TypeDefinitionFormat format() {
        return TypeDefinitionFormat.fromValue(format);
    }

    /**
     * <p>
     * The format type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TypeDefinitionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format type.
     * @see TypeDefinitionFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which you can use to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which you can use to return the
     *         next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results that you want the request to return.
     * </p>
     * 
     * @return The maximum number of results that you want the request to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mergedApiIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesByAssociationRequest)) {
            return false;
        }
        ListTypesByAssociationRequest other = (ListTypesByAssociationRequest) obj;
        return Objects.equals(mergedApiIdentifier(), other.mergedApiIdentifier())
                && Objects.equals(associationId(), other.associationId())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTypesByAssociationRequest").add("MergedApiIdentifier", mergedApiIdentifier())
                .add("AssociationId", associationId()).add("Format", formatAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mergedApiIdentifier":
            return Optional.ofNullable(clazz.cast(mergedApiIdentifier()));
        case "associationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mergedApiIdentifier", MERGED_API_IDENTIFIER_FIELD);
        map.put("associationId", ASSOCIATION_ID_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTypesByAssociationRequest, T> g) {
        return obj -> g.apply((ListTypesByAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTypesByAssociationRequest> {
        /**
         * <p>
         * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
         * APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
         * APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
         * </p>
         * 
         * @param mergedApiIdentifier
         *        The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases,
         *        Merged APIs (especially in your account) only require the API ID value or ARN of the merged API.
         *        However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource
         *        ARN of the merged API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedApiIdentifier(String mergedApiIdentifier);

        /**
         * <p>
         * The ID generated by the AppSync service for the source API association.
         * </p>
         * 
         * @param associationId
         *        The ID generated by the AppSync service for the source API association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The format type.
         * </p>
         * 
         * @param format
         *        The format type.
         * @see TypeDefinitionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypeDefinitionFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format type.
         * </p>
         * 
         * @param format
         *        The format type.
         * @see TypeDefinitionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypeDefinitionFormat
         */
        Builder format(TypeDefinitionFormat format);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which you can use to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which you can use to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results that you want the request to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that you want the request to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String mergedApiIdentifier;

        private String associationId;

        private String format;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypesByAssociationRequest model) {
            super(model);
            mergedApiIdentifier(model.mergedApiIdentifier);
            associationId(model.associationId);
            format(model.format);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getMergedApiIdentifier() {
            return mergedApiIdentifier;
        }

        public final void setMergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
        }

        @Override
        public final Builder mergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
            return this;
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TypeDefinitionFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTypesByAssociationRequest build() {
            return new ListTypesByAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
