/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApiRequest extends AppSyncRequest implements
        ToCopyableBuilder<UpdateApiRequest.Builder, UpdateApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(UpdateApiRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateApiRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_CONTACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerContact").getter(getter(UpdateApiRequest::ownerContact)).setter(setter(Builder::ownerContact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerContact").build()).build();

    private static final SdkField<EventConfig> EVENT_CONFIG_FIELD = SdkField.<EventConfig> builder(MarshallingType.SDK_POJO)
            .memberName("eventConfig").getter(getter(UpdateApiRequest::eventConfig)).setter(setter(Builder::eventConfig))
            .constructor(EventConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD,
            OWNER_CONTACT_FIELD, EVENT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String apiId;

    private final String name;

    private final String ownerContact;

    private final EventConfig eventConfig;

    private UpdateApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.ownerContact = builder.ownerContact;
        this.eventConfig = builder.eventConfig;
    }

    /**
     * <p>
     * The <code>Api</code> ID.
     * </p>
     * 
     * @return The <code>Api</code> ID.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The name of the Api.
     * </p>
     * 
     * @return The name of the Api.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner contact information for the <code>Api</code>.
     * </p>
     * 
     * @return The owner contact information for the <code>Api</code>.
     */
    public final String ownerContact() {
        return ownerContact;
    }

    /**
     * <p>
     * The new event configuration. This includes the default authorization configuration for connecting, publishing,
     * and subscribing to an Event API.
     * </p>
     * 
     * @return The new event configuration. This includes the default authorization configuration for connecting,
     *         publishing, and subscribing to an Event API.
     */
    public final EventConfig eventConfig() {
        return eventConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerContact());
        hashCode = 31 * hashCode + Objects.hashCode(eventConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiRequest)) {
            return false;
        }
        UpdateApiRequest other = (UpdateApiRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerContact(), other.ownerContact()) && Objects.equals(eventConfig(), other.eventConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApiRequest").add("ApiId", apiId()).add("Name", name()).add("OwnerContact", ownerContact())
                .add("EventConfig", eventConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ownerContact":
            return Optional.ofNullable(clazz.cast(ownerContact()));
        case "eventConfig":
            return Optional.ofNullable(clazz.cast(eventConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiId", API_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ownerContact", OWNER_CONTACT_FIELD);
        map.put("eventConfig", EVENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiRequest, T> g) {
        return obj -> g.apply((UpdateApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApiRequest> {
        /**
         * <p>
         * The <code>Api</code> ID.
         * </p>
         * 
         * @param apiId
         *        The <code>Api</code> ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The name of the Api.
         * </p>
         * 
         * @param name
         *        The name of the Api.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner contact information for the <code>Api</code>.
         * </p>
         * 
         * @param ownerContact
         *        The owner contact information for the <code>Api</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerContact(String ownerContact);

        /**
         * <p>
         * The new event configuration. This includes the default authorization configuration for connecting,
         * publishing, and subscribing to an Event API.
         * </p>
         * 
         * @param eventConfig
         *        The new event configuration. This includes the default authorization configuration for connecting,
         *        publishing, and subscribing to an Event API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfig(EventConfig eventConfig);

        /**
         * <p>
         * The new event configuration. This includes the default authorization configuration for connecting,
         * publishing, and subscribing to an Event API.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventConfig.Builder} avoiding the need to
         * create one manually via {@link EventConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #eventConfig(EventConfig)}.
         * 
         * @param eventConfig
         *        a consumer that will call methods on {@link EventConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventConfig(EventConfig)
         */
        default Builder eventConfig(Consumer<EventConfig.Builder> eventConfig) {
            return eventConfig(EventConfig.builder().applyMutation(eventConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String name;

        private String ownerContact;

        private EventConfig eventConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiRequest model) {
            super(model);
            apiId(model.apiId);
            name(model.name);
            ownerContact(model.ownerContact);
            eventConfig(model.eventConfig);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerContact() {
            return ownerContact;
        }

        public final void setOwnerContact(String ownerContact) {
            this.ownerContact = ownerContact;
        }

        @Override
        public final Builder ownerContact(String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        public final EventConfig.Builder getEventConfig() {
            return eventConfig != null ? eventConfig.toBuilder() : null;
        }

        public final void setEventConfig(EventConfig.BuilderImpl eventConfig) {
            this.eventConfig = eventConfig != null ? eventConfig.build() : null;
        }

        @Override
        public final Builder eventConfig(EventConfig eventConfig) {
            this.eventConfig = eventConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiRequest build() {
            return new UpdateApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
