/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApiResponse extends AppSyncResponse implements
        ToCopyableBuilder<UpdateApiResponse.Builder, UpdateApiResponse> {
    private static final SdkField<Api> API_FIELD = SdkField.<Api> builder(MarshallingType.SDK_POJO).memberName("api")
            .getter(getter(UpdateApiResponse::api)).setter(setter(Builder::api)).constructor(Api::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("api").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Api api;

    private UpdateApiResponse(BuilderImpl builder) {
        super(builder);
        this.api = builder.api;
    }

    /**
     * <p>
     * The <code>Api</code> object.
     * </p>
     * 
     * @return The <code>Api</code> object.
     */
    public final Api api() {
        return api;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(api());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiResponse)) {
            return false;
        }
        UpdateApiResponse other = (UpdateApiResponse) obj;
        return Objects.equals(api(), other.api());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApiResponse").add("Api", api()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "api":
            return Optional.ofNullable(clazz.cast(api()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("api", API_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiResponse, T> g) {
        return obj -> g.apply((UpdateApiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApiResponse> {
        /**
         * <p>
         * The <code>Api</code> object.
         * </p>
         * 
         * @param api
         *        The <code>Api</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder api(Api api);

        /**
         * <p>
         * The <code>Api</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link Api.Builder} avoiding the need to create
         * one manually via {@link Api#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Api.Builder#build()} is called immediately and its result is
         * passed to {@link #api(Api)}.
         * 
         * @param api
         *        a consumer that will call methods on {@link Api.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #api(Api)
         */
        default Builder api(Consumer<Api.Builder> api) {
            return api(Api.builder().applyMutation(api).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private Api api;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiResponse model) {
            super(model);
            api(model.api);
        }

        public final Api.Builder getApi() {
            return api != null ? api.toBuilder() : null;
        }

        public final void setApi(Api.BuilderImpl api) {
            this.api = api != null ? api.build() : null;
        }

        @Override
        public final Builder api(Api api) {
            this.api = api;
            return this;
        }

        @Override
        public UpdateApiResponse build() {
            return new UpdateApiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
