/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSourceApiAssociationResponse extends AppSyncResponse implements
        ToCopyableBuilder<UpdateSourceApiAssociationResponse.Builder, UpdateSourceApiAssociationResponse> {
    private static final SdkField<SourceApiAssociation> SOURCE_API_ASSOCIATION_FIELD = SdkField
            .<SourceApiAssociation> builder(MarshallingType.SDK_POJO).memberName("sourceApiAssociation")
            .getter(getter(UpdateSourceApiAssociationResponse::sourceApiAssociation))
            .setter(setter(Builder::sourceApiAssociation)).constructor(SourceApiAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_API_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SourceApiAssociation sourceApiAssociation;

    private UpdateSourceApiAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.sourceApiAssociation = builder.sourceApiAssociation;
    }

    /**
     * <p>
     * The <code>SourceApiAssociation</code> object data.
     * </p>
     * 
     * @return The <code>SourceApiAssociation</code> object data.
     */
    public final SourceApiAssociation sourceApiAssociation() {
        return sourceApiAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceApiAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSourceApiAssociationResponse)) {
            return false;
        }
        UpdateSourceApiAssociationResponse other = (UpdateSourceApiAssociationResponse) obj;
        return Objects.equals(sourceApiAssociation(), other.sourceApiAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSourceApiAssociationResponse").add("SourceApiAssociation", sourceApiAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceApiAssociation":
            return Optional.ofNullable(clazz.cast(sourceApiAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceApiAssociation", SOURCE_API_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSourceApiAssociationResponse, T> g) {
        return obj -> g.apply((UpdateSourceApiAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSourceApiAssociationResponse> {
        /**
         * <p>
         * The <code>SourceApiAssociation</code> object data.
         * </p>
         * 
         * @param sourceApiAssociation
         *        The <code>SourceApiAssociation</code> object data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApiAssociation(SourceApiAssociation sourceApiAssociation);

        /**
         * <p>
         * The <code>SourceApiAssociation</code> object data.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceApiAssociation.Builder} avoiding
         * the need to create one manually via {@link SourceApiAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceApiAssociation.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceApiAssociation(SourceApiAssociation)}.
         * 
         * @param sourceApiAssociation
         *        a consumer that will call methods on {@link SourceApiAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceApiAssociation(SourceApiAssociation)
         */
        default Builder sourceApiAssociation(Consumer<SourceApiAssociation.Builder> sourceApiAssociation) {
            return sourceApiAssociation(SourceApiAssociation.builder().applyMutation(sourceApiAssociation).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private SourceApiAssociation sourceApiAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSourceApiAssociationResponse model) {
            super(model);
            sourceApiAssociation(model.sourceApiAssociation);
        }

        public final SourceApiAssociation.Builder getSourceApiAssociation() {
            return sourceApiAssociation != null ? sourceApiAssociation.toBuilder() : null;
        }

        public final void setSourceApiAssociation(SourceApiAssociation.BuilderImpl sourceApiAssociation) {
            this.sourceApiAssociation = sourceApiAssociation != null ? sourceApiAssociation.build() : null;
        }

        @Override
        public final Builder sourceApiAssociation(SourceApiAssociation sourceApiAssociation) {
            this.sourceApiAssociation = sourceApiAssociation;
            return this;
        }

        @Override
        public UpdateSourceApiAssociationResponse build() {
            return new UpdateSourceApiAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
