/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides further details for the reason behind the bad request. For reason type <code>CODE_ERROR</code>, the detail
 * will contain a list of code errors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BadRequestDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<BadRequestDetail.Builder, BadRequestDetail> {
    private static final SdkField<List<CodeError>> CODE_ERRORS_FIELD = SdkField
            .<List<CodeError>> builder(MarshallingType.LIST)
            .memberName("codeErrors")
            .getter(getter(BadRequestDetail::codeErrors))
            .setter(setter(Builder::codeErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeError> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CodeError> codeErrors;

    private BadRequestDetail(BuilderImpl builder) {
        this.codeErrors = builder.codeErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeErrors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCodeErrors() {
        return codeErrors != null && !(codeErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the list of errors in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeErrors} method.
     * </p>
     * 
     * @return Contains the list of errors in the request.
     */
    public final List<CodeError> codeErrors() {
        return codeErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeErrors() ? codeErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BadRequestDetail)) {
            return false;
        }
        BadRequestDetail other = (BadRequestDetail) obj;
        return hasCodeErrors() == other.hasCodeErrors() && Objects.equals(codeErrors(), other.codeErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BadRequestDetail").add("CodeErrors", hasCodeErrors() ? codeErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeErrors":
            return Optional.ofNullable(clazz.cast(codeErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeErrors", CODE_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BadRequestDetail, T> g) {
        return obj -> g.apply((BadRequestDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BadRequestDetail> {
        /**
         * <p>
         * Contains the list of errors in the request.
         * </p>
         * 
         * @param codeErrors
         *        Contains the list of errors in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeErrors(Collection<CodeError> codeErrors);

        /**
         * <p>
         * Contains the list of errors in the request.
         * </p>
         * 
         * @param codeErrors
         *        Contains the list of errors in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeErrors(CodeError... codeErrors);

        /**
         * <p>
         * Contains the list of errors in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.CodeError.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appsync.model.CodeError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.CodeError.Builder#build()} is called immediately and its
         * result is passed to {@link #codeErrors(List<CodeError>)}.
         * 
         * @param codeErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.CodeError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeErrors(java.util.Collection<CodeError>)
         */
        Builder codeErrors(Consumer<CodeError.Builder>... codeErrors);
    }

    static final class BuilderImpl implements Builder {
        private List<CodeError> codeErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BadRequestDetail model) {
            codeErrors(model.codeErrors);
        }

        public final List<CodeError.Builder> getCodeErrors() {
            List<CodeError.Builder> result = CodeErrorsCopier.copyToBuilder(this.codeErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeErrors(Collection<CodeError.BuilderImpl> codeErrors) {
            this.codeErrors = CodeErrorsCopier.copyFromBuilder(codeErrors);
        }

        @Override
        public final Builder codeErrors(Collection<CodeError> codeErrors) {
            this.codeErrors = CodeErrorsCopier.copy(codeErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeErrors(CodeError... codeErrors) {
            codeErrors(Arrays.asList(codeErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeErrors(Consumer<CodeError.Builder>... codeErrors) {
            codeErrors(Stream.of(codeErrors).map(c -> CodeError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BadRequestDetail build() {
            return new BadRequestDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
