/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelNamespaceRequest extends AppSyncRequest implements
        ToCopyableBuilder<CreateChannelNamespaceRequest.Builder, CreateChannelNamespaceRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(CreateChannelNamespaceRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateChannelNamespaceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<AuthMode>> SUBSCRIBE_AUTH_MODES_FIELD = SdkField
            .<List<AuthMode>> builder(MarshallingType.LIST)
            .memberName("subscribeAuthModes")
            .getter(getter(CreateChannelNamespaceRequest::subscribeAuthModes))
            .setter(setter(Builder::subscribeAuthModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribeAuthModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthMode> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthMode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AuthMode>> PUBLISH_AUTH_MODES_FIELD = SdkField
            .<List<AuthMode>> builder(MarshallingType.LIST)
            .memberName("publishAuthModes")
            .getter(getter(CreateChannelNamespaceRequest::publishAuthModes))
            .setter(setter(Builder::publishAuthModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishAuthModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthMode> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthMode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CODE_HANDLERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeHandlers").getter(getter(CreateChannelNamespaceRequest::codeHandlers))
            .setter(setter(Builder::codeHandlers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeHandlers").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateChannelNamespaceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD,
            SUBSCRIBE_AUTH_MODES_FIELD, PUBLISH_AUTH_MODES_FIELD, CODE_HANDLERS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String apiId;

    private final String name;

    private final List<AuthMode> subscribeAuthModes;

    private final List<AuthMode> publishAuthModes;

    private final String codeHandlers;

    private final Map<String, String> tags;

    private CreateChannelNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.subscribeAuthModes = builder.subscribeAuthModes;
        this.publishAuthModes = builder.publishAuthModes;
        this.codeHandlers = builder.codeHandlers;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The <code>Api</code> ID.
     * </p>
     * 
     * @return The <code>Api</code> ID.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The name of the <code>ChannelNamespace</code>. This name must be unique within the <code>Api</code>
     * </p>
     * 
     * @return The name of the <code>ChannelNamespace</code>. This name must be unique within the <code>Api</code>
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscribeAuthModes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribeAuthModes() {
        return subscribeAuthModes != null && !(subscribeAuthModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authorization mode to use for subscribing to messages on the channel namespace. This configuration overrides
     * the default <code>Api</code> authorization configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribeAuthModes} method.
     * </p>
     * 
     * @return The authorization mode to use for subscribing to messages on the channel namespace. This configuration
     *         overrides the default <code>Api</code> authorization configuration.
     */
    public final List<AuthMode> subscribeAuthModes() {
        return subscribeAuthModes;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublishAuthModes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPublishAuthModes() {
        return publishAuthModes != null && !(publishAuthModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authorization mode to use for publishing messages on the channel namespace. This configuration overrides the
     * default <code>Api</code> authorization configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublishAuthModes} method.
     * </p>
     * 
     * @return The authorization mode to use for publishing messages on the channel namespace. This configuration
     *         overrides the default <code>Api</code> authorization configuration.
     */
    public final List<AuthMode> publishAuthModes() {
        return publishAuthModes;
    }

    /**
     * <p>
     * The event handler functions that run custom business logic to process published events and subscribe requests.
     * </p>
     * 
     * @return The event handler functions that run custom business logic to process published events and subscribe
     *         requests.
     */
    public final String codeHandlers() {
        return codeHandlers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribeAuthModes() ? subscribeAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPublishAuthModes() ? publishAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(codeHandlers());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelNamespaceRequest)) {
            return false;
        }
        CreateChannelNamespaceRequest other = (CreateChannelNamespaceRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(name(), other.name())
                && hasSubscribeAuthModes() == other.hasSubscribeAuthModes()
                && Objects.equals(subscribeAuthModes(), other.subscribeAuthModes())
                && hasPublishAuthModes() == other.hasPublishAuthModes()
                && Objects.equals(publishAuthModes(), other.publishAuthModes())
                && Objects.equals(codeHandlers(), other.codeHandlers()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelNamespaceRequest").add("ApiId", apiId()).add("Name", name())
                .add("SubscribeAuthModes", hasSubscribeAuthModes() ? subscribeAuthModes() : null)
                .add("PublishAuthModes", hasPublishAuthModes() ? publishAuthModes() : null).add("CodeHandlers", codeHandlers())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "subscribeAuthModes":
            return Optional.ofNullable(clazz.cast(subscribeAuthModes()));
        case "publishAuthModes":
            return Optional.ofNullable(clazz.cast(publishAuthModes()));
        case "codeHandlers":
            return Optional.ofNullable(clazz.cast(codeHandlers()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiId", API_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("subscribeAuthModes", SUBSCRIBE_AUTH_MODES_FIELD);
        map.put("publishAuthModes", PUBLISH_AUTH_MODES_FIELD);
        map.put("codeHandlers", CODE_HANDLERS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelNamespaceRequest, T> g) {
        return obj -> g.apply((CreateChannelNamespaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelNamespaceRequest> {
        /**
         * <p>
         * The <code>Api</code> ID.
         * </p>
         * 
         * @param apiId
         *        The <code>Api</code> ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The name of the <code>ChannelNamespace</code>. This name must be unique within the <code>Api</code>
         * </p>
         * 
         * @param name
         *        The name of the <code>ChannelNamespace</code>. This name must be unique within the <code>Api</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The authorization mode to use for subscribing to messages on the channel namespace. This configuration
         * overrides the default <code>Api</code> authorization configuration.
         * </p>
         * 
         * @param subscribeAuthModes
         *        The authorization mode to use for subscribing to messages on the channel namespace. This configuration
         *        overrides the default <code>Api</code> authorization configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribeAuthModes(Collection<AuthMode> subscribeAuthModes);

        /**
         * <p>
         * The authorization mode to use for subscribing to messages on the channel namespace. This configuration
         * overrides the default <code>Api</code> authorization configuration.
         * </p>
         * 
         * @param subscribeAuthModes
         *        The authorization mode to use for subscribing to messages on the channel namespace. This configuration
         *        overrides the default <code>Api</code> authorization configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribeAuthModes(AuthMode... subscribeAuthModes);

        /**
         * <p>
         * The authorization mode to use for subscribing to messages on the channel namespace. This configuration
         * overrides the default <code>Api</code> authorization configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appsync.model.AuthMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder#build()} is called immediately and its
         * result is passed to {@link #subscribeAuthModes(List<AuthMode>)}.
         * 
         * @param subscribeAuthModes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribeAuthModes(java.util.Collection<AuthMode>)
         */
        Builder subscribeAuthModes(Consumer<AuthMode.Builder>... subscribeAuthModes);

        /**
         * <p>
         * The authorization mode to use for publishing messages on the channel namespace. This configuration overrides
         * the default <code>Api</code> authorization configuration.
         * </p>
         * 
         * @param publishAuthModes
         *        The authorization mode to use for publishing messages on the channel namespace. This configuration
         *        overrides the default <code>Api</code> authorization configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishAuthModes(Collection<AuthMode> publishAuthModes);

        /**
         * <p>
         * The authorization mode to use for publishing messages on the channel namespace. This configuration overrides
         * the default <code>Api</code> authorization configuration.
         * </p>
         * 
         * @param publishAuthModes
         *        The authorization mode to use for publishing messages on the channel namespace. This configuration
         *        overrides the default <code>Api</code> authorization configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishAuthModes(AuthMode... publishAuthModes);

        /**
         * <p>
         * The authorization mode to use for publishing messages on the channel namespace. This configuration overrides
         * the default <code>Api</code> authorization configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appsync.model.AuthMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder#build()} is called immediately and its
         * result is passed to {@link #publishAuthModes(List<AuthMode>)}.
         * 
         * @param publishAuthModes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.AuthMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publishAuthModes(java.util.Collection<AuthMode>)
         */
        Builder publishAuthModes(Consumer<AuthMode.Builder>... publishAuthModes);

        /**
         * <p>
         * The event handler functions that run custom business logic to process published events and subscribe
         * requests.
         * </p>
         * 
         * @param codeHandlers
         *        The event handler functions that run custom business logic to process published events and subscribe
         *        requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeHandlers(String codeHandlers);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String name;

        private List<AuthMode> subscribeAuthModes = DefaultSdkAutoConstructList.getInstance();

        private List<AuthMode> publishAuthModes = DefaultSdkAutoConstructList.getInstance();

        private String codeHandlers;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelNamespaceRequest model) {
            super(model);
            apiId(model.apiId);
            name(model.name);
            subscribeAuthModes(model.subscribeAuthModes);
            publishAuthModes(model.publishAuthModes);
            codeHandlers(model.codeHandlers);
            tags(model.tags);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AuthMode.Builder> getSubscribeAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.subscribeAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribeAuthModes(Collection<AuthMode.BuilderImpl> subscribeAuthModes) {
            this.subscribeAuthModes = AuthModesCopier.copyFromBuilder(subscribeAuthModes);
        }

        @Override
        public final Builder subscribeAuthModes(Collection<AuthMode> subscribeAuthModes) {
            this.subscribeAuthModes = AuthModesCopier.copy(subscribeAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribeAuthModes(AuthMode... subscribeAuthModes) {
            subscribeAuthModes(Arrays.asList(subscribeAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribeAuthModes(Consumer<AuthMode.Builder>... subscribeAuthModes) {
            subscribeAuthModes(Stream.of(subscribeAuthModes).map(c -> AuthMode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AuthMode.Builder> getPublishAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.publishAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPublishAuthModes(Collection<AuthMode.BuilderImpl> publishAuthModes) {
            this.publishAuthModes = AuthModesCopier.copyFromBuilder(publishAuthModes);
        }

        @Override
        public final Builder publishAuthModes(Collection<AuthMode> publishAuthModes) {
            this.publishAuthModes = AuthModesCopier.copy(publishAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publishAuthModes(AuthMode... publishAuthModes) {
            publishAuthModes(Arrays.asList(publishAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publishAuthModes(Consumer<AuthMode.Builder>... publishAuthModes) {
            publishAuthModes(Stream.of(publishAuthModes).map(c -> AuthMode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCodeHandlers() {
            return codeHandlers;
        }

        public final void setCodeHandlers(String codeHandlers) {
            this.codeHandlers = codeHandlers;
        }

        @Override
        public final Builder codeHandlers(String codeHandlers) {
            this.codeHandlers = codeHandlers;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelNamespaceRequest build() {
            return new CreateChannelNamespaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
