/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGraphqlApiRequest extends AppSyncRequest implements
        ToCopyableBuilder<CreateGraphqlApiRequest.Builder, CreateGraphqlApiRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGraphqlApiRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<LogConfig> LOG_CONFIG_FIELD = SdkField.<LogConfig> builder(MarshallingType.SDK_POJO)
            .memberName("logConfig").getter(getter(CreateGraphqlApiRequest::logConfig)).setter(setter(Builder::logConfig))
            .constructor(LogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(CreateGraphqlApiRequest::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<UserPoolConfig> USER_POOL_CONFIG_FIELD = SdkField
            .<UserPoolConfig> builder(MarshallingType.SDK_POJO).memberName("userPoolConfig")
            .getter(getter(CreateGraphqlApiRequest::userPoolConfig)).setter(setter(Builder::userPoolConfig))
            .constructor(UserPoolConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfig").build()).build();

    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField
            .<OpenIDConnectConfig> builder(MarshallingType.SDK_POJO).memberName("openIDConnectConfig")
            .getter(getter(CreateGraphqlApiRequest::openIDConnectConfig)).setter(setter(Builder::openIDConnectConfig))
            .constructor(OpenIDConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateGraphqlApiRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AdditionalAuthenticationProvider>> ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD = SdkField
            .<List<AdditionalAuthenticationProvider>> builder(MarshallingType.LIST)
            .memberName("additionalAuthenticationProviders")
            .getter(getter(CreateGraphqlApiRequest::additionalAuthenticationProviders))
            .setter(setter(Builder::additionalAuthenticationProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAuthenticationProviders")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalAuthenticationProvider> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalAuthenticationProvider::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("xrayEnabled").getter(getter(CreateGraphqlApiRequest::xrayEnabled)).setter(setter(Builder::xrayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xrayEnabled").build()).build();

    private static final SdkField<LambdaAuthorizerConfig> LAMBDA_AUTHORIZER_CONFIG_FIELD = SdkField
            .<LambdaAuthorizerConfig> builder(MarshallingType.SDK_POJO).memberName("lambdaAuthorizerConfig")
            .getter(getter(CreateGraphqlApiRequest::lambdaAuthorizerConfig)).setter(setter(Builder::lambdaAuthorizerConfig))
            .constructor(LambdaAuthorizerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaAuthorizerConfig").build())
            .build();

    private static final SdkField<String> API_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiType").getter(getter(CreateGraphqlApiRequest::apiTypeAsString)).setter(setter(Builder::apiType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiType").build()).build();

    private static final SdkField<String> MERGED_API_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergedApiExecutionRoleArn").getter(getter(CreateGraphqlApiRequest::mergedApiExecutionRoleArn))
            .setter(setter(Builder::mergedApiExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedApiExecutionRoleArn").build())
            .build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibility").getter(getter(CreateGraphqlApiRequest::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibility").build()).build();

    private static final SdkField<String> OWNER_CONTACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerContact").getter(getter(CreateGraphqlApiRequest::ownerContact))
            .setter(setter(Builder::ownerContact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerContact").build()).build();

    private static final SdkField<String> INTROSPECTION_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("introspectionConfig").getter(getter(CreateGraphqlApiRequest::introspectionConfigAsString))
            .setter(setter(Builder::introspectionConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("introspectionConfig").build())
            .build();

    private static final SdkField<Integer> QUERY_DEPTH_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queryDepthLimit").getter(getter(CreateGraphqlApiRequest::queryDepthLimit))
            .setter(setter(Builder::queryDepthLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryDepthLimit").build()).build();

    private static final SdkField<Integer> RESOLVER_COUNT_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("resolverCountLimit").getter(getter(CreateGraphqlApiRequest::resolverCountLimit))
            .setter(setter(Builder::resolverCountLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverCountLimit").build())
            .build();

    private static final SdkField<EnhancedMetricsConfig> ENHANCED_METRICS_CONFIG_FIELD = SdkField
            .<EnhancedMetricsConfig> builder(MarshallingType.SDK_POJO).memberName("enhancedMetricsConfig")
            .getter(getter(CreateGraphqlApiRequest::enhancedMetricsConfig)).setter(setter(Builder::enhancedMetricsConfig))
            .constructor(EnhancedMetricsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMetricsConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LOG_CONFIG_FIELD,
            AUTHENTICATION_TYPE_FIELD, USER_POOL_CONFIG_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD, TAGS_FIELD,
            ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD, XRAY_ENABLED_FIELD, LAMBDA_AUTHORIZER_CONFIG_FIELD, API_TYPE_FIELD,
            MERGED_API_EXECUTION_ROLE_ARN_FIELD, VISIBILITY_FIELD, OWNER_CONTACT_FIELD, INTROSPECTION_CONFIG_FIELD,
            QUERY_DEPTH_LIMIT_FIELD, RESOLVER_COUNT_LIMIT_FIELD, ENHANCED_METRICS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final LogConfig logConfig;

    private final String authenticationType;

    private final UserPoolConfig userPoolConfig;

    private final OpenIDConnectConfig openIDConnectConfig;

    private final Map<String, String> tags;

    private final List<AdditionalAuthenticationProvider> additionalAuthenticationProviders;

    private final Boolean xrayEnabled;

    private final LambdaAuthorizerConfig lambdaAuthorizerConfig;

    private final String apiType;

    private final String mergedApiExecutionRoleArn;

    private final String visibility;

    private final String ownerContact;

    private final String introspectionConfig;

    private final Integer queryDepthLimit;

    private final Integer resolverCountLimit;

    private final EnhancedMetricsConfig enhancedMetricsConfig;

    private CreateGraphqlApiRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.logConfig = builder.logConfig;
        this.authenticationType = builder.authenticationType;
        this.userPoolConfig = builder.userPoolConfig;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.tags = builder.tags;
        this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
        this.xrayEnabled = builder.xrayEnabled;
        this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
        this.apiType = builder.apiType;
        this.mergedApiExecutionRoleArn = builder.mergedApiExecutionRoleArn;
        this.visibility = builder.visibility;
        this.ownerContact = builder.ownerContact;
        this.introspectionConfig = builder.introspectionConfig;
        this.queryDepthLimit = builder.queryDepthLimit;
        this.resolverCountLimit = builder.resolverCountLimit;
        this.enhancedMetricsConfig = builder.enhancedMetricsConfig;
    }

    /**
     * <p>
     * A user-supplied name for the <code>GraphqlApi</code>.
     * </p>
     * 
     * @return A user-supplied name for the <code>GraphqlApi</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon CloudWatch Logs configuration.
     * </p>
     * 
     * @return The Amazon CloudWatch Logs configuration.
     */
    public final LogConfig logConfig() {
        return logConfig;
    }

    /**
     * <p>
     * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito
     * user pools, or Lambda.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon
     *         Cognito user pools, or Lambda.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito
     * user pools, or Lambda.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon
     *         Cognito user pools, or Lambda.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The Amazon Cognito user pool configuration.
     * </p>
     * 
     * @return The Amazon Cognito user pool configuration.
     */
    public final UserPoolConfig userPoolConfig() {
        return userPoolConfig;
    }

    /**
     * <p>
     * The OIDC configuration.
     * </p>
     * 
     * @return The OIDC configuration.
     */
    public final OpenIDConnectConfig openIDConnectConfig() {
        return openIDConnectConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A <code>TagMap</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A <code>TagMap</code> object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAuthenticationProviders
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalAuthenticationProviders() {
        return additionalAuthenticationProviders != null && !(additionalAuthenticationProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of additional authentication providers for the <code>GraphqlApi</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAuthenticationProviders}
     * method.
     * </p>
     * 
     * @return A list of additional authentication providers for the <code>GraphqlApi</code> API.
     */
    public final List<AdditionalAuthenticationProvider> additionalAuthenticationProviders() {
        return additionalAuthenticationProviders;
    }

    /**
     * <p>
     * A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.
     * </p>
     * 
     * @return A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.
     */
    public final Boolean xrayEnabled() {
        return xrayEnabled;
    }

    /**
     * <p>
     * Configuration for Lambda function authorization.
     * </p>
     * 
     * @return Configuration for Lambda function authorization.
     */
    public final LambdaAuthorizerConfig lambdaAuthorizerConfig() {
        return lambdaAuthorizerConfig;
    }

    /**
     * <p>
     * The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
     * <code>MERGED</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiType} will
     * return {@link GraphQLApiType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiTypeAsString}.
     * </p>
     * 
     * @return The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
     *         <code>MERGED</code>).
     * @see GraphQLApiType
     */
    public final GraphQLApiType apiType() {
        return GraphQLApiType.fromValue(apiType);
    }

    /**
     * <p>
     * The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
     * <code>MERGED</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiType} will
     * return {@link GraphQLApiType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiTypeAsString}.
     * </p>
     * 
     * @return The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
     *         <code>MERGED</code>).
     * @see GraphQLApiType
     */
    public final String apiTypeAsString() {
        return apiType;
    }

    /**
     * <p>
     * The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role on
     * behalf of the Merged API to validate access to source APIs at runtime and to prompt the <code>AUTO_MERGE</code>
     * to update the merged API endpoint with the source API changes automatically.
     * </p>
     * 
     * @return The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this
     *         role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the
     *         <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.
     */
    public final String mergedApiExecutionRoleArn() {
        return mergedApiExecutionRoleArn;
    }

    /**
     * <p>
     * Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>). If no value
     * is provided, the visibility will be set to <code>GLOBAL</code> by default. This value cannot be changed once the
     * API has been created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link GraphQLApiVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>). If
     *         no value is provided, the visibility will be set to <code>GLOBAL</code> by default. This value cannot be
     *         changed once the API has been created.
     * @see GraphQLApiVisibility
     */
    public final GraphQLApiVisibility visibility() {
        return GraphQLApiVisibility.fromValue(visibility);
    }

    /**
     * <p>
     * Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>). If no value
     * is provided, the visibility will be set to <code>GLOBAL</code> by default. This value cannot be changed once the
     * API has been created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link GraphQLApiVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>). If
     *         no value is provided, the visibility will be set to <code>GLOBAL</code> by default. This value cannot be
     *         changed once the API has been created.
     * @see GraphQLApiVisibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The owner contact information for an API resource.
     * </p>
     * <p>
     * This field accepts any string input with a length of 0 - 256 characters.
     * </p>
     * 
     * @return The owner contact information for an API resource.</p>
     *         <p>
     *         This field accepts any string input with a length of 0 - 256 characters.
     */
    public final String ownerContact() {
        return ownerContact;
    }

    /**
     * <p>
     * Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>)
     * introspection. If no value is provided, the introspection configuration will be set to <code>ENABLED</code> by
     * default. This field will produce an error if the operation attempts to use the introspection feature while this
     * field is disabled.
     * </p>
     * <p>
     * For more information about introspection, see <a href="https://graphql.org/learn/introspection/">GraphQL
     * introspection</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #introspectionConfig} will return {@link GraphQLApiIntrospectionConfig#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #introspectionConfigAsString}.
     * </p>
     * 
     * @return Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>)
     *         introspection. If no value is provided, the introspection configuration will be set to
     *         <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the
     *         introspection feature while this field is disabled.</p>
     *         <p>
     *         For more information about introspection, see <a href="https://graphql.org/learn/introspection/">GraphQL
     *         introspection</a>.
     * @see GraphQLApiIntrospectionConfig
     */
    public final GraphQLApiIntrospectionConfig introspectionConfig() {
        return GraphQLApiIntrospectionConfig.fromValue(introspectionConfig);
    }

    /**
     * <p>
     * Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>)
     * introspection. If no value is provided, the introspection configuration will be set to <code>ENABLED</code> by
     * default. This field will produce an error if the operation attempts to use the introspection feature while this
     * field is disabled.
     * </p>
     * <p>
     * For more information about introspection, see <a href="https://graphql.org/learn/introspection/">GraphQL
     * introspection</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #introspectionConfig} will return {@link GraphQLApiIntrospectionConfig#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #introspectionConfigAsString}.
     * </p>
     * 
     * @return Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>)
     *         introspection. If no value is provided, the introspection configuration will be set to
     *         <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the
     *         introspection feature while this field is disabled.</p>
     *         <p>
     *         For more information about introspection, see <a href="https://graphql.org/learn/introspection/">GraphQL
     *         introspection</a>.
     * @see GraphQLApiIntrospectionConfig
     */
    public final String introspectionConfigAsString() {
        return introspectionConfig;
    }

    /**
     * <p>
     * The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in
     * the body of query. The default value is <code>0</code> (or unspecified), which indicates there's no depth limit.
     * If you set a limit, it can be between <code>1</code> and <code>75</code> nested levels. This field will produce a
     * limit error if the operation falls out of bounds.
     * </p>
     * <p>
     * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the
     * error will be thrown upwards to the first nullable field available.
     * </p>
     * 
     * @return The maximum depth a query can have in a single request. Depth refers to the amount of nested levels
     *         allowed in the body of query. The default value is <code>0</code> (or unspecified), which indicates
     *         there's no depth limit. If you set a limit, it can be between <code>1</code> and <code>75</code> nested
     *         levels. This field will produce a limit error if the operation falls out of bounds.</p>
     *         <p>
     *         Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error,
     *         the error will be thrown upwards to the first nullable field available.
     */
    public final Integer queryDepthLimit() {
        return queryDepthLimit;
    }

    /**
     * <p>
     * The maximum number of resolvers that can be invoked in a single request. The default value is <code>0</code> (or
     * unspecified), which will set the limit to <code>10000</code>. When specified, the limit value can be between
     * <code>1</code> and <code>10000</code>. This field will produce a limit error if the operation falls out of
     * bounds.
     * </p>
     * 
     * @return The maximum number of resolvers that can be invoked in a single request. The default value is
     *         <code>0</code> (or unspecified), which will set the limit to <code>10000</code>. When specified, the
     *         limit value can be between <code>1</code> and <code>10000</code>. This field will produce a limit error
     *         if the operation falls out of bounds.
     */
    public final Integer resolverCountLimit() {
        return resolverCountLimit;
    }

    /**
     * <p>
     * The <code>enhancedMetricsConfig</code> object.
     * </p>
     * 
     * @return The <code>enhancedMetricsConfig</code> object.
     */
    public final EnhancedMetricsConfig enhancedMetricsConfig() {
        return enhancedMetricsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalAuthenticationProviders() ? additionalAuthenticationProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(xrayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaAuthorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(apiTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mergedApiExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerContact());
        hashCode = 31 * hashCode + Objects.hashCode(introspectionConfigAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryDepthLimit());
        hashCode = 31 * hashCode + Objects.hashCode(resolverCountLimit());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMetricsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphqlApiRequest)) {
            return false;
        }
        CreateGraphqlApiRequest other = (CreateGraphqlApiRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(logConfig(), other.logConfig())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(userPoolConfig(), other.userPoolConfig())
                && Objects.equals(openIDConnectConfig(), other.openIDConnectConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && hasAdditionalAuthenticationProviders() == other.hasAdditionalAuthenticationProviders()
                && Objects.equals(additionalAuthenticationProviders(), other.additionalAuthenticationProviders())
                && Objects.equals(xrayEnabled(), other.xrayEnabled())
                && Objects.equals(lambdaAuthorizerConfig(), other.lambdaAuthorizerConfig())
                && Objects.equals(apiTypeAsString(), other.apiTypeAsString())
                && Objects.equals(mergedApiExecutionRoleArn(), other.mergedApiExecutionRoleArn())
                && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(ownerContact(), other.ownerContact())
                && Objects.equals(introspectionConfigAsString(), other.introspectionConfigAsString())
                && Objects.equals(queryDepthLimit(), other.queryDepthLimit())
                && Objects.equals(resolverCountLimit(), other.resolverCountLimit())
                && Objects.equals(enhancedMetricsConfig(), other.enhancedMetricsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateGraphqlApiRequest")
                .add("Name", name())
                .add("LogConfig", logConfig())
                .add("AuthenticationType", authenticationTypeAsString())
                .add("UserPoolConfig", userPoolConfig())
                .add("OpenIDConnectConfig", openIDConnectConfig())
                .add("Tags", hasTags() ? tags() : null)
                .add("AdditionalAuthenticationProviders",
                        hasAdditionalAuthenticationProviders() ? additionalAuthenticationProviders() : null)
                .add("XrayEnabled", xrayEnabled()).add("LambdaAuthorizerConfig", lambdaAuthorizerConfig())
                .add("ApiType", apiTypeAsString()).add("MergedApiExecutionRoleArn", mergedApiExecutionRoleArn())
                .add("Visibility", visibilityAsString()).add("OwnerContact", ownerContact())
                .add("IntrospectionConfig", introspectionConfigAsString()).add("QueryDepthLimit", queryDepthLimit())
                .add("ResolverCountLimit", resolverCountLimit()).add("EnhancedMetricsConfig", enhancedMetricsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "logConfig":
            return Optional.ofNullable(clazz.cast(logConfig()));
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "userPoolConfig":
            return Optional.ofNullable(clazz.cast(userPoolConfig()));
        case "openIDConnectConfig":
            return Optional.ofNullable(clazz.cast(openIDConnectConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "additionalAuthenticationProviders":
            return Optional.ofNullable(clazz.cast(additionalAuthenticationProviders()));
        case "xrayEnabled":
            return Optional.ofNullable(clazz.cast(xrayEnabled()));
        case "lambdaAuthorizerConfig":
            return Optional.ofNullable(clazz.cast(lambdaAuthorizerConfig()));
        case "apiType":
            return Optional.ofNullable(clazz.cast(apiTypeAsString()));
        case "mergedApiExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(mergedApiExecutionRoleArn()));
        case "visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "ownerContact":
            return Optional.ofNullable(clazz.cast(ownerContact()));
        case "introspectionConfig":
            return Optional.ofNullable(clazz.cast(introspectionConfigAsString()));
        case "queryDepthLimit":
            return Optional.ofNullable(clazz.cast(queryDepthLimit()));
        case "resolverCountLimit":
            return Optional.ofNullable(clazz.cast(resolverCountLimit()));
        case "enhancedMetricsConfig":
            return Optional.ofNullable(clazz.cast(enhancedMetricsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("logConfig", LOG_CONFIG_FIELD);
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("userPoolConfig", USER_POOL_CONFIG_FIELD);
        map.put("openIDConnectConfig", OPEN_ID_CONNECT_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("additionalAuthenticationProviders", ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD);
        map.put("xrayEnabled", XRAY_ENABLED_FIELD);
        map.put("lambdaAuthorizerConfig", LAMBDA_AUTHORIZER_CONFIG_FIELD);
        map.put("apiType", API_TYPE_FIELD);
        map.put("mergedApiExecutionRoleArn", MERGED_API_EXECUTION_ROLE_ARN_FIELD);
        map.put("visibility", VISIBILITY_FIELD);
        map.put("ownerContact", OWNER_CONTACT_FIELD);
        map.put("introspectionConfig", INTROSPECTION_CONFIG_FIELD);
        map.put("queryDepthLimit", QUERY_DEPTH_LIMIT_FIELD);
        map.put("resolverCountLimit", RESOLVER_COUNT_LIMIT_FIELD);
        map.put("enhancedMetricsConfig", ENHANCED_METRICS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGraphqlApiRequest, T> g) {
        return obj -> g.apply((CreateGraphqlApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGraphqlApiRequest> {
        /**
         * <p>
         * A user-supplied name for the <code>GraphqlApi</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name for the <code>GraphqlApi</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration.
         * </p>
         * 
         * @param logConfig
         *        The Amazon CloudWatch Logs configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfig(LogConfig logConfig);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfig.Builder} avoiding the need to
         * create one manually via {@link LogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logConfig(LogConfig)}.
         * 
         * @param logConfig
         *        a consumer that will call methods on {@link LogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfig(LogConfig)
         */
        default Builder logConfig(Consumer<LogConfig.Builder> logConfig) {
            return logConfig(LogConfig.builder().applyMutation(logConfig).build());
        }

        /**
         * <p>
         * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito
         * user pools, or Lambda.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon
         *        Cognito user pools, or Lambda.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito
         * user pools, or Lambda.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon
         *        Cognito user pools, or Lambda.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * 
         * @param userPoolConfig
         *        The Amazon Cognito user pool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolConfig(UserPoolConfig userPoolConfig);

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserPoolConfig.Builder} avoiding the need
         * to create one manually via {@link UserPoolConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserPoolConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #userPoolConfig(UserPoolConfig)}.
         * 
         * @param userPoolConfig
         *        a consumer that will call methods on {@link UserPoolConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolConfig(UserPoolConfig)
         */
        default Builder userPoolConfig(Consumer<UserPoolConfig.Builder> userPoolConfig) {
            return userPoolConfig(UserPoolConfig.builder().applyMutation(userPoolConfig).build());
        }

        /**
         * <p>
         * The OIDC configuration.
         * </p>
         * 
         * @param openIDConnectConfig
         *        The OIDC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig);

        /**
         * <p>
         * The OIDC configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenIDConnectConfig.Builder} avoiding the
         * need to create one manually via {@link OpenIDConnectConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenIDConnectConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #openIDConnectConfig(OpenIDConnectConfig)}.
         * 
         * @param openIDConnectConfig
         *        a consumer that will call methods on {@link OpenIDConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIDConnectConfig(OpenIDConnectConfig)
         */
        default Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return openIDConnectConfig(OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig).build());
        }

        /**
         * <p>
         * A <code>TagMap</code> object.
         * </p>
         * 
         * @param tags
         *        A <code>TagMap</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(AdditionalAuthenticationProvider... additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #additionalAuthenticationProviders(List<AdditionalAuthenticationProvider>)}.
         * 
         * @param additionalAuthenticationProviders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAuthenticationProviders(java.util.Collection<AdditionalAuthenticationProvider>)
         */
        Builder additionalAuthenticationProviders(
                Consumer<AdditionalAuthenticationProvider.Builder>... additionalAuthenticationProviders);

        /**
         * <p>
         * A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.
         * </p>
         * 
         * @param xrayEnabled
         *        A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xrayEnabled(Boolean xrayEnabled);

        /**
         * <p>
         * Configuration for Lambda function authorization.
         * </p>
         * 
         * @param lambdaAuthorizerConfig
         *        Configuration for Lambda function authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig);

        /**
         * <p>
         * Configuration for Lambda function authorization.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaAuthorizerConfig.Builder} avoiding
         * the need to create one manually via {@link LambdaAuthorizerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaAuthorizerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaAuthorizerConfig(LambdaAuthorizerConfig)}.
         * 
         * @param lambdaAuthorizerConfig
         *        a consumer that will call methods on {@link LambdaAuthorizerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaAuthorizerConfig(LambdaAuthorizerConfig)
         */
        default Builder lambdaAuthorizerConfig(Consumer<LambdaAuthorizerConfig.Builder> lambdaAuthorizerConfig) {
            return lambdaAuthorizerConfig(LambdaAuthorizerConfig.builder().applyMutation(lambdaAuthorizerConfig).build());
        }

        /**
         * <p>
         * The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
         * <code>MERGED</code>).
         * </p>
         * 
         * @param apiType
         *        The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged
         *        API (<code>MERGED</code>).
         * @see GraphQLApiType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphQLApiType
         */
        Builder apiType(String apiType);

        /**
         * <p>
         * The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (
         * <code>MERGED</code>).
         * </p>
         * 
         * @param apiType
         *        The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged
         *        API (<code>MERGED</code>).
         * @see GraphQLApiType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphQLApiType
         */
        Builder apiType(GraphQLApiType apiType);

        /**
         * <p>
         * The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role
         * on behalf of the Merged API to validate access to source APIs at runtime and to prompt the
         * <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.
         * </p>
         * 
         * @param mergedApiExecutionRoleArn
         *        The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this
         *        role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the
         *        <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedApiExecutionRoleArn(String mergedApiExecutionRoleArn);

        /**
         * <p>
         * Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>). If no
         * value is provided, the visibility will be set to <code>GLOBAL</code> by default. This value cannot be changed
         * once the API has been created.
         * </p>
         * 
         * @param visibility
         *        Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>).
         *        If no value is provided, the visibility will be set to <code>GLOBAL</code> by default. This value
         *        cannot be changed once the API has been created.
         * @see GraphQLApiVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphQLApiVisibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>). If no
         * value is provided, the visibility will be set to <code>GLOBAL</code> by default. This value cannot be changed
         * once the API has been created.
         * </p>
         * 
         * @param visibility
         *        Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>).
         *        If no value is provided, the visibility will be set to <code>GLOBAL</code> by default. This value
         *        cannot be changed once the API has been created.
         * @see GraphQLApiVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphQLApiVisibility
         */
        Builder visibility(GraphQLApiVisibility visibility);

        /**
         * <p>
         * The owner contact information for an API resource.
         * </p>
         * <p>
         * This field accepts any string input with a length of 0 - 256 characters.
         * </p>
         * 
         * @param ownerContact
         *        The owner contact information for an API resource.</p>
         *        <p>
         *        This field accepts any string input with a length of 0 - 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerContact(String ownerContact);

        /**
         * <p>
         * Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>)
         * introspection. If no value is provided, the introspection configuration will be set to <code>ENABLED</code>
         * by default. This field will produce an error if the operation attempts to use the introspection feature while
         * this field is disabled.
         * </p>
         * <p>
         * For more information about introspection, see <a href="https://graphql.org/learn/introspection/">GraphQL
         * introspection</a>.
         * </p>
         * 
         * @param introspectionConfig
         *        Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>)
         *        introspection. If no value is provided, the introspection configuration will be set to
         *        <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the
         *        introspection feature while this field is disabled.</p>
         *        <p>
         *        For more information about introspection, see <a
         *        href="https://graphql.org/learn/introspection/">GraphQL introspection</a>.
         * @see GraphQLApiIntrospectionConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphQLApiIntrospectionConfig
         */
        Builder introspectionConfig(String introspectionConfig);

        /**
         * <p>
         * Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>)
         * introspection. If no value is provided, the introspection configuration will be set to <code>ENABLED</code>
         * by default. This field will produce an error if the operation attempts to use the introspection feature while
         * this field is disabled.
         * </p>
         * <p>
         * For more information about introspection, see <a href="https://graphql.org/learn/introspection/">GraphQL
         * introspection</a>.
         * </p>
         * 
         * @param introspectionConfig
         *        Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>)
         *        introspection. If no value is provided, the introspection configuration will be set to
         *        <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the
         *        introspection feature while this field is disabled.</p>
         *        <p>
         *        For more information about introspection, see <a
         *        href="https://graphql.org/learn/introspection/">GraphQL introspection</a>.
         * @see GraphQLApiIntrospectionConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphQLApiIntrospectionConfig
         */
        Builder introspectionConfig(GraphQLApiIntrospectionConfig introspectionConfig);

        /**
         * <p>
         * The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed
         * in the body of query. The default value is <code>0</code> (or unspecified), which indicates there's no depth
         * limit. If you set a limit, it can be between <code>1</code> and <code>75</code> nested levels. This field
         * will produce a limit error if the operation falls out of bounds.
         * </p>
         * <p>
         * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the
         * error will be thrown upwards to the first nullable field available.
         * </p>
         * 
         * @param queryDepthLimit
         *        The maximum depth a query can have in a single request. Depth refers to the amount of nested levels
         *        allowed in the body of query. The default value is <code>0</code> (or unspecified), which indicates
         *        there's no depth limit. If you set a limit, it can be between <code>1</code> and <code>75</code>
         *        nested levels. This field will produce a limit error if the operation falls out of bounds.</p>
         *        <p>
         *        Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an
         *        error, the error will be thrown upwards to the first nullable field available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryDepthLimit(Integer queryDepthLimit);

        /**
         * <p>
         * The maximum number of resolvers that can be invoked in a single request. The default value is <code>0</code>
         * (or unspecified), which will set the limit to <code>10000</code>. When specified, the limit value can be
         * between <code>1</code> and <code>10000</code>. This field will produce a limit error if the operation falls
         * out of bounds.
         * </p>
         * 
         * @param resolverCountLimit
         *        The maximum number of resolvers that can be invoked in a single request. The default value is
         *        <code>0</code> (or unspecified), which will set the limit to <code>10000</code>. When specified, the
         *        limit value can be between <code>1</code> and <code>10000</code>. This field will produce a limit
         *        error if the operation falls out of bounds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverCountLimit(Integer resolverCountLimit);

        /**
         * <p>
         * The <code>enhancedMetricsConfig</code> object.
         * </p>
         * 
         * @param enhancedMetricsConfig
         *        The <code>enhancedMetricsConfig</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedMetricsConfig(EnhancedMetricsConfig enhancedMetricsConfig);

        /**
         * <p>
         * The <code>enhancedMetricsConfig</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnhancedMetricsConfig.Builder} avoiding
         * the need to create one manually via {@link EnhancedMetricsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnhancedMetricsConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #enhancedMetricsConfig(EnhancedMetricsConfig)}.
         * 
         * @param enhancedMetricsConfig
         *        a consumer that will call methods on {@link EnhancedMetricsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enhancedMetricsConfig(EnhancedMetricsConfig)
         */
        default Builder enhancedMetricsConfig(Consumer<EnhancedMetricsConfig.Builder> enhancedMetricsConfig) {
            return enhancedMetricsConfig(EnhancedMetricsConfig.builder().applyMutation(enhancedMetricsConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String name;

        private LogConfig logConfig;

        private String authenticationType;

        private UserPoolConfig userPoolConfig;

        private OpenIDConnectConfig openIDConnectConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<AdditionalAuthenticationProvider> additionalAuthenticationProviders = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean xrayEnabled;

        private LambdaAuthorizerConfig lambdaAuthorizerConfig;

        private String apiType;

        private String mergedApiExecutionRoleArn;

        private String visibility;

        private String ownerContact;

        private String introspectionConfig;

        private Integer queryDepthLimit;

        private Integer resolverCountLimit;

        private EnhancedMetricsConfig enhancedMetricsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGraphqlApiRequest model) {
            super(model);
            name(model.name);
            logConfig(model.logConfig);
            authenticationType(model.authenticationType);
            userPoolConfig(model.userPoolConfig);
            openIDConnectConfig(model.openIDConnectConfig);
            tags(model.tags);
            additionalAuthenticationProviders(model.additionalAuthenticationProviders);
            xrayEnabled(model.xrayEnabled);
            lambdaAuthorizerConfig(model.lambdaAuthorizerConfig);
            apiType(model.apiType);
            mergedApiExecutionRoleArn(model.mergedApiExecutionRoleArn);
            visibility(model.visibility);
            ownerContact(model.ownerContact);
            introspectionConfig(model.introspectionConfig);
            queryDepthLimit(model.queryDepthLimit);
            resolverCountLimit(model.resolverCountLimit);
            enhancedMetricsConfig(model.enhancedMetricsConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final LogConfig.Builder getLogConfig() {
            return logConfig != null ? logConfig.toBuilder() : null;
        }

        public final void setLogConfig(LogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final UserPoolConfig.Builder getUserPoolConfig() {
            return userPoolConfig != null ? userPoolConfig.toBuilder() : null;
        }

        public final void setUserPoolConfig(UserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        @Override
        public final Builder userPoolConfig(UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return openIDConnectConfig != null ? openIDConnectConfig.toBuilder() : null;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<AdditionalAuthenticationProvider.Builder> getAdditionalAuthenticationProviders() {
            List<AdditionalAuthenticationProvider.Builder> result = AdditionalAuthenticationProvidersCopier
                    .copyToBuilder(this.additionalAuthenticationProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAuthenticationProviders(
                Collection<AdditionalAuthenticationProvider.BuilderImpl> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier
                    .copyFromBuilder(additionalAuthenticationProviders);
        }

        @Override
        public final Builder additionalAuthenticationProviders(
                Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier
                    .copy(additionalAuthenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                AdditionalAuthenticationProvider... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Arrays.asList(additionalAuthenticationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                Consumer<AdditionalAuthenticationProvider.Builder>... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Stream.of(additionalAuthenticationProviders)
                    .map(c -> AdditionalAuthenticationProvider.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getXrayEnabled() {
            return xrayEnabled;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        @Override
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final LambdaAuthorizerConfig.Builder getLambdaAuthorizerConfig() {
            return lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.toBuilder() : null;
        }

        public final void setLambdaAuthorizerConfig(LambdaAuthorizerConfig.BuilderImpl lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.build() : null;
        }

        @Override
        public final Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        public final String getApiType() {
            return apiType;
        }

        public final void setApiType(String apiType) {
            this.apiType = apiType;
        }

        @Override
        public final Builder apiType(String apiType) {
            this.apiType = apiType;
            return this;
        }

        @Override
        public final Builder apiType(GraphQLApiType apiType) {
            this.apiType(apiType == null ? null : apiType.toString());
            return this;
        }

        public final String getMergedApiExecutionRoleArn() {
            return mergedApiExecutionRoleArn;
        }

        public final void setMergedApiExecutionRoleArn(String mergedApiExecutionRoleArn) {
            this.mergedApiExecutionRoleArn = mergedApiExecutionRoleArn;
        }

        @Override
        public final Builder mergedApiExecutionRoleArn(String mergedApiExecutionRoleArn) {
            this.mergedApiExecutionRoleArn = mergedApiExecutionRoleArn;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(GraphQLApiVisibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getOwnerContact() {
            return ownerContact;
        }

        public final void setOwnerContact(String ownerContact) {
            this.ownerContact = ownerContact;
        }

        @Override
        public final Builder ownerContact(String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        public final String getIntrospectionConfig() {
            return introspectionConfig;
        }

        public final void setIntrospectionConfig(String introspectionConfig) {
            this.introspectionConfig = introspectionConfig;
        }

        @Override
        public final Builder introspectionConfig(String introspectionConfig) {
            this.introspectionConfig = introspectionConfig;
            return this;
        }

        @Override
        public final Builder introspectionConfig(GraphQLApiIntrospectionConfig introspectionConfig) {
            this.introspectionConfig(introspectionConfig == null ? null : introspectionConfig.toString());
            return this;
        }

        public final Integer getQueryDepthLimit() {
            return queryDepthLimit;
        }

        public final void setQueryDepthLimit(Integer queryDepthLimit) {
            this.queryDepthLimit = queryDepthLimit;
        }

        @Override
        public final Builder queryDepthLimit(Integer queryDepthLimit) {
            this.queryDepthLimit = queryDepthLimit;
            return this;
        }

        public final Integer getResolverCountLimit() {
            return resolverCountLimit;
        }

        public final void setResolverCountLimit(Integer resolverCountLimit) {
            this.resolverCountLimit = resolverCountLimit;
        }

        @Override
        public final Builder resolverCountLimit(Integer resolverCountLimit) {
            this.resolverCountLimit = resolverCountLimit;
            return this;
        }

        public final EnhancedMetricsConfig.Builder getEnhancedMetricsConfig() {
            return enhancedMetricsConfig != null ? enhancedMetricsConfig.toBuilder() : null;
        }

        public final void setEnhancedMetricsConfig(EnhancedMetricsConfig.BuilderImpl enhancedMetricsConfig) {
            this.enhancedMetricsConfig = enhancedMetricsConfig != null ? enhancedMetricsConfig.build() : null;
        }

        @Override
        public final Builder enhancedMetricsConfig(EnhancedMetricsConfig enhancedMetricsConfig) {
            this.enhancedMetricsConfig = enhancedMetricsConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGraphqlApiRequest build() {
            return new CreateGraphqlApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
