/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the CloudWatch Logs configuration for the Event API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventLogConfig implements SdkPojo, Serializable, ToCopyableBuilder<EventLogConfig.Builder, EventLogConfig> {
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logLevel").getter(getter(EventLogConfig::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudWatchLogsRoleArn").getter(getter(EventLogConfig::cloudWatchLogsRoleArn))
            .setter(setter(Builder::cloudWatchLogsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogsRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_LEVEL_FIELD,
            CLOUD_WATCH_LOGS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logLevel;

    private final String cloudWatchLogsRoleArn;

    private EventLogConfig(BuilderImpl builder) {
        this.logLevel = builder.logLevel;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
    }

    /**
     * <p>
     * The type of information to log for the Event API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link EventLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The type of information to log for the Event API.
     * @see EventLogLevel
     */
    public final EventLogLevel logLevel() {
        return EventLogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * The type of information to log for the Event API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link EventLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The type of information to log for the Event API.
     * @see EventLogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * <p>
     * The IAM service role that AppSync assumes to publish CloudWatch Logs in your account.
     * </p>
     * 
     * @return The IAM service role that AppSync assumes to publish CloudWatch Logs in your account.
     */
    public final String cloudWatchLogsRoleArn() {
        return cloudWatchLogsRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventLogConfig)) {
            return false;
        }
        EventLogConfig other = (EventLogConfig) obj;
        return Objects.equals(logLevelAsString(), other.logLevelAsString())
                && Objects.equals(cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventLogConfig").add("LogLevel", logLevelAsString())
                .add("CloudWatchLogsRoleArn", cloudWatchLogsRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "cloudWatchLogsRoleArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logLevel", LOG_LEVEL_FIELD);
        map.put("cloudWatchLogsRoleArn", CLOUD_WATCH_LOGS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventLogConfig, T> g) {
        return obj -> g.apply((EventLogConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventLogConfig> {
        /**
         * <p>
         * The type of information to log for the Event API.
         * </p>
         * 
         * @param logLevel
         *        The type of information to log for the Event API.
         * @see EventLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventLogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * The type of information to log for the Event API.
         * </p>
         * 
         * @param logLevel
         *        The type of information to log for the Event API.
         * @see EventLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventLogLevel
         */
        Builder logLevel(EventLogLevel logLevel);

        /**
         * <p>
         * The IAM service role that AppSync assumes to publish CloudWatch Logs in your account.
         * </p>
         * 
         * @param cloudWatchLogsRoleArn
         *        The IAM service role that AppSync assumes to publish CloudWatch Logs in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String logLevel;

        private String cloudWatchLogsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventLogConfig model) {
            logLevel(model.logLevel);
            cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(EventLogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getCloudWatchLogsRoleArn() {
            return cloudWatchLogsRoleArn;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        @Override
        public EventLogConfig build() {
            return new EventLogConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
