/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>LambdaAuthorizerConfig</code> specifies how to authorize AppSync API access when using the
 * <code>AWS_LAMBDA</code> authorizer mode. Be aware that an AppSync API can have only one Lambda authorizer configured
 * at a time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaAuthorizerConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaAuthorizerConfig.Builder, LambdaAuthorizerConfig> {
    private static final SdkField<Integer> AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("authorizerResultTtlInSeconds")
            .getter(getter(LambdaAuthorizerConfig::authorizerResultTtlInSeconds))
            .setter(setter(Builder::authorizerResultTtlInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerResultTtlInSeconds")
                    .build()).build();

    private static final SdkField<String> AUTHORIZER_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizerUri").getter(getter(LambdaAuthorizerConfig::authorizerUri))
            .setter(setter(Builder::authorizerUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerUri").build()).build();

    private static final SdkField<String> IDENTITY_VALIDATION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("identityValidationExpression")
            .getter(getter(LambdaAuthorizerConfig::identityValidationExpression))
            .setter(setter(Builder::identityValidationExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityValidationExpression")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD, AUTHORIZER_URI_FIELD, IDENTITY_VALIDATION_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer authorizerResultTtlInSeconds;

    private final String authorizerUri;

    private final String identityValidationExpression;

    private LambdaAuthorizerConfig(BuilderImpl builder) {
        this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
        this.authorizerUri = builder.authorizerUri;
        this.identityValidationExpression = builder.identityValidationExpression;
    }

    /**
     * <p>
     * The number of seconds a response should be cached for. The default is 0 seconds, which disables caching. If you
     * don't specify a value for <code>authorizerResultTtlInSeconds</code>, the default value is used. The maximum value
     * is one hour (3600 seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key in
     * its response.
     * </p>
     * 
     * @return The number of seconds a response should be cached for. The default is 0 seconds, which disables caching.
     *         If you don't specify a value for <code>authorizerResultTtlInSeconds</code>, the default value is used.
     *         The maximum value is one hour (3600 seconds). The Lambda function can override this by returning a
     *         <code>ttlOverride</code> key in its response.
     */
    public final Integer authorizerResultTtlInSeconds() {
        return authorizerResultTtlInSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a standard
     * Lambda ARN, a version ARN (<code>.../v3</code>), or an alias ARN.
     * </p>
     * <p>
     * <b>Note</b>: This Lambda function must have the following resource-based policy assigned to it. When configuring
     * Lambda authorizers in the console, this is done for you. To use the Command Line Interface (CLI), run the
     * following:
     * </p>
     * <p>
     * <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a
     *         standard Lambda ARN, a version ARN (<code>.../v3</code>), or an alias ARN. </p>
     *         <p>
     *         <b>Note</b>: This Lambda function must have the following resource-based policy assigned to it. When
     *         configuring Lambda authorizers in the console, this is done for you. To use the Command Line Interface
     *         (CLI), run the following:
     *         </p>
     *         <p>
     *         <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
     */
    public final String authorizerUri() {
        return authorizerUri;
    }

    /**
     * <p>
     * A regular expression for validation of tokens before the Lambda function is called.
     * </p>
     * 
     * @return A regular expression for validation of tokens before the Lambda function is called.
     */
    public final String identityValidationExpression() {
        return identityValidationExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizerResultTtlInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerUri());
        hashCode = 31 * hashCode + Objects.hashCode(identityValidationExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaAuthorizerConfig)) {
            return false;
        }
        LambdaAuthorizerConfig other = (LambdaAuthorizerConfig) obj;
        return Objects.equals(authorizerResultTtlInSeconds(), other.authorizerResultTtlInSeconds())
                && Objects.equals(authorizerUri(), other.authorizerUri())
                && Objects.equals(identityValidationExpression(), other.identityValidationExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaAuthorizerConfig").add("AuthorizerResultTtlInSeconds", authorizerResultTtlInSeconds())
                .add("AuthorizerUri", authorizerUri()).add("IdentityValidationExpression", identityValidationExpression())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizerResultTtlInSeconds":
            return Optional.ofNullable(clazz.cast(authorizerResultTtlInSeconds()));
        case "authorizerUri":
            return Optional.ofNullable(clazz.cast(authorizerUri()));
        case "identityValidationExpression":
            return Optional.ofNullable(clazz.cast(identityValidationExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorizerResultTtlInSeconds", AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD);
        map.put("authorizerUri", AUTHORIZER_URI_FIELD);
        map.put("identityValidationExpression", IDENTITY_VALIDATION_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaAuthorizerConfig, T> g) {
        return obj -> g.apply((LambdaAuthorizerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaAuthorizerConfig> {
        /**
         * <p>
         * The number of seconds a response should be cached for. The default is 0 seconds, which disables caching. If
         * you don't specify a value for <code>authorizerResultTtlInSeconds</code>, the default value is used. The
         * maximum value is one hour (3600 seconds). The Lambda function can override this by returning a
         * <code>ttlOverride</code> key in its response.
         * </p>
         * 
         * @param authorizerResultTtlInSeconds
         *        The number of seconds a response should be cached for. The default is 0 seconds, which disables
         *        caching. If you don't specify a value for <code>authorizerResultTtlInSeconds</code>, the default value
         *        is used. The maximum value is one hour (3600 seconds). The Lambda function can override this by
         *        returning a <code>ttlOverride</code> key in its response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a standard
         * Lambda ARN, a version ARN (<code>.../v3</code>), or an alias ARN.
         * </p>
         * <p>
         * <b>Note</b>: This Lambda function must have the following resource-based policy assigned to it. When
         * configuring Lambda authorizers in the console, this is done for you. To use the Command Line Interface (CLI),
         * run the following:
         * </p>
         * <p>
         * <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
         * </p>
         * 
         * @param authorizerUri
         *        The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a
         *        standard Lambda ARN, a version ARN (<code>.../v3</code>), or an alias ARN. </p>
         *        <p>
         *        <b>Note</b>: This Lambda function must have the following resource-based policy assigned to it. When
         *        configuring Lambda authorizers in the console, this is done for you. To use the Command Line Interface
         *        (CLI), run the following:
         *        </p>
         *        <p>
         *        <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerUri(String authorizerUri);

        /**
         * <p>
         * A regular expression for validation of tokens before the Lambda function is called.
         * </p>
         * 
         * @param identityValidationExpression
         *        A regular expression for validation of tokens before the Lambda function is called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityValidationExpression(String identityValidationExpression);
    }

    static final class BuilderImpl implements Builder {
        private Integer authorizerResultTtlInSeconds;

        private String authorizerUri;

        private String identityValidationExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaAuthorizerConfig model) {
            authorizerResultTtlInSeconds(model.authorizerResultTtlInSeconds);
            authorizerUri(model.authorizerUri);
            identityValidationExpression(model.identityValidationExpression);
        }

        public final Integer getAuthorizerResultTtlInSeconds() {
            return authorizerResultTtlInSeconds;
        }

        public final void setAuthorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
        }

        @Override
        public final Builder authorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            return this;
        }

        public final String getAuthorizerUri() {
            return authorizerUri;
        }

        public final void setAuthorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
        }

        @Override
        public final Builder authorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        public final String getIdentityValidationExpression() {
            return identityValidationExpression;
        }

        public final void setIdentityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
        }

        @Override
        public final Builder identityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        @Override
        public LambdaAuthorizerConfig build() {
            return new LambdaAuthorizerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
