/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApiKeyRequest extends AppSyncRequest implements
        ToCopyableBuilder<UpdateApiKeyRequest.Builder, UpdateApiKeyRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(UpdateApiKeyRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateApiKeyRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateApiKeyRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Long> EXPIRES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("expires")
            .getter(getter(UpdateApiKeyRequest::expires)).setter(setter(Builder::expires))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expires").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, ID_FIELD,
            DESCRIPTION_FIELD, EXPIRES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String apiId;

    private final String id;

    private final String description;

    private final Long expires;

    private UpdateApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.id = builder.id;
        this.description = builder.description;
        this.expires = builder.expires;
    }

    /**
     * <p>
     * The ID for the GraphQL API.
     * </p>
     * 
     * @return The ID for the GraphQL API.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The API key ID.
     * </p>
     * 
     * @return The API key ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A description of the purpose of the API key.
     * </p>
     * 
     * @return A description of the purpose of the API key.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * From the update time, the time after which the API key expires. The date is represented as seconds since the
     * epoch. For more information, see .
     * </p>
     * 
     * @return From the update time, the time after which the API key expires. The date is represented as seconds since
     *         the epoch. For more information, see .
     */
    public final Long expires() {
        return expires;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(expires());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiKeyRequest)) {
            return false;
        }
        UpdateApiKeyRequest other = (UpdateApiKeyRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(id(), other.id())
                && Objects.equals(description(), other.description()) && Objects.equals(expires(), other.expires());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApiKeyRequest").add("ApiId", apiId()).add("Id", id()).add("Description", description())
                .add("Expires", expires()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "expires":
            return Optional.ofNullable(clazz.cast(expires()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiId", API_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("expires", EXPIRES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiKeyRequest, T> g) {
        return obj -> g.apply((UpdateApiKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApiKeyRequest> {
        /**
         * <p>
         * The ID for the GraphQL API.
         * </p>
         * 
         * @param apiId
         *        The ID for the GraphQL API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The API key ID.
         * </p>
         * 
         * @param id
         *        The API key ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A description of the purpose of the API key.
         * </p>
         * 
         * @param description
         *        A description of the purpose of the API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * From the update time, the time after which the API key expires. The date is represented as seconds since the
         * epoch. For more information, see .
         * </p>
         * 
         * @param expires
         *        From the update time, the time after which the API key expires. The date is represented as seconds
         *        since the epoch. For more information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expires(Long expires);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String id;

        private String description;

        private Long expires;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiKeyRequest model) {
            super(model);
            apiId(model.apiId);
            id(model.id);
            description(model.description);
            expires(model.expires);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getExpires() {
            return expires;
        }

        public final void setExpires(Long expires) {
            this.expires = expires;
        }

        @Override
        public final Builder expires(Long expires) {
            this.expires = expires;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiKeyRequest build() {
            return new UpdateApiKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
