/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelNamespaceResponse extends AppSyncResponse implements
        ToCopyableBuilder<UpdateChannelNamespaceResponse.Builder, UpdateChannelNamespaceResponse> {
    private static final SdkField<ChannelNamespace> CHANNEL_NAMESPACE_FIELD = SdkField
            .<ChannelNamespace> builder(MarshallingType.SDK_POJO).memberName("channelNamespace")
            .getter(getter(UpdateChannelNamespaceResponse::channelNamespace)).setter(setter(Builder::channelNamespace))
            .constructor(ChannelNamespace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelNamespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ChannelNamespace channelNamespace;

    private UpdateChannelNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.channelNamespace = builder.channelNamespace;
    }

    /**
     * <p>
     * The <code>ChannelNamespace</code> object.
     * </p>
     * 
     * @return The <code>ChannelNamespace</code> object.
     */
    public final ChannelNamespace channelNamespace() {
        return channelNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelNamespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelNamespaceResponse)) {
            return false;
        }
        UpdateChannelNamespaceResponse other = (UpdateChannelNamespaceResponse) obj;
        return Objects.equals(channelNamespace(), other.channelNamespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelNamespaceResponse").add("ChannelNamespace", channelNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelNamespace":
            return Optional.ofNullable(clazz.cast(channelNamespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelNamespace", CHANNEL_NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelNamespaceResponse, T> g) {
        return obj -> g.apply((UpdateChannelNamespaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateChannelNamespaceResponse> {
        /**
         * <p>
         * The <code>ChannelNamespace</code> object.
         * </p>
         * 
         * @param channelNamespace
         *        The <code>ChannelNamespace</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelNamespace(ChannelNamespace channelNamespace);

        /**
         * <p>
         * The <code>ChannelNamespace</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelNamespace.Builder} avoiding the
         * need to create one manually via {@link ChannelNamespace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelNamespace.Builder#build()} is called immediately and its
         * result is passed to {@link #channelNamespace(ChannelNamespace)}.
         * 
         * @param channelNamespace
         *        a consumer that will call methods on {@link ChannelNamespace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelNamespace(ChannelNamespace)
         */
        default Builder channelNamespace(Consumer<ChannelNamespace.Builder> channelNamespace) {
            return channelNamespace(ChannelNamespace.builder().applyMutation(channelNamespace).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private ChannelNamespace channelNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelNamespaceResponse model) {
            super(model);
            channelNamespace(model.channelNamespace);
        }

        public final ChannelNamespace.Builder getChannelNamespace() {
            return channelNamespace != null ? channelNamespace.toBuilder() : null;
        }

        public final void setChannelNamespace(ChannelNamespace.BuilderImpl channelNamespace) {
            this.channelNamespace = channelNamespace != null ? channelNamespace.build() : null;
        }

        @Override
        public final Builder channelNamespace(ChannelNamespace channelNamespace) {
            this.channelNamespace = channelNamespace;
            return this;
        }

        @Override
        public UpdateChannelNamespaceResponse build() {
            return new UpdateChannelNamespaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
