/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApiCacheType {
    T2_SMALL("T2_SMALL"),
    T2_MEDIUM("T2_MEDIUM"),
    R4_LARGE("R4_LARGE"),
    R4_XLARGE("R4_XLARGE"),
    R4_2_XLARGE("R4_2XLARGE"),
    R4_4_XLARGE("R4_4XLARGE"),
    R4_8_XLARGE("R4_8XLARGE"),
    SMALL("SMALL"),
    MEDIUM("MEDIUM"),
    LARGE("LARGE"),
    XLARGE("XLARGE"),
    LARGE_2_X("LARGE_2X"),
    LARGE_4_X("LARGE_4X"),
    LARGE_8_X("LARGE_8X"),
    LARGE_12_X("LARGE_12X"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApiCacheType> VALUE_MAP;
    private final String value;

    private ApiCacheType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApiCacheType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApiCacheType> knownValues() {
        EnumSet<ApiCacheType> knownValues = EnumSet.allOf(ApiCacheType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApiCacheType.class, ApiCacheType::toString);
    }
}

