/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an authorization configuration. Use <code>AuthMode</code> to specify the publishing and subscription
 * authorization configuration for an Event API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthMode implements SdkPojo, Serializable, ToCopyableBuilder<AuthMode.Builder, AuthMode> {
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(AuthMode::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authType;

    private AuthMode(BuilderImpl builder) {
        this.authType = builder.authType;
    }

    /**
     * <p>
     * The authorization type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authorization type.
     * @see AuthenticationType
     */
    public final AuthenticationType authType() {
        return AuthenticationType.fromValue(authType);
    }

    /**
     * <p>
     * The authorization type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authorization type.
     * @see AuthenticationType
     */
    public final String authTypeAsString() {
        return authType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthMode)) {
            return false;
        }
        AuthMode other = (AuthMode) obj;
        return Objects.equals(authTypeAsString(), other.authTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthMode").add("AuthType", authTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authType", AUTH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthMode, T> g) {
        return obj -> g.apply((AuthMode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthMode> {
        /**
         * <p>
         * The authorization type.
         * </p>
         * 
         * @param authType
         *        The authorization type.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authorization type.
         * </p>
         * 
         * @param authType
         *        The authorization type.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authType(AuthenticationType authType);
    }

    static final class BuilderImpl implements Builder {
        private String authType;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthMode model) {
            authType(model.authType);
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthenticationType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        @Override
        public AuthMode build() {
            return new AuthMode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
