/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an authorization provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthProvider implements SdkPojo, Serializable, ToCopyableBuilder<AuthProvider.Builder, AuthProvider> {
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(AuthProvider::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<CognitoConfig> COGNITO_CONFIG_FIELD = SdkField
            .<CognitoConfig> builder(MarshallingType.SDK_POJO).memberName("cognitoConfig")
            .getter(getter(AuthProvider::cognitoConfig)).setter(setter(Builder::cognitoConfig))
            .constructor(CognitoConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoConfig").build()).build();

    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField
            .<OpenIDConnectConfig> builder(MarshallingType.SDK_POJO).memberName("openIDConnectConfig")
            .getter(getter(AuthProvider::openIDConnectConfig)).setter(setter(Builder::openIDConnectConfig))
            .constructor(OpenIDConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build())
            .build();

    private static final SdkField<LambdaAuthorizerConfig> LAMBDA_AUTHORIZER_CONFIG_FIELD = SdkField
            .<LambdaAuthorizerConfig> builder(MarshallingType.SDK_POJO).memberName("lambdaAuthorizerConfig")
            .getter(getter(AuthProvider::lambdaAuthorizerConfig)).setter(setter(Builder::lambdaAuthorizerConfig))
            .constructor(LambdaAuthorizerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaAuthorizerConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TYPE_FIELD,
            COGNITO_CONFIG_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD, LAMBDA_AUTHORIZER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authType;

    private final CognitoConfig cognitoConfig;

    private final OpenIDConnectConfig openIDConnectConfig;

    private final LambdaAuthorizerConfig lambdaAuthorizerConfig;

    private AuthProvider(BuilderImpl builder) {
        this.authType = builder.authType;
        this.cognitoConfig = builder.cognitoConfig;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
    }

    /**
     * <p>
     * The authorization type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authorization type.
     * @see AuthenticationType
     */
    public final AuthenticationType authType() {
        return AuthenticationType.fromValue(authType);
    }

    /**
     * <p>
     * The authorization type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authorization type.
     * @see AuthenticationType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * Describes an Amazon Cognito user pool configuration.
     * </p>
     * 
     * @return Describes an Amazon Cognito user pool configuration.
     */
    public final CognitoConfig cognitoConfig() {
        return cognitoConfig;
    }

    /**
     * Returns the value of the OpenIDConnectConfig property for this object.
     * 
     * @return The value of the OpenIDConnectConfig property for this object.
     */
    public final OpenIDConnectConfig openIDConnectConfig() {
        return openIDConnectConfig;
    }

    /**
     * Returns the value of the LambdaAuthorizerConfig property for this object.
     * 
     * @return The value of the LambdaAuthorizerConfig property for this object.
     */
    public final LambdaAuthorizerConfig lambdaAuthorizerConfig() {
        return lambdaAuthorizerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaAuthorizerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthProvider)) {
            return false;
        }
        AuthProvider other = (AuthProvider) obj;
        return Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(cognitoConfig(), other.cognitoConfig())
                && Objects.equals(openIDConnectConfig(), other.openIDConnectConfig())
                && Objects.equals(lambdaAuthorizerConfig(), other.lambdaAuthorizerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthProvider").add("AuthType", authTypeAsString()).add("CognitoConfig", cognitoConfig())
                .add("OpenIDConnectConfig", openIDConnectConfig()).add("LambdaAuthorizerConfig", lambdaAuthorizerConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "cognitoConfig":
            return Optional.ofNullable(clazz.cast(cognitoConfig()));
        case "openIDConnectConfig":
            return Optional.ofNullable(clazz.cast(openIDConnectConfig()));
        case "lambdaAuthorizerConfig":
            return Optional.ofNullable(clazz.cast(lambdaAuthorizerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("cognitoConfig", COGNITO_CONFIG_FIELD);
        map.put("openIDConnectConfig", OPEN_ID_CONNECT_CONFIG_FIELD);
        map.put("lambdaAuthorizerConfig", LAMBDA_AUTHORIZER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthProvider, T> g) {
        return obj -> g.apply((AuthProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthProvider> {
        /**
         * <p>
         * The authorization type.
         * </p>
         * 
         * @param authType
         *        The authorization type.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authorization type.
         * </p>
         * 
         * @param authType
         *        The authorization type.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authType(AuthenticationType authType);

        /**
         * <p>
         * Describes an Amazon Cognito user pool configuration.
         * </p>
         * 
         * @param cognitoConfig
         *        Describes an Amazon Cognito user pool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoConfig(CognitoConfig cognitoConfig);

        /**
         * <p>
         * Describes an Amazon Cognito user pool configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CognitoConfig.Builder} avoiding the need
         * to create one manually via {@link CognitoConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CognitoConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cognitoConfig(CognitoConfig)}.
         * 
         * @param cognitoConfig
         *        a consumer that will call methods on {@link CognitoConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoConfig(CognitoConfig)
         */
        default Builder cognitoConfig(Consumer<CognitoConfig.Builder> cognitoConfig) {
            return cognitoConfig(CognitoConfig.builder().applyMutation(cognitoConfig).build());
        }

        /**
         * Sets the value of the OpenIDConnectConfig property for this object.
         *
         * @param openIDConnectConfig
         *        The new value for the OpenIDConnectConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig);

        /**
         * Sets the value of the OpenIDConnectConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OpenIDConnectConfig.Builder} avoiding the
         * need to create one manually via {@link OpenIDConnectConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenIDConnectConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #openIDConnectConfig(OpenIDConnectConfig)}.
         * 
         * @param openIDConnectConfig
         *        a consumer that will call methods on {@link OpenIDConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIDConnectConfig(OpenIDConnectConfig)
         */
        default Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return openIDConnectConfig(OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig).build());
        }

        /**
         * Sets the value of the LambdaAuthorizerConfig property for this object.
         *
         * @param lambdaAuthorizerConfig
         *        The new value for the LambdaAuthorizerConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig);

        /**
         * Sets the value of the LambdaAuthorizerConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LambdaAuthorizerConfig.Builder} avoiding
         * the need to create one manually via {@link LambdaAuthorizerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaAuthorizerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaAuthorizerConfig(LambdaAuthorizerConfig)}.
         * 
         * @param lambdaAuthorizerConfig
         *        a consumer that will call methods on {@link LambdaAuthorizerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaAuthorizerConfig(LambdaAuthorizerConfig)
         */
        default Builder lambdaAuthorizerConfig(Consumer<LambdaAuthorizerConfig.Builder> lambdaAuthorizerConfig) {
            return lambdaAuthorizerConfig(LambdaAuthorizerConfig.builder().applyMutation(lambdaAuthorizerConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String authType;

        private CognitoConfig cognitoConfig;

        private OpenIDConnectConfig openIDConnectConfig;

        private LambdaAuthorizerConfig lambdaAuthorizerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthProvider model) {
            authType(model.authType);
            cognitoConfig(model.cognitoConfig);
            openIDConnectConfig(model.openIDConnectConfig);
            lambdaAuthorizerConfig(model.lambdaAuthorizerConfig);
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthenticationType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final CognitoConfig.Builder getCognitoConfig() {
            return cognitoConfig != null ? cognitoConfig.toBuilder() : null;
        }

        public final void setCognitoConfig(CognitoConfig.BuilderImpl cognitoConfig) {
            this.cognitoConfig = cognitoConfig != null ? cognitoConfig.build() : null;
        }

        @Override
        public final Builder cognitoConfig(CognitoConfig cognitoConfig) {
            this.cognitoConfig = cognitoConfig;
            return this;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return openIDConnectConfig != null ? openIDConnectConfig.toBuilder() : null;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final LambdaAuthorizerConfig.Builder getLambdaAuthorizerConfig() {
            return lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.toBuilder() : null;
        }

        public final void setLambdaAuthorizerConfig(LambdaAuthorizerConfig.BuilderImpl lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.build() : null;
        }

        @Override
        public final Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        @Override
        public AuthProvider build() {
            return new AuthProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
