/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enables and controls the enhanced metrics feature. Enhanced metrics emit granular data on API usage and performance
 * such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your
 * CloudWatch account, and you can configure the types of data that will be sent.
 * </p>
 * <p>
 * Enhanced metrics can be configured at the resolver, data source, and operation levels.
 * <code>EnhancedMetricsConfig</code> contains three required parameters, each controlling one of these categories:
 * </p>
 * <ol>
 * <li>
 * <p>
 * <code>resolverLevelMetricsBehavior</code>: Controls how resolver metrics will be emitted to CloudWatch. Resolver
 * metrics include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * GraphQL errors: The number of GraphQL errors that occurred.
 * </p>
 * </li>
 * <li>
 * <p>
 * Requests: The number of invocations that occurred during a request.
 * </p>
 * </li>
 * <li>
 * <p>
 * Latency: The time to complete a resolver invocation.
 * </p>
 * </li>
 * <li>
 * <p>
 * Cache hits: The number of cache hits during a request.
 * </p>
 * </li>
 * <li>
 * <p>
 * Cache misses: The number of cache misses during a request.
 * </p>
 * </li>
 * </ul>
 * <p>
 * These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be recorded
 * by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these values at a time:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the
 * <code>metricsConfig</code> value set to <code>ENABLED</code>.
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * <code>dataSourceLevelMetricsBehavior</code>: Controls how data source metrics will be emitted to CloudWatch. Data
 * source metrics include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Requests: The number of invocations that occured during a request.
 * </p>
 * </li>
 * <li>
 * <p>
 * Latency: The time to complete a data source invocation.
 * </p>
 * </li>
 * <li>
 * <p>
 * Errors: The number of errors that occurred during a data source invocation.
 * </p>
 * </li>
 * </ul>
 * <p>
 * These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will be
 * recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code> accepts one of these values at a
 * time:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in the request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the
 * <code>metricsConfig</code> value set to <code>ENABLED</code>.
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * <code>operationLevelMetricsConfig</code>: Controls how operation metrics will be emitted to CloudWatch. Operation
 * metrics include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Requests: The number of times a specified GraphQL operation was called.
 * </p>
 * </li>
 * <li>
 * <p>
 * GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or
 * <code>DISABLED</code>.
 * </p>
 * </li>
 * </ol>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnhancedMetricsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EnhancedMetricsConfig.Builder, EnhancedMetricsConfig> {
    private static final SdkField<String> RESOLVER_LEVEL_METRICS_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resolverLevelMetricsBehavior")
            .getter(getter(EnhancedMetricsConfig::resolverLevelMetricsBehaviorAsString))
            .setter(setter(Builder::resolverLevelMetricsBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverLevelMetricsBehavior")
                    .build()).build();

    private static final SdkField<String> DATA_SOURCE_LEVEL_METRICS_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dataSourceLevelMetricsBehavior")
            .getter(getter(EnhancedMetricsConfig::dataSourceLevelMetricsBehaviorAsString))
            .setter(setter(Builder::dataSourceLevelMetricsBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceLevelMetricsBehavior")
                    .build()).build();

    private static final SdkField<String> OPERATION_LEVEL_METRICS_CONFIG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("operationLevelMetricsConfig")
            .getter(getter(EnhancedMetricsConfig::operationLevelMetricsConfigAsString))
            .setter(setter(Builder::operationLevelMetricsConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationLevelMetricsConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOLVER_LEVEL_METRICS_BEHAVIOR_FIELD, DATA_SOURCE_LEVEL_METRICS_BEHAVIOR_FIELD,
                    OPERATION_LEVEL_METRICS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resolverLevelMetricsBehavior;

    private final String dataSourceLevelMetricsBehavior;

    private final String operationLevelMetricsConfig;

    private EnhancedMetricsConfig(BuilderImpl builder) {
        this.resolverLevelMetricsBehavior = builder.resolverLevelMetricsBehavior;
        this.dataSourceLevelMetricsBehavior = builder.dataSourceLevelMetricsBehavior;
        this.operationLevelMetricsConfig = builder.operationLevelMetricsConfig;
    }

    /**
     * <p>
     * Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * GraphQL errors: The number of GraphQL errors that occurred.
     * </p>
     * </li>
     * <li>
     * <p>
     * Requests: The number of invocations that occurred during a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Latency: The time to complete a resolver invocation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache hits: The number of cache hits during a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache misses: The number of cache misses during a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be
     * recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these values at a
     * time:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the
     * <code>metricsConfig</code> value set to <code>ENABLED</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolverLevelMetricsBehavior} will return {@link ResolverLevelMetricsBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #resolverLevelMetricsBehaviorAsString}.
     * </p>
     * 
     * @return Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         GraphQL errors: The number of GraphQL errors that occurred.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Requests: The number of invocations that occurred during a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Latency: The time to complete a resolver invocation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cache hits: The number of cache hits during a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cache misses: The number of cache misses during a request.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will
     *         be recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these
     *         values at a time:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the
     *         <code>metricsConfig</code> value set to <code>ENABLED</code>.
     *         </p>
     *         </li>
     * @see ResolverLevelMetricsBehavior
     */
    public final ResolverLevelMetricsBehavior resolverLevelMetricsBehavior() {
        return ResolverLevelMetricsBehavior.fromValue(resolverLevelMetricsBehavior);
    }

    /**
     * <p>
     * Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * GraphQL errors: The number of GraphQL errors that occurred.
     * </p>
     * </li>
     * <li>
     * <p>
     * Requests: The number of invocations that occurred during a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Latency: The time to complete a resolver invocation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache hits: The number of cache hits during a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache misses: The number of cache misses during a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be
     * recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these values at a
     * time:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the
     * <code>metricsConfig</code> value set to <code>ENABLED</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolverLevelMetricsBehavior} will return {@link ResolverLevelMetricsBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #resolverLevelMetricsBehaviorAsString}.
     * </p>
     * 
     * @return Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         GraphQL errors: The number of GraphQL errors that occurred.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Requests: The number of invocations that occurred during a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Latency: The time to complete a resolver invocation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cache hits: The number of cache hits during a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cache misses: The number of cache misses during a request.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will
     *         be recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these
     *         values at a time:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the
     *         <code>metricsConfig</code> value set to <code>ENABLED</code>.
     *         </p>
     *         </li>
     * @see ResolverLevelMetricsBehavior
     */
    public final String resolverLevelMetricsBehaviorAsString() {
        return resolverLevelMetricsBehavior;
    }

    /**
     * <p>
     * Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Requests: The number of invocations that occured during a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Latency: The time to complete a data source invocation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Errors: The number of errors that occurred during a data source invocation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will
     * be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code> accepts one of these
     * values at a time:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the
     * <code>metricsConfig</code> value set to <code>ENABLED</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataSourceLevelMetricsBehavior} will return {@link DataSourceLevelMetricsBehavior#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #dataSourceLevelMetricsBehaviorAsString}.
     * </p>
     * 
     * @return Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Requests: The number of invocations that occured during a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Latency: The time to complete a data source invocation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Errors: The number of errors that occurred during a data source invocation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         These metrics can be emitted to CloudWatch per data source or for all data sources in the request.
     *         Metrics will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code>
     *         accepts one of these values at a time:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in the
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the
     *         <code>metricsConfig</code> value set to <code>ENABLED</code>.
     *         </p>
     *         </li>
     * @see DataSourceLevelMetricsBehavior
     */
    public final DataSourceLevelMetricsBehavior dataSourceLevelMetricsBehavior() {
        return DataSourceLevelMetricsBehavior.fromValue(dataSourceLevelMetricsBehavior);
    }

    /**
     * <p>
     * Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Requests: The number of invocations that occured during a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Latency: The time to complete a data source invocation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Errors: The number of errors that occurred during a data source invocation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will
     * be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code> accepts one of these
     * values at a time:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the
     * <code>metricsConfig</code> value set to <code>ENABLED</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataSourceLevelMetricsBehavior} will return {@link DataSourceLevelMetricsBehavior#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #dataSourceLevelMetricsBehaviorAsString}.
     * </p>
     * 
     * @return Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Requests: The number of invocations that occured during a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Latency: The time to complete a data source invocation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Errors: The number of errors that occurred during a data source invocation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         These metrics can be emitted to CloudWatch per data source or for all data sources in the request.
     *         Metrics will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code>
     *         accepts one of these values at a time:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in the
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the
     *         <code>metricsConfig</code> value set to <code>ENABLED</code>.
     *         </p>
     *         </li>
     * @see DataSourceLevelMetricsBehavior
     */
    public final String dataSourceLevelMetricsBehaviorAsString() {
        return dataSourceLevelMetricsBehavior;
    }

    /**
     * <p>
     * Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Requests: The number of times a specified GraphQL operation was called.
     * </p>
     * </li>
     * <li>
     * <p>
     * GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #operationLevelMetricsConfig} will return {@link OperationLevelMetricsConfig#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #operationLevelMetricsConfigAsString}.
     * </p>
     * 
     * @return Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Requests: The number of times a specified GraphQL operation was called.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or
     *         <code>DISABLED</code>.
     * @see OperationLevelMetricsConfig
     */
    public final OperationLevelMetricsConfig operationLevelMetricsConfig() {
        return OperationLevelMetricsConfig.fromValue(operationLevelMetricsConfig);
    }

    /**
     * <p>
     * Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Requests: The number of times a specified GraphQL operation was called.
     * </p>
     * </li>
     * <li>
     * <p>
     * GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #operationLevelMetricsConfig} will return {@link OperationLevelMetricsConfig#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #operationLevelMetricsConfigAsString}.
     * </p>
     * 
     * @return Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Requests: The number of times a specified GraphQL operation was called.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or
     *         <code>DISABLED</code>.
     * @see OperationLevelMetricsConfig
     */
    public final String operationLevelMetricsConfigAsString() {
        return operationLevelMetricsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resolverLevelMetricsBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceLevelMetricsBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operationLevelMetricsConfigAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedMetricsConfig)) {
            return false;
        }
        EnhancedMetricsConfig other = (EnhancedMetricsConfig) obj;
        return Objects.equals(resolverLevelMetricsBehaviorAsString(), other.resolverLevelMetricsBehaviorAsString())
                && Objects.equals(dataSourceLevelMetricsBehaviorAsString(), other.dataSourceLevelMetricsBehaviorAsString())
                && Objects.equals(operationLevelMetricsConfigAsString(), other.operationLevelMetricsConfigAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnhancedMetricsConfig")
                .add("ResolverLevelMetricsBehavior", resolverLevelMetricsBehaviorAsString())
                .add("DataSourceLevelMetricsBehavior", dataSourceLevelMetricsBehaviorAsString())
                .add("OperationLevelMetricsConfig", operationLevelMetricsConfigAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resolverLevelMetricsBehavior":
            return Optional.ofNullable(clazz.cast(resolverLevelMetricsBehaviorAsString()));
        case "dataSourceLevelMetricsBehavior":
            return Optional.ofNullable(clazz.cast(dataSourceLevelMetricsBehaviorAsString()));
        case "operationLevelMetricsConfig":
            return Optional.ofNullable(clazz.cast(operationLevelMetricsConfigAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resolverLevelMetricsBehavior", RESOLVER_LEVEL_METRICS_BEHAVIOR_FIELD);
        map.put("dataSourceLevelMetricsBehavior", DATA_SOURCE_LEVEL_METRICS_BEHAVIOR_FIELD);
        map.put("operationLevelMetricsConfig", OPERATION_LEVEL_METRICS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnhancedMetricsConfig, T> g) {
        return obj -> g.apply((EnhancedMetricsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnhancedMetricsConfig> {
        /**
         * <p>
         * Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * GraphQL errors: The number of GraphQL errors that occurred.
         * </p>
         * </li>
         * <li>
         * <p>
         * Requests: The number of invocations that occurred during a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * Latency: The time to complete a resolver invocation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cache hits: The number of cache hits during a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cache misses: The number of cache misses during a request.
         * </p>
         * </li>
         * </ul>
         * <p>
         * These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be
         * recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these values
         * at a time:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the
         * <code>metricsConfig</code> value set to <code>ENABLED</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resolverLevelMetricsBehavior
         *        Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        GraphQL errors: The number of GraphQL errors that occurred.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Requests: The number of invocations that occurred during a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Latency: The time to complete a resolver invocation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cache hits: The number of cache hits during a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cache misses: The number of cache misses during a request.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics
         *        will be recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of
         *        these values at a time:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the
         *        <code>metricsConfig</code> value set to <code>ENABLED</code>.
         *        </p>
         *        </li>
         * @see ResolverLevelMetricsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverLevelMetricsBehavior
         */
        Builder resolverLevelMetricsBehavior(String resolverLevelMetricsBehavior);

        /**
         * <p>
         * Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * GraphQL errors: The number of GraphQL errors that occurred.
         * </p>
         * </li>
         * <li>
         * <p>
         * Requests: The number of invocations that occurred during a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * Latency: The time to complete a resolver invocation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cache hits: The number of cache hits during a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cache misses: The number of cache misses during a request.
         * </p>
         * </li>
         * </ul>
         * <p>
         * These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be
         * recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these values
         * at a time:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the
         * <code>metricsConfig</code> value set to <code>ENABLED</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resolverLevelMetricsBehavior
         *        Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        GraphQL errors: The number of GraphQL errors that occurred.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Requests: The number of invocations that occurred during a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Latency: The time to complete a resolver invocation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cache hits: The number of cache hits during a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cache misses: The number of cache misses during a request.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics
         *        will be recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of
         *        these values at a time:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the
         *        <code>metricsConfig</code> value set to <code>ENABLED</code>.
         *        </p>
         *        </li>
         * @see ResolverLevelMetricsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverLevelMetricsBehavior
         */
        Builder resolverLevelMetricsBehavior(ResolverLevelMetricsBehavior resolverLevelMetricsBehavior);

        /**
         * <p>
         * Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Requests: The number of invocations that occured during a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * Latency: The time to complete a data source invocation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Errors: The number of errors that occurred during a data source invocation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics
         * will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code> accepts one of
         * these values at a time:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the
         * <code>metricsConfig</code> value set to <code>ENABLED</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataSourceLevelMetricsBehavior
         *        Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Requests: The number of invocations that occured during a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Latency: The time to complete a data source invocation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Errors: The number of errors that occurred during a data source invocation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        These metrics can be emitted to CloudWatch per data source or for all data sources in the request.
         *        Metrics will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code>
         *        accepts one of these values at a time:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in
         *        the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the
         *        <code>metricsConfig</code> value set to <code>ENABLED</code>.
         *        </p>
         *        </li>
         * @see DataSourceLevelMetricsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceLevelMetricsBehavior
         */
        Builder dataSourceLevelMetricsBehavior(String dataSourceLevelMetricsBehavior);

        /**
         * <p>
         * Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Requests: The number of invocations that occured during a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * Latency: The time to complete a data source invocation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Errors: The number of errors that occurred during a data source invocation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics
         * will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code> accepts one of
         * these values at a time:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the
         * <code>metricsConfig</code> value set to <code>ENABLED</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataSourceLevelMetricsBehavior
         *        Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Requests: The number of invocations that occured during a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Latency: The time to complete a data source invocation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Errors: The number of errors that occurred during a data source invocation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        These metrics can be emitted to CloudWatch per data source or for all data sources in the request.
         *        Metrics will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code>
         *        accepts one of these values at a time:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in
         *        the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the
         *        <code>metricsConfig</code> value set to <code>ENABLED</code>.
         *        </p>
         *        </li>
         * @see DataSourceLevelMetricsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceLevelMetricsBehavior
         */
        Builder dataSourceLevelMetricsBehavior(DataSourceLevelMetricsBehavior dataSourceLevelMetricsBehavior);

        /**
         * <p>
         * Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Requests: The number of times a specified GraphQL operation was called.
         * </p>
         * </li>
         * <li>
         * <p>
         * GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param operationLevelMetricsConfig
         *        Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Requests: The number of times a specified GraphQL operation was called.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code>
         *        or <code>DISABLED</code>.
         * @see OperationLevelMetricsConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationLevelMetricsConfig
         */
        Builder operationLevelMetricsConfig(String operationLevelMetricsConfig);

        /**
         * <p>
         * Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Requests: The number of times a specified GraphQL operation was called.
         * </p>
         * </li>
         * <li>
         * <p>
         * GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param operationLevelMetricsConfig
         *        Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Requests: The number of times a specified GraphQL operation was called.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code>
         *        or <code>DISABLED</code>.
         * @see OperationLevelMetricsConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationLevelMetricsConfig
         */
        Builder operationLevelMetricsConfig(OperationLevelMetricsConfig operationLevelMetricsConfig);
    }

    static final class BuilderImpl implements Builder {
        private String resolverLevelMetricsBehavior;

        private String dataSourceLevelMetricsBehavior;

        private String operationLevelMetricsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EnhancedMetricsConfig model) {
            resolverLevelMetricsBehavior(model.resolverLevelMetricsBehavior);
            dataSourceLevelMetricsBehavior(model.dataSourceLevelMetricsBehavior);
            operationLevelMetricsConfig(model.operationLevelMetricsConfig);
        }

        public final String getResolverLevelMetricsBehavior() {
            return resolverLevelMetricsBehavior;
        }

        public final void setResolverLevelMetricsBehavior(String resolverLevelMetricsBehavior) {
            this.resolverLevelMetricsBehavior = resolverLevelMetricsBehavior;
        }

        @Override
        public final Builder resolverLevelMetricsBehavior(String resolverLevelMetricsBehavior) {
            this.resolverLevelMetricsBehavior = resolverLevelMetricsBehavior;
            return this;
        }

        @Override
        public final Builder resolverLevelMetricsBehavior(ResolverLevelMetricsBehavior resolverLevelMetricsBehavior) {
            this.resolverLevelMetricsBehavior(resolverLevelMetricsBehavior == null ? null : resolverLevelMetricsBehavior
                    .toString());
            return this;
        }

        public final String getDataSourceLevelMetricsBehavior() {
            return dataSourceLevelMetricsBehavior;
        }

        public final void setDataSourceLevelMetricsBehavior(String dataSourceLevelMetricsBehavior) {
            this.dataSourceLevelMetricsBehavior = dataSourceLevelMetricsBehavior;
        }

        @Override
        public final Builder dataSourceLevelMetricsBehavior(String dataSourceLevelMetricsBehavior) {
            this.dataSourceLevelMetricsBehavior = dataSourceLevelMetricsBehavior;
            return this;
        }

        @Override
        public final Builder dataSourceLevelMetricsBehavior(DataSourceLevelMetricsBehavior dataSourceLevelMetricsBehavior) {
            this.dataSourceLevelMetricsBehavior(dataSourceLevelMetricsBehavior == null ? null : dataSourceLevelMetricsBehavior
                    .toString());
            return this;
        }

        public final String getOperationLevelMetricsConfig() {
            return operationLevelMetricsConfig;
        }

        public final void setOperationLevelMetricsConfig(String operationLevelMetricsConfig) {
            this.operationLevelMetricsConfig = operationLevelMetricsConfig;
        }

        @Override
        public final Builder operationLevelMetricsConfig(String operationLevelMetricsConfig) {
            this.operationLevelMetricsConfig = operationLevelMetricsConfig;
            return this;
        }

        @Override
        public final Builder operationLevelMetricsConfig(OperationLevelMetricsConfig operationLevelMetricsConfig) {
            this.operationLevelMetricsConfig(operationLevelMetricsConfig == null ? null : operationLevelMetricsConfig.toString());
            return this;
        }

        @Override
        public EnhancedMetricsConfig build() {
            return new EnhancedMetricsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
