/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a handler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HandlerConfig implements SdkPojo, Serializable, ToCopyableBuilder<HandlerConfig.Builder, HandlerConfig> {
    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("behavior").getter(getter(HandlerConfig::behaviorAsString)).setter(setter(Builder::behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()).build();

    private static final SdkField<Integration> INTEGRATION_FIELD = SdkField.<Integration> builder(MarshallingType.SDK_POJO)
            .memberName("integration").getter(getter(HandlerConfig::integration)).setter(setter(Builder::integration))
            .constructor(Integration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHAVIOR_FIELD,
            INTEGRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String behavior;

    private final Integration integration;

    private HandlerConfig(BuilderImpl builder) {
        this.behavior = builder.behavior;
        this.integration = builder.integration;
    }

    /**
     * <p>
     * The behavior for the handler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link HandlerBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return The behavior for the handler.
     * @see HandlerBehavior
     */
    public final HandlerBehavior behavior() {
        return HandlerBehavior.fromValue(behavior);
    }

    /**
     * <p>
     * The behavior for the handler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link HandlerBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return The behavior for the handler.
     * @see HandlerBehavior
     */
    public final String behaviorAsString() {
        return behavior;
    }

    /**
     * <p>
     * The integration data source configuration for the handler.
     * </p>
     * 
     * @return The integration data source configuration for the handler.
     */
    public final Integration integration() {
        return integration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(behaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandlerConfig)) {
            return false;
        }
        HandlerConfig other = (HandlerConfig) obj;
        return Objects.equals(behaviorAsString(), other.behaviorAsString()) && Objects.equals(integration(), other.integration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HandlerConfig").add("Behavior", behaviorAsString()).add("Integration", integration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "behavior":
            return Optional.ofNullable(clazz.cast(behaviorAsString()));
        case "integration":
            return Optional.ofNullable(clazz.cast(integration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("behavior", BEHAVIOR_FIELD);
        map.put("integration", INTEGRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HandlerConfig, T> g) {
        return obj -> g.apply((HandlerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HandlerConfig> {
        /**
         * <p>
         * The behavior for the handler.
         * </p>
         * 
         * @param behavior
         *        The behavior for the handler.
         * @see HandlerBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandlerBehavior
         */
        Builder behavior(String behavior);

        /**
         * <p>
         * The behavior for the handler.
         * </p>
         * 
         * @param behavior
         *        The behavior for the handler.
         * @see HandlerBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandlerBehavior
         */
        Builder behavior(HandlerBehavior behavior);

        /**
         * <p>
         * The integration data source configuration for the handler.
         * </p>
         * 
         * @param integration
         *        The integration data source configuration for the handler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integration(Integration integration);

        /**
         * <p>
         * The integration data source configuration for the handler.
         * </p>
         * This is a convenience method that creates an instance of the {@link Integration.Builder} avoiding the need to
         * create one manually via {@link Integration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Integration.Builder#build()} is called immediately and its result
         * is passed to {@link #integration(Integration)}.
         * 
         * @param integration
         *        a consumer that will call methods on {@link Integration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integration(Integration)
         */
        default Builder integration(Consumer<Integration.Builder> integration) {
            return integration(Integration.builder().applyMutation(integration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String behavior;

        private Integration integration;

        private BuilderImpl() {
        }

        private BuilderImpl(HandlerConfig model) {
            behavior(model.behavior);
            integration(model.integration);
        }

        public final String getBehavior() {
            return behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(HandlerBehavior behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final Integration.Builder getIntegration() {
            return integration != null ? integration.toBuilder() : null;
        }

        public final void setIntegration(Integration.BuilderImpl integration) {
            this.integration = integration != null ? integration.build() : null;
        }

        @Override
        public final Builder integration(Integration integration) {
            this.integration = integration;
            return this;
        }

        @Override
        public HandlerConfig build() {
            return new HandlerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
