/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the <code>OnPublish</code> and <code>OnSubscribe</code> handlers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HandlerConfigs implements SdkPojo, Serializable, ToCopyableBuilder<HandlerConfigs.Builder, HandlerConfigs> {
    private static final SdkField<HandlerConfig> ON_PUBLISH_FIELD = SdkField.<HandlerConfig> builder(MarshallingType.SDK_POJO)
            .memberName("onPublish").getter(getter(HandlerConfigs::onPublish)).setter(setter(Builder::onPublish))
            .constructor(HandlerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPublish").build()).build();

    private static final SdkField<HandlerConfig> ON_SUBSCRIBE_FIELD = SdkField.<HandlerConfig> builder(MarshallingType.SDK_POJO)
            .memberName("onSubscribe").getter(getter(HandlerConfigs::onSubscribe)).setter(setter(Builder::onSubscribe))
            .constructor(HandlerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onSubscribe").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ON_PUBLISH_FIELD,
            ON_SUBSCRIBE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HandlerConfig onPublish;

    private final HandlerConfig onSubscribe;

    private HandlerConfigs(BuilderImpl builder) {
        this.onPublish = builder.onPublish;
        this.onSubscribe = builder.onSubscribe;
    }

    /**
     * <p>
     * The configuration for the <code>OnPublish</code> handler.
     * </p>
     * 
     * @return The configuration for the <code>OnPublish</code> handler.
     */
    public final HandlerConfig onPublish() {
        return onPublish;
    }

    /**
     * <p>
     * The configuration for the <code>OnSubscribe</code> handler.
     * </p>
     * 
     * @return The configuration for the <code>OnSubscribe</code> handler.
     */
    public final HandlerConfig onSubscribe() {
        return onSubscribe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(onPublish());
        hashCode = 31 * hashCode + Objects.hashCode(onSubscribe());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandlerConfigs)) {
            return false;
        }
        HandlerConfigs other = (HandlerConfigs) obj;
        return Objects.equals(onPublish(), other.onPublish()) && Objects.equals(onSubscribe(), other.onSubscribe());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HandlerConfigs").add("OnPublish", onPublish()).add("OnSubscribe", onSubscribe()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "onPublish":
            return Optional.ofNullable(clazz.cast(onPublish()));
        case "onSubscribe":
            return Optional.ofNullable(clazz.cast(onSubscribe()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("onPublish", ON_PUBLISH_FIELD);
        map.put("onSubscribe", ON_SUBSCRIBE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HandlerConfigs, T> g) {
        return obj -> g.apply((HandlerConfigs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HandlerConfigs> {
        /**
         * <p>
         * The configuration for the <code>OnPublish</code> handler.
         * </p>
         * 
         * @param onPublish
         *        The configuration for the <code>OnPublish</code> handler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPublish(HandlerConfig onPublish);

        /**
         * <p>
         * The configuration for the <code>OnPublish</code> handler.
         * </p>
         * This is a convenience method that creates an instance of the {@link HandlerConfig.Builder} avoiding the need
         * to create one manually via {@link HandlerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HandlerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onPublish(HandlerConfig)}.
         * 
         * @param onPublish
         *        a consumer that will call methods on {@link HandlerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPublish(HandlerConfig)
         */
        default Builder onPublish(Consumer<HandlerConfig.Builder> onPublish) {
            return onPublish(HandlerConfig.builder().applyMutation(onPublish).build());
        }

        /**
         * <p>
         * The configuration for the <code>OnSubscribe</code> handler.
         * </p>
         * 
         * @param onSubscribe
         *        The configuration for the <code>OnSubscribe</code> handler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onSubscribe(HandlerConfig onSubscribe);

        /**
         * <p>
         * The configuration for the <code>OnSubscribe</code> handler.
         * </p>
         * This is a convenience method that creates an instance of the {@link HandlerConfig.Builder} avoiding the need
         * to create one manually via {@link HandlerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HandlerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onSubscribe(HandlerConfig)}.
         * 
         * @param onSubscribe
         *        a consumer that will call methods on {@link HandlerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onSubscribe(HandlerConfig)
         */
        default Builder onSubscribe(Consumer<HandlerConfig.Builder> onSubscribe) {
            return onSubscribe(HandlerConfig.builder().applyMutation(onSubscribe).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HandlerConfig onPublish;

        private HandlerConfig onSubscribe;

        private BuilderImpl() {
        }

        private BuilderImpl(HandlerConfigs model) {
            onPublish(model.onPublish);
            onSubscribe(model.onSubscribe);
        }

        public final HandlerConfig.Builder getOnPublish() {
            return onPublish != null ? onPublish.toBuilder() : null;
        }

        public final void setOnPublish(HandlerConfig.BuilderImpl onPublish) {
            this.onPublish = onPublish != null ? onPublish.build() : null;
        }

        @Override
        public final Builder onPublish(HandlerConfig onPublish) {
            this.onPublish = onPublish;
            return this;
        }

        public final HandlerConfig.Builder getOnSubscribe() {
            return onSubscribe != null ? onSubscribe.toBuilder() : null;
        }

        public final void setOnSubscribe(HandlerConfig.BuilderImpl onSubscribe) {
            this.onSubscribe = onSubscribe != null ? onSubscribe.build() : null;
        }

        @Override
        public final Builder onSubscribe(HandlerConfig onSubscribe) {
            this.onSubscribe = onSubscribe;
            return this;
        }

        @Override
        public HandlerConfigs build() {
            return new HandlerConfigs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
