/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The integration data source configuration for the handler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Integration implements SdkPojo, Serializable, ToCopyableBuilder<Integration.Builder, Integration> {
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceName").getter(getter(Integration::dataSourceName)).setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()).build();

    private static final SdkField<LambdaConfig> LAMBDA_CONFIG_FIELD = SdkField.<LambdaConfig> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaConfig").getter(getter(Integration::lambdaConfig)).setter(setter(Builder::lambdaConfig))
            .constructor(LambdaConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_NAME_FIELD,
            LAMBDA_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSourceName;

    private final LambdaConfig lambdaConfig;

    private Integration(BuilderImpl builder) {
        this.dataSourceName = builder.dataSourceName;
        this.lambdaConfig = builder.lambdaConfig;
    }

    /**
     * <p>
     * The unique name of the data source that has been configured on the API.
     * </p>
     * 
     * @return The unique name of the data source that has been configured on the API.
     */
    public final String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The configuration for a Lambda data source.
     * </p>
     * 
     * @return The configuration for a Lambda data source.
     */
    public final LambdaConfig lambdaConfig() {
        return lambdaConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Integration)) {
            return false;
        }
        Integration other = (Integration) obj;
        return Objects.equals(dataSourceName(), other.dataSourceName()) && Objects.equals(lambdaConfig(), other.lambdaConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Integration").add("DataSourceName", dataSourceName()).add("LambdaConfig", lambdaConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "lambdaConfig":
            return Optional.ofNullable(clazz.cast(lambdaConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSourceName", DATA_SOURCE_NAME_FIELD);
        map.put("lambdaConfig", LAMBDA_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Integration, T> g) {
        return obj -> g.apply((Integration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Integration> {
        /**
         * <p>
         * The unique name of the data source that has been configured on the API.
         * </p>
         * 
         * @param dataSourceName
         *        The unique name of the data source that has been configured on the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The configuration for a Lambda data source.
         * </p>
         * 
         * @param lambdaConfig
         *        The configuration for a Lambda data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConfig(LambdaConfig lambdaConfig);

        /**
         * <p>
         * The configuration for a Lambda data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaConfig.Builder} avoiding the need
         * to create one manually via {@link LambdaConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaConfig(LambdaConfig)}.
         * 
         * @param lambdaConfig
         *        a consumer that will call methods on {@link LambdaConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaConfig(LambdaConfig)
         */
        default Builder lambdaConfig(Consumer<LambdaConfig.Builder> lambdaConfig) {
            return lambdaConfig(LambdaConfig.builder().applyMutation(lambdaConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceName;

        private LambdaConfig lambdaConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Integration model) {
            dataSourceName(model.dataSourceName);
            lambdaConfig(model.lambdaConfig);
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final LambdaConfig.Builder getLambdaConfig() {
            return lambdaConfig != null ? lambdaConfig.toBuilder() : null;
        }

        public final void setLambdaConfig(LambdaConfig.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaConfig lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        @Override
        public Integration build() {
            return new Integration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
