/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a Lambda data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaConfig implements SdkPojo, Serializable, ToCopyableBuilder<LambdaConfig.Builder, LambdaConfig> {
    private static final SdkField<String> INVOKE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invokeType").getter(getter(LambdaConfig::invokeTypeAsString)).setter(setter(Builder::invokeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOKE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String invokeType;

    private LambdaConfig(BuilderImpl builder) {
        this.invokeType = builder.invokeType;
    }

    /**
     * <p>
     * The invocation type for a Lambda data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invokeType} will
     * return {@link InvokeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokeTypeAsString}.
     * </p>
     * 
     * @return The invocation type for a Lambda data source.
     * @see InvokeType
     */
    public final InvokeType invokeType() {
        return InvokeType.fromValue(invokeType);
    }

    /**
     * <p>
     * The invocation type for a Lambda data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invokeType} will
     * return {@link InvokeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokeTypeAsString}.
     * </p>
     * 
     * @return The invocation type for a Lambda data source.
     * @see InvokeType
     */
    public final String invokeTypeAsString() {
        return invokeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invokeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaConfig)) {
            return false;
        }
        LambdaConfig other = (LambdaConfig) obj;
        return Objects.equals(invokeTypeAsString(), other.invokeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaConfig").add("InvokeType", invokeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invokeType":
            return Optional.ofNullable(clazz.cast(invokeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invokeType", INVOKE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaConfig, T> g) {
        return obj -> g.apply((LambdaConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaConfig> {
        /**
         * <p>
         * The invocation type for a Lambda data source.
         * </p>
         * 
         * @param invokeType
         *        The invocation type for a Lambda data source.
         * @see InvokeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvokeType
         */
        Builder invokeType(String invokeType);

        /**
         * <p>
         * The invocation type for a Lambda data source.
         * </p>
         * 
         * @param invokeType
         *        The invocation type for a Lambda data source.
         * @see InvokeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvokeType
         */
        Builder invokeType(InvokeType invokeType);
    }

    static final class BuilderImpl implements Builder {
        private String invokeType;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaConfig model) {
            invokeType(model.invokeType);
        }

        public final String getInvokeType() {
            return invokeType;
        }

        public final void setInvokeType(String invokeType) {
            this.invokeType = invokeType;
        }

        @Override
        public final Builder invokeType(String invokeType) {
            this.invokeType = invokeType;
            return this;
        }

        @Override
        public final Builder invokeType(InvokeType invokeType) {
            this.invokeType(invokeType == null ? null : invokeType.toString());
            return this;
        }

        @Override
        public LambdaConfig build() {
            return new LambdaConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
