/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the metadata required to introspect the RDS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsDataApiConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsDataApiConfig.Builder, RdsDataApiConfig> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(RdsDataApiConfig::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretArn").getter(getter(RdsDataApiConfig::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(RdsDataApiConfig::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            SECRET_ARN_FIELD, DATABASE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String secretArn;

    private final String databaseName;

    private RdsDataApiConfig(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.secretArn = builder.secretArn;
        this.databaseName = builder.databaseName;
    }

    /**
     * <p>
     * The resource ARN of the RDS cluster.
     * </p>
     * 
     * @return The resource ARN of the RDS cluster.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The secret's ARN that was obtained from Secrets Manager. A secret consists of secret information, the secret
     * value, plus metadata about the secret. A secret value can be a string or binary. It typically includes the ARN,
     * secret name and description, policies, tags, encryption key from the Key Management Service, and key rotation
     * data.
     * </p>
     * 
     * @return The secret's ARN that was obtained from Secrets Manager. A secret consists of secret information, the
     *         secret value, plus metadata about the secret. A secret value can be a string or binary. It typically
     *         includes the ARN, secret name and description, policies, tags, encryption key from the Key Management
     *         Service, and key rotation data.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The name of the database in the cluster.
     * </p>
     * 
     * @return The name of the database in the cluster.
     */
    public final String databaseName() {
        return databaseName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDataApiConfig)) {
            return false;
        }
        RdsDataApiConfig other = (RdsDataApiConfig) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(databaseName(), other.databaseName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsDataApiConfig").add("ResourceArn", resourceArn()).add("SecretArn", secretArn())
                .add("DatabaseName", databaseName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "secretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("secretArn", SECRET_ARN_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsDataApiConfig, T> g) {
        return obj -> g.apply((RdsDataApiConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsDataApiConfig> {
        /**
         * <p>
         * The resource ARN of the RDS cluster.
         * </p>
         * 
         * @param resourceArn
         *        The resource ARN of the RDS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The secret's ARN that was obtained from Secrets Manager. A secret consists of secret information, the secret
         * value, plus metadata about the secret. A secret value can be a string or binary. It typically includes the
         * ARN, secret name and description, policies, tags, encryption key from the Key Management Service, and key
         * rotation data.
         * </p>
         * 
         * @param secretArn
         *        The secret's ARN that was obtained from Secrets Manager. A secret consists of secret information, the
         *        secret value, plus metadata about the secret. A secret value can be a string or binary. It typically
         *        includes the ARN, secret name and description, policies, tags, encryption key from the Key Management
         *        Service, and key rotation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The name of the database in the cluster.
         * </p>
         * 
         * @param databaseName
         *        The name of the database in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String secretArn;

        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDataApiConfig model) {
            resourceArn(model.resourceArn);
            secretArn(model.secretArn);
            databaseName(model.databaseName);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        @Override
        public RdsDataApiConfig build() {
            return new RdsDataApiConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
