/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a relational database data source configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationalDatabaseDataSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationalDatabaseDataSourceConfig.Builder, RelationalDatabaseDataSourceConfig> {
    private static final SdkField<String> RELATIONAL_DATABASE_SOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("relationalDatabaseSourceType")
            .getter(getter(RelationalDatabaseDataSourceConfig::relationalDatabaseSourceTypeAsString))
            .setter(setter(Builder::relationalDatabaseSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseSourceType")
                    .build()).build();

    private static final SdkField<RdsHttpEndpointConfig> RDS_HTTP_ENDPOINT_CONFIG_FIELD = SdkField
            .<RdsHttpEndpointConfig> builder(MarshallingType.SDK_POJO).memberName("rdsHttpEndpointConfig")
            .getter(getter(RelationalDatabaseDataSourceConfig::rdsHttpEndpointConfig))
            .setter(setter(Builder::rdsHttpEndpointConfig)).constructor(RdsHttpEndpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsHttpEndpointConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_SOURCE_TYPE_FIELD, RDS_HTTP_ENDPOINT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String relationalDatabaseSourceType;

    private final RdsHttpEndpointConfig rdsHttpEndpointConfig;

    private RelationalDatabaseDataSourceConfig(BuilderImpl builder) {
        this.relationalDatabaseSourceType = builder.relationalDatabaseSourceType;
        this.rdsHttpEndpointConfig = builder.rdsHttpEndpointConfig;
    }

    /**
     * <p>
     * Source type for the relational database.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>RDS_HTTP_ENDPOINT</b>: The relational database source type is an Amazon Relational Database Service (Amazon
     * RDS) HTTP endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relationalDatabaseSourceType} will return {@link RelationalDatabaseSourceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #relationalDatabaseSourceTypeAsString}.
     * </p>
     * 
     * @return Source type for the relational database.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>RDS_HTTP_ENDPOINT</b>: The relational database source type is an Amazon Relational Database Service
     *         (Amazon RDS) HTTP endpoint.
     *         </p>
     *         </li>
     * @see RelationalDatabaseSourceType
     */
    public final RelationalDatabaseSourceType relationalDatabaseSourceType() {
        return RelationalDatabaseSourceType.fromValue(relationalDatabaseSourceType);
    }

    /**
     * <p>
     * Source type for the relational database.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>RDS_HTTP_ENDPOINT</b>: The relational database source type is an Amazon Relational Database Service (Amazon
     * RDS) HTTP endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relationalDatabaseSourceType} will return {@link RelationalDatabaseSourceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #relationalDatabaseSourceTypeAsString}.
     * </p>
     * 
     * @return Source type for the relational database.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>RDS_HTTP_ENDPOINT</b>: The relational database source type is an Amazon Relational Database Service
     *         (Amazon RDS) HTTP endpoint.
     *         </p>
     *         </li>
     * @see RelationalDatabaseSourceType
     */
    public final String relationalDatabaseSourceTypeAsString() {
        return relationalDatabaseSourceType;
    }

    /**
     * <p>
     * Amazon RDS HTTP endpoint settings.
     * </p>
     * 
     * @return Amazon RDS HTTP endpoint settings.
     */
    public final RdsHttpEndpointConfig rdsHttpEndpointConfig() {
        return rdsHttpEndpointConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rdsHttpEndpointConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseDataSourceConfig)) {
            return false;
        }
        RelationalDatabaseDataSourceConfig other = (RelationalDatabaseDataSourceConfig) obj;
        return Objects.equals(relationalDatabaseSourceTypeAsString(), other.relationalDatabaseSourceTypeAsString())
                && Objects.equals(rdsHttpEndpointConfig(), other.rdsHttpEndpointConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelationalDatabaseDataSourceConfig")
                .add("RelationalDatabaseSourceType", relationalDatabaseSourceTypeAsString())
                .add("RdsHttpEndpointConfig", rdsHttpEndpointConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseSourceType":
            return Optional.ofNullable(clazz.cast(relationalDatabaseSourceTypeAsString()));
        case "rdsHttpEndpointConfig":
            return Optional.ofNullable(clazz.cast(rdsHttpEndpointConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relationalDatabaseSourceType", RELATIONAL_DATABASE_SOURCE_TYPE_FIELD);
        map.put("rdsHttpEndpointConfig", RDS_HTTP_ENDPOINT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseDataSourceConfig, T> g) {
        return obj -> g.apply((RelationalDatabaseDataSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationalDatabaseDataSourceConfig> {
        /**
         * <p>
         * Source type for the relational database.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>RDS_HTTP_ENDPOINT</b>: The relational database source type is an Amazon Relational Database Service
         * (Amazon RDS) HTTP endpoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param relationalDatabaseSourceType
         *        Source type for the relational database.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>RDS_HTTP_ENDPOINT</b>: The relational database source type is an Amazon Relational Database Service
         *        (Amazon RDS) HTTP endpoint.
         *        </p>
         *        </li>
         * @see RelationalDatabaseSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationalDatabaseSourceType
         */
        Builder relationalDatabaseSourceType(String relationalDatabaseSourceType);

        /**
         * <p>
         * Source type for the relational database.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>RDS_HTTP_ENDPOINT</b>: The relational database source type is an Amazon Relational Database Service
         * (Amazon RDS) HTTP endpoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param relationalDatabaseSourceType
         *        Source type for the relational database.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>RDS_HTTP_ENDPOINT</b>: The relational database source type is an Amazon Relational Database Service
         *        (Amazon RDS) HTTP endpoint.
         *        </p>
         *        </li>
         * @see RelationalDatabaseSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationalDatabaseSourceType
         */
        Builder relationalDatabaseSourceType(RelationalDatabaseSourceType relationalDatabaseSourceType);

        /**
         * <p>
         * Amazon RDS HTTP endpoint settings.
         * </p>
         * 
         * @param rdsHttpEndpointConfig
         *        Amazon RDS HTTP endpoint settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsHttpEndpointConfig(RdsHttpEndpointConfig rdsHttpEndpointConfig);

        /**
         * <p>
         * Amazon RDS HTTP endpoint settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsHttpEndpointConfig.Builder} avoiding
         * the need to create one manually via {@link RdsHttpEndpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsHttpEndpointConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #rdsHttpEndpointConfig(RdsHttpEndpointConfig)}.
         * 
         * @param rdsHttpEndpointConfig
         *        a consumer that will call methods on {@link RdsHttpEndpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsHttpEndpointConfig(RdsHttpEndpointConfig)
         */
        default Builder rdsHttpEndpointConfig(Consumer<RdsHttpEndpointConfig.Builder> rdsHttpEndpointConfig) {
            return rdsHttpEndpointConfig(RdsHttpEndpointConfig.builder().applyMutation(rdsHttpEndpointConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String relationalDatabaseSourceType;

        private RdsHttpEndpointConfig rdsHttpEndpointConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseDataSourceConfig model) {
            relationalDatabaseSourceType(model.relationalDatabaseSourceType);
            rdsHttpEndpointConfig(model.rdsHttpEndpointConfig);
        }

        public final String getRelationalDatabaseSourceType() {
            return relationalDatabaseSourceType;
        }

        public final void setRelationalDatabaseSourceType(String relationalDatabaseSourceType) {
            this.relationalDatabaseSourceType = relationalDatabaseSourceType;
        }

        @Override
        public final Builder relationalDatabaseSourceType(String relationalDatabaseSourceType) {
            this.relationalDatabaseSourceType = relationalDatabaseSourceType;
            return this;
        }

        @Override
        public final Builder relationalDatabaseSourceType(RelationalDatabaseSourceType relationalDatabaseSourceType) {
            this.relationalDatabaseSourceType(relationalDatabaseSourceType == null ? null : relationalDatabaseSourceType
                    .toString());
            return this;
        }

        public final RdsHttpEndpointConfig.Builder getRdsHttpEndpointConfig() {
            return rdsHttpEndpointConfig != null ? rdsHttpEndpointConfig.toBuilder() : null;
        }

        public final void setRdsHttpEndpointConfig(RdsHttpEndpointConfig.BuilderImpl rdsHttpEndpointConfig) {
            this.rdsHttpEndpointConfig = rdsHttpEndpointConfig != null ? rdsHttpEndpointConfig.build() : null;
        }

        @Override
        public final Builder rdsHttpEndpointConfig(RdsHttpEndpointConfig rdsHttpEndpointConfig) {
            this.rdsHttpEndpointConfig = rdsHttpEndpointConfig;
            return this;
        }

        @Override
        public RelationalDatabaseDataSourceConfig build() {
            return new RelationalDatabaseDataSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
