/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes properties used to specify configurations related to a source API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceApiAssociationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceApiAssociationConfig.Builder, SourceApiAssociationConfig> {
    private static final SdkField<String> MERGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeType").getter(getter(SourceApiAssociationConfig::mergeTypeAsString))
            .setter(setter(Builder::mergeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mergeType;

    private SourceApiAssociationConfig(BuilderImpl builder) {
        this.mergeType = builder.mergeType;
    }

    /**
     * <p>
     * The property that indicates which merging option is enabled in the source API association.
     * </p>
     * <p>
     * Valid merge types are <code>MANUAL_MERGE</code> (default) and <code>AUTO_MERGE</code>. Manual merges are the
     * default behavior and require the user to trigger any changes from the source APIs to the merged API manually.
     * Auto merges subscribe the merged API to the changes performed on the source APIs so that any change in the source
     * APIs are also made to the merged API. Auto merges use <code>MergedApiExecutionRoleArn</code> to perform merge
     * operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeType} will
     * return {@link MergeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeTypeAsString}.
     * </p>
     * 
     * @return The property that indicates which merging option is enabled in the source API association.</p>
     *         <p>
     *         Valid merge types are <code>MANUAL_MERGE</code> (default) and <code>AUTO_MERGE</code>. Manual merges are
     *         the default behavior and require the user to trigger any changes from the source APIs to the merged API
     *         manually. Auto merges subscribe the merged API to the changes performed on the source APIs so that any
     *         change in the source APIs are also made to the merged API. Auto merges use
     *         <code>MergedApiExecutionRoleArn</code> to perform merge operations.
     * @see MergeType
     */
    public final MergeType mergeType() {
        return MergeType.fromValue(mergeType);
    }

    /**
     * <p>
     * The property that indicates which merging option is enabled in the source API association.
     * </p>
     * <p>
     * Valid merge types are <code>MANUAL_MERGE</code> (default) and <code>AUTO_MERGE</code>. Manual merges are the
     * default behavior and require the user to trigger any changes from the source APIs to the merged API manually.
     * Auto merges subscribe the merged API to the changes performed on the source APIs so that any change in the source
     * APIs are also made to the merged API. Auto merges use <code>MergedApiExecutionRoleArn</code> to perform merge
     * operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeType} will
     * return {@link MergeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeTypeAsString}.
     * </p>
     * 
     * @return The property that indicates which merging option is enabled in the source API association.</p>
     *         <p>
     *         Valid merge types are <code>MANUAL_MERGE</code> (default) and <code>AUTO_MERGE</code>. Manual merges are
     *         the default behavior and require the user to trigger any changes from the source APIs to the merged API
     *         manually. Auto merges subscribe the merged API to the changes performed on the source APIs so that any
     *         change in the source APIs are also made to the merged API. Auto merges use
     *         <code>MergedApiExecutionRoleArn</code> to perform merge operations.
     * @see MergeType
     */
    public final String mergeTypeAsString() {
        return mergeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mergeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceApiAssociationConfig)) {
            return false;
        }
        SourceApiAssociationConfig other = (SourceApiAssociationConfig) obj;
        return Objects.equals(mergeTypeAsString(), other.mergeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceApiAssociationConfig").add("MergeType", mergeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mergeType":
            return Optional.ofNullable(clazz.cast(mergeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mergeType", MERGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceApiAssociationConfig, T> g) {
        return obj -> g.apply((SourceApiAssociationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceApiAssociationConfig> {
        /**
         * <p>
         * The property that indicates which merging option is enabled in the source API association.
         * </p>
         * <p>
         * Valid merge types are <code>MANUAL_MERGE</code> (default) and <code>AUTO_MERGE</code>. Manual merges are the
         * default behavior and require the user to trigger any changes from the source APIs to the merged API manually.
         * Auto merges subscribe the merged API to the changes performed on the source APIs so that any change in the
         * source APIs are also made to the merged API. Auto merges use <code>MergedApiExecutionRoleArn</code> to
         * perform merge operations.
         * </p>
         * 
         * @param mergeType
         *        The property that indicates which merging option is enabled in the source API association.</p>
         *        <p>
         *        Valid merge types are <code>MANUAL_MERGE</code> (default) and <code>AUTO_MERGE</code>. Manual merges
         *        are the default behavior and require the user to trigger any changes from the source APIs to the
         *        merged API manually. Auto merges subscribe the merged API to the changes performed on the source APIs
         *        so that any change in the source APIs are also made to the merged API. Auto merges use
         *        <code>MergedApiExecutionRoleArn</code> to perform merge operations.
         * @see MergeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeType
         */
        Builder mergeType(String mergeType);

        /**
         * <p>
         * The property that indicates which merging option is enabled in the source API association.
         * </p>
         * <p>
         * Valid merge types are <code>MANUAL_MERGE</code> (default) and <code>AUTO_MERGE</code>. Manual merges are the
         * default behavior and require the user to trigger any changes from the source APIs to the merged API manually.
         * Auto merges subscribe the merged API to the changes performed on the source APIs so that any change in the
         * source APIs are also made to the merged API. Auto merges use <code>MergedApiExecutionRoleArn</code> to
         * perform merge operations.
         * </p>
         * 
         * @param mergeType
         *        The property that indicates which merging option is enabled in the source API association.</p>
         *        <p>
         *        Valid merge types are <code>MANUAL_MERGE</code> (default) and <code>AUTO_MERGE</code>. Manual merges
         *        are the default behavior and require the user to trigger any changes from the source APIs to the
         *        merged API manually. Auto merges subscribe the merged API to the changes performed on the source APIs
         *        so that any change in the source APIs are also made to the merged API. Auto merges use
         *        <code>MergedApiExecutionRoleArn</code> to perform merge operations.
         * @see MergeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeType
         */
        Builder mergeType(MergeType mergeType);
    }

    static final class BuilderImpl implements Builder {
        private String mergeType;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceApiAssociationConfig model) {
            mergeType(model.mergeType);
        }

        public final String getMergeType() {
            return mergeType;
        }

        public final void setMergeType(String mergeType) {
            this.mergeType = mergeType;
        }

        @Override
        public final Builder mergeType(String mergeType) {
            this.mergeType = mergeType;
            return this;
        }

        @Override
        public final Builder mergeType(MergeType mergeType) {
            this.mergeType(mergeType == null ? null : mergeType.toString());
            return this;
        }

        @Override
        public SourceApiAssociationConfig build() {
            return new SourceApiAssociationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
