/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the ARNs and IDs of associations, Merged APIs, and source APIs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceApiAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceApiAssociationSummary.Builder, SourceApiAssociationSummary> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationId").getter(getter(SourceApiAssociationSummary::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()).build();

    private static final SdkField<String> ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationArn").getter(getter(SourceApiAssociationSummary::associationArn))
            .setter(setter(Builder::associationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationArn").build()).build();

    private static final SdkField<String> SOURCE_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceApiId").getter(getter(SourceApiAssociationSummary::sourceApiId))
            .setter(setter(Builder::sourceApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiId").build()).build();

    private static final SdkField<String> SOURCE_API_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceApiArn").getter(getter(SourceApiAssociationSummary::sourceApiArn))
            .setter(setter(Builder::sourceApiArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiArn").build()).build();

    private static final SdkField<String> MERGED_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergedApiId").getter(getter(SourceApiAssociationSummary::mergedApiId))
            .setter(setter(Builder::mergedApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedApiId").build()).build();

    private static final SdkField<String> MERGED_API_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergedApiArn").getter(getter(SourceApiAssociationSummary::mergedApiArn))
            .setter(setter(Builder::mergedApiArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedApiArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SourceApiAssociationSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            ASSOCIATION_ARN_FIELD, SOURCE_API_ID_FIELD, SOURCE_API_ARN_FIELD, MERGED_API_ID_FIELD, MERGED_API_ARN_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String associationArn;

    private final String sourceApiId;

    private final String sourceApiArn;

    private final String mergedApiId;

    private final String mergedApiArn;

    private final String description;

    private SourceApiAssociationSummary(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationArn = builder.associationArn;
        this.sourceApiId = builder.sourceApiId;
        this.sourceApiArn = builder.sourceApiArn;
        this.mergedApiId = builder.mergedApiId;
        this.mergedApiArn = builder.mergedApiArn;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     * 
     * @return The ID generated by the AppSync service for the source API association.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source API association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source API association.
     */
    public final String associationArn() {
        return associationArn;
    }

    /**
     * <p>
     * The ID of the AppSync source API.
     * </p>
     * 
     * @return The ID of the AppSync source API.
     */
    public final String sourceApiId() {
        return sourceApiId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AppSync Source API.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AppSync Source API.
     */
    public final String sourceApiArn() {
        return sourceApiArn;
    }

    /**
     * <p>
     * The ID of the AppSync Merged API.
     * </p>
     * 
     * @return The ID of the AppSync Merged API.
     */
    public final String mergedApiId() {
        return mergedApiId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AppSync Merged API.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AppSync Merged API.
     */
    public final String mergedApiArn() {
        return mergedApiArn;
    }

    /**
     * <p>
     * The description field.
     * </p>
     * 
     * @return The description field.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceApiId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceApiArn());
        hashCode = 31 * hashCode + Objects.hashCode(mergedApiId());
        hashCode = 31 * hashCode + Objects.hashCode(mergedApiArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceApiAssociationSummary)) {
            return false;
        }
        SourceApiAssociationSummary other = (SourceApiAssociationSummary) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(associationArn(), other.associationArn())
                && Objects.equals(sourceApiId(), other.sourceApiId()) && Objects.equals(sourceApiArn(), other.sourceApiArn())
                && Objects.equals(mergedApiId(), other.mergedApiId()) && Objects.equals(mergedApiArn(), other.mergedApiArn())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceApiAssociationSummary").add("AssociationId", associationId())
                .add("AssociationArn", associationArn()).add("SourceApiId", sourceApiId()).add("SourceApiArn", sourceApiArn())
                .add("MergedApiId", mergedApiId()).add("MergedApiArn", mergedApiArn()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "associationArn":
            return Optional.ofNullable(clazz.cast(associationArn()));
        case "sourceApiId":
            return Optional.ofNullable(clazz.cast(sourceApiId()));
        case "sourceApiArn":
            return Optional.ofNullable(clazz.cast(sourceApiArn()));
        case "mergedApiId":
            return Optional.ofNullable(clazz.cast(mergedApiId()));
        case "mergedApiArn":
            return Optional.ofNullable(clazz.cast(mergedApiArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associationId", ASSOCIATION_ID_FIELD);
        map.put("associationArn", ASSOCIATION_ARN_FIELD);
        map.put("sourceApiId", SOURCE_API_ID_FIELD);
        map.put("sourceApiArn", SOURCE_API_ARN_FIELD);
        map.put("mergedApiId", MERGED_API_ID_FIELD);
        map.put("mergedApiArn", MERGED_API_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceApiAssociationSummary, T> g) {
        return obj -> g.apply((SourceApiAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceApiAssociationSummary> {
        /**
         * <p>
         * The ID generated by the AppSync service for the source API association.
         * </p>
         * 
         * @param associationId
         *        The ID generated by the AppSync service for the source API association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source API association.
         * </p>
         * 
         * @param associationArn
         *        The Amazon Resource Name (ARN) of the source API association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationArn(String associationArn);

        /**
         * <p>
         * The ID of the AppSync source API.
         * </p>
         * 
         * @param sourceApiId
         *        The ID of the AppSync source API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApiId(String sourceApiId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AppSync Source API.
         * </p>
         * 
         * @param sourceApiArn
         *        The Amazon Resource Name (ARN) of the AppSync Source API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApiArn(String sourceApiArn);

        /**
         * <p>
         * The ID of the AppSync Merged API.
         * </p>
         * 
         * @param mergedApiId
         *        The ID of the AppSync Merged API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedApiId(String mergedApiId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AppSync Merged API.
         * </p>
         * 
         * @param mergedApiArn
         *        The Amazon Resource Name (ARN) of the AppSync Merged API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedApiArn(String mergedApiArn);

        /**
         * <p>
         * The description field.
         * </p>
         * 
         * @param description
         *        The description field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String associationArn;

        private String sourceApiId;

        private String sourceApiArn;

        private String mergedApiId;

        private String mergedApiArn;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceApiAssociationSummary model) {
            associationId(model.associationId);
            associationArn(model.associationArn);
            sourceApiId(model.sourceApiId);
            sourceApiArn(model.sourceApiArn);
            mergedApiId(model.mergedApiId);
            mergedApiArn(model.mergedApiArn);
            description(model.description);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getAssociationArn() {
            return associationArn;
        }

        public final void setAssociationArn(String associationArn) {
            this.associationArn = associationArn;
        }

        @Override
        public final Builder associationArn(String associationArn) {
            this.associationArn = associationArn;
            return this;
        }

        public final String getSourceApiId() {
            return sourceApiId;
        }

        public final void setSourceApiId(String sourceApiId) {
            this.sourceApiId = sourceApiId;
        }

        @Override
        public final Builder sourceApiId(String sourceApiId) {
            this.sourceApiId = sourceApiId;
            return this;
        }

        public final String getSourceApiArn() {
            return sourceApiArn;
        }

        public final void setSourceApiArn(String sourceApiArn) {
            this.sourceApiArn = sourceApiArn;
        }

        @Override
        public final Builder sourceApiArn(String sourceApiArn) {
            this.sourceApiArn = sourceApiArn;
            return this;
        }

        public final String getMergedApiId() {
            return mergedApiId;
        }

        public final void setMergedApiId(String mergedApiId) {
            this.mergedApiId = mergedApiId;
        }

        @Override
        public final Builder mergedApiId(String mergedApiId) {
            this.mergedApiId = mergedApiId;
            return this;
        }

        public final String getMergedApiArn() {
            return mergedApiArn;
        }

        public final void setMergedApiArn(String mergedApiArn) {
            this.mergedApiArn = mergedApiArn;
        }

        @Override
        public final Builder mergedApiArn(String mergedApiArn) {
            this.mergedApiArn = mergedApiArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SourceApiAssociationSummary build() {
            return new SourceApiAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
