/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.HandlerBehavior;
import software.amazon.awssdk.services.appsync.model.Integration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HandlerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HandlerConfig> {
    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("behavior").getter(HandlerConfig.getter(HandlerConfig::behaviorAsString)).setter(HandlerConfig.setter(Builder::behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()}).build();
    private static final SdkField<Integration> INTEGRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("integration").getter(HandlerConfig.getter(HandlerConfig::integration)).setter(HandlerConfig.setter(Builder::integration)).constructor(Integration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHAVIOR_FIELD, INTEGRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HandlerConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String behavior;
    private final Integration integration;

    private HandlerConfig(BuilderImpl builder) {
        this.behavior = builder.behavior;
        this.integration = builder.integration;
    }

    public final HandlerBehavior behavior() {
        return HandlerBehavior.fromValue(this.behavior);
    }

    public final String behaviorAsString() {
        return this.behavior;
    }

    public final Integration integration() {
        return this.integration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandlerConfig)) {
            return false;
        }
        HandlerConfig other = (HandlerConfig)obj;
        return Objects.equals(this.behaviorAsString(), other.behaviorAsString()) && Objects.equals(this.integration(), other.integration());
    }

    public final String toString() {
        return ToString.builder((String)"HandlerConfig").add("Behavior", (Object)this.behaviorAsString()).add("Integration", (Object)this.integration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "behavior": {
                return Optional.ofNullable(clazz.cast(this.behaviorAsString()));
            }
            case "integration": {
                return Optional.ofNullable(clazz.cast(this.integration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("behavior", BEHAVIOR_FIELD);
        map.put("integration", INTEGRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HandlerConfig, T> g) {
        return obj -> g.apply((HandlerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String behavior;
        private Integration integration;

        private BuilderImpl() {
        }

        private BuilderImpl(HandlerConfig model) {
            this.behavior(model.behavior);
            this.integration(model.integration);
        }

        public final String getBehavior() {
            return this.behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(HandlerBehavior behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final Integration.Builder getIntegration() {
            return this.integration != null ? this.integration.toBuilder() : null;
        }

        public final void setIntegration(Integration.BuilderImpl integration) {
            this.integration = integration != null ? integration.build() : null;
        }

        @Override
        public final Builder integration(Integration integration) {
            this.integration = integration;
            return this;
        }

        public HandlerConfig build() {
            return new HandlerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HandlerConfig> {
        public Builder behavior(String var1);

        public Builder behavior(HandlerBehavior var1);

        public Builder integration(Integration var1);

        default public Builder integration(Consumer<Integration.Builder> integration) {
            return this.integration((Integration)((Integration.Builder)Integration.builder().applyMutation(integration)).build());
        }
    }
}

