/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compares the action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareAction implements SdkPojo, Serializable, ToCopyableBuilder<CompareAction.Builder, CompareAction> {
    private static final SdkField<Input> INPUT_FIELD = SdkField.<Input> builder(MarshallingType.SDK_POJO).memberName("input")
            .getter(getter(CompareAction::input)).setter(setter(Builder::input)).constructor(Input::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<Output> OUTPUT_FIELD = SdkField.<Output> builder(MarshallingType.SDK_POJO).memberName("output")
            .getter(getter(CompareAction::output)).setter(setter(Builder::output)).constructor(Output::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Input input;

    private final Output output;

    private CompareAction(BuilderImpl builder) {
        this.input = builder.input;
        this.output = builder.output;
    }

    /**
     * <p>
     * The input of the compare action.
     * </p>
     * 
     * @return The input of the compare action.
     */
    public final Input input() {
        return input;
    }

    /**
     * <p>
     * The output of the compare action.
     * </p>
     * 
     * @return The output of the compare action.
     */
    public final Output output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareAction)) {
            return false;
        }
        CompareAction other = (CompareAction) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareAction").add("Input", input()).add("Output", output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompareAction, T> g) {
        return obj -> g.apply((CompareAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompareAction> {
        /**
         * <p>
         * The input of the compare action.
         * </p>
         * 
         * @param input
         *        The input of the compare action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(Input input);

        /**
         * <p>
         * The input of the compare action.
         * </p>
         * This is a convenience method that creates an instance of the {@link Input.Builder} avoiding the need to
         * create one manually via {@link Input#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Input.Builder#build()} is called immediately and its result is
         * passed to {@link #input(Input)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(Input)
         */
        default Builder input(Consumer<Input.Builder> input) {
            return input(Input.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * The output of the compare action.
         * </p>
         * 
         * @param output
         *        The output of the compare action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(Output output);

        /**
         * <p>
         * The output of the compare action.
         * </p>
         * This is a convenience method that creates an instance of the {@link Output.Builder} avoiding the need to
         * create one manually via {@link Output#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Output.Builder#build()} is called immediately and its result is
         * passed to {@link #output(Output)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link Output.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(Output)
         */
        default Builder output(Consumer<Output.Builder> output) {
            return output(Output.builder().applyMutation(output).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Input input;

        private Output output;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareAction model) {
            input(model.input);
            output(model.output);
        }

        public final Input.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(Input.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final Output.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(Output.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(Output output) {
            this.output = output;
            return this;
        }

        @Override
        public CompareAction build() {
            return new CompareAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
