/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the compare data sets step input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareDataSetsStepInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CompareDataSetsStepInput.Builder, CompareDataSetsStepInput> {
    private static final SdkField<String> SOURCE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceLocation").getter(getter(CompareDataSetsStepInput::sourceLocation))
            .setter(setter(Builder::sourceLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLocation").build()).build();

    private static final SdkField<String> TARGET_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetLocation").getter(getter(CompareDataSetsStepInput::targetLocation))
            .setter(setter(Builder::targetLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLocation").build()).build();

    private static final SdkField<List<DataSet>> SOURCE_DATA_SETS_FIELD = SdkField
            .<List<DataSet>> builder(MarshallingType.LIST)
            .memberName("sourceDataSets")
            .getter(getter(CompareDataSetsStepInput::sourceDataSets))
            .setter(setter(Builder::sourceDataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSet>> TARGET_DATA_SETS_FIELD = SdkField
            .<List<DataSet>> builder(MarshallingType.LIST)
            .memberName("targetDataSets")
            .getter(getter(CompareDataSetsStepInput::targetDataSets))
            .setter(setter(Builder::targetDataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_FIELD,
            TARGET_LOCATION_FIELD, SOURCE_DATA_SETS_FIELD, TARGET_DATA_SETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceLocation;

    private final String targetLocation;

    private final List<DataSet> sourceDataSets;

    private final List<DataSet> targetDataSets;

    private CompareDataSetsStepInput(BuilderImpl builder) {
        this.sourceLocation = builder.sourceLocation;
        this.targetLocation = builder.targetLocation;
        this.sourceDataSets = builder.sourceDataSets;
        this.targetDataSets = builder.targetDataSets;
    }

    /**
     * <p>
     * The source location of the compare data sets step input location.
     * </p>
     * 
     * @return The source location of the compare data sets step input location.
     */
    public final String sourceLocation() {
        return sourceLocation;
    }

    /**
     * <p>
     * The target location of the compare data sets step input location.
     * </p>
     * 
     * @return The target location of the compare data sets step input location.
     */
    public final String targetLocation() {
        return targetLocation;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceDataSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceDataSets() {
        return sourceDataSets != null && !(sourceDataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source data sets of the compare data sets step input location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceDataSets} method.
     * </p>
     * 
     * @return The source data sets of the compare data sets step input location.
     */
    public final List<DataSet> sourceDataSets() {
        return sourceDataSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetDataSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetDataSets() {
        return targetDataSets != null && !(targetDataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target data sets of the compare data sets step input location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetDataSets} method.
     * </p>
     * 
     * @return The target data sets of the compare data sets step input location.
     */
    public final List<DataSet> targetDataSets() {
        return targetDataSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(targetLocation());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceDataSets() ? sourceDataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetDataSets() ? targetDataSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareDataSetsStepInput)) {
            return false;
        }
        CompareDataSetsStepInput other = (CompareDataSetsStepInput) obj;
        return Objects.equals(sourceLocation(), other.sourceLocation())
                && Objects.equals(targetLocation(), other.targetLocation()) && hasSourceDataSets() == other.hasSourceDataSets()
                && Objects.equals(sourceDataSets(), other.sourceDataSets()) && hasTargetDataSets() == other.hasTargetDataSets()
                && Objects.equals(targetDataSets(), other.targetDataSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareDataSetsStepInput").add("SourceLocation", sourceLocation())
                .add("TargetLocation", targetLocation()).add("SourceDataSets", hasSourceDataSets() ? sourceDataSets() : null)
                .add("TargetDataSets", hasTargetDataSets() ? targetDataSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceLocation":
            return Optional.ofNullable(clazz.cast(sourceLocation()));
        case "targetLocation":
            return Optional.ofNullable(clazz.cast(targetLocation()));
        case "sourceDataSets":
            return Optional.ofNullable(clazz.cast(sourceDataSets()));
        case "targetDataSets":
            return Optional.ofNullable(clazz.cast(targetDataSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompareDataSetsStepInput, T> g) {
        return obj -> g.apply((CompareDataSetsStepInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompareDataSetsStepInput> {
        /**
         * <p>
         * The source location of the compare data sets step input location.
         * </p>
         * 
         * @param sourceLocation
         *        The source location of the compare data sets step input location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocation(String sourceLocation);

        /**
         * <p>
         * The target location of the compare data sets step input location.
         * </p>
         * 
         * @param targetLocation
         *        The target location of the compare data sets step input location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocation(String targetLocation);

        /**
         * <p>
         * The source data sets of the compare data sets step input location.
         * </p>
         * 
         * @param sourceDataSets
         *        The source data sets of the compare data sets step input location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDataSets(Collection<DataSet> sourceDataSets);

        /**
         * <p>
         * The source data sets of the compare data sets step input location.
         * </p>
         * 
         * @param sourceDataSets
         *        The source data sets of the compare data sets step input location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDataSets(DataSet... sourceDataSets);

        /**
         * <p>
         * The source data sets of the compare data sets step input location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.DataSet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.apptest.model.DataSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.DataSet.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceDataSets(List<DataSet>)}.
         * 
         * @param sourceDataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.DataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDataSets(java.util.Collection<DataSet>)
         */
        Builder sourceDataSets(Consumer<DataSet.Builder>... sourceDataSets);

        /**
         * <p>
         * The target data sets of the compare data sets step input location.
         * </p>
         * 
         * @param targetDataSets
         *        The target data sets of the compare data sets step input location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDataSets(Collection<DataSet> targetDataSets);

        /**
         * <p>
         * The target data sets of the compare data sets step input location.
         * </p>
         * 
         * @param targetDataSets
         *        The target data sets of the compare data sets step input location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDataSets(DataSet... targetDataSets);

        /**
         * <p>
         * The target data sets of the compare data sets step input location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.DataSet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.apptest.model.DataSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.DataSet.Builder#build()} is called immediately and its
         * result is passed to {@link #targetDataSets(List<DataSet>)}.
         * 
         * @param targetDataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.DataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetDataSets(java.util.Collection<DataSet>)
         */
        Builder targetDataSets(Consumer<DataSet.Builder>... targetDataSets);
    }

    static final class BuilderImpl implements Builder {
        private String sourceLocation;

        private String targetLocation;

        private List<DataSet> sourceDataSets = DefaultSdkAutoConstructList.getInstance();

        private List<DataSet> targetDataSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompareDataSetsStepInput model) {
            sourceLocation(model.sourceLocation);
            targetLocation(model.targetLocation);
            sourceDataSets(model.sourceDataSets);
            targetDataSets(model.targetDataSets);
        }

        public final String getSourceLocation() {
            return sourceLocation;
        }

        public final void setSourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        public final Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public final String getTargetLocation() {
            return targetLocation;
        }

        public final void setTargetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
        }

        @Override
        public final Builder targetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
            return this;
        }

        public final List<DataSet.Builder> getSourceDataSets() {
            List<DataSet.Builder> result = DataSetListCopier.copyToBuilder(this.sourceDataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataSets(Collection<DataSet.BuilderImpl> sourceDataSets) {
            this.sourceDataSets = DataSetListCopier.copyFromBuilder(sourceDataSets);
        }

        @Override
        public final Builder sourceDataSets(Collection<DataSet> sourceDataSets) {
            this.sourceDataSets = DataSetListCopier.copy(sourceDataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSets(DataSet... sourceDataSets) {
            sourceDataSets(Arrays.asList(sourceDataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSets(Consumer<DataSet.Builder>... sourceDataSets) {
            sourceDataSets(Stream.of(sourceDataSets).map(c -> DataSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DataSet.Builder> getTargetDataSets() {
            List<DataSet.Builder> result = DataSetListCopier.copyToBuilder(this.targetDataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetDataSets(Collection<DataSet.BuilderImpl> targetDataSets) {
            this.targetDataSets = DataSetListCopier.copyFromBuilder(targetDataSets);
        }

        @Override
        public final Builder targetDataSets(Collection<DataSet> targetDataSets) {
            this.targetDataSets = DataSetListCopier.copy(targetDataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataSets(DataSet... targetDataSets) {
            targetDataSets(Arrays.asList(targetDataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataSets(Consumer<DataSet.Builder>... targetDataSets) {
            targetDataSets(Stream.of(targetDataSets).map(c -> DataSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CompareDataSetsStepInput build() {
            return new CompareDataSetsStepInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
