/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTestSuiteRequest extends AppTestRequest implements
        ToCopyableBuilder<CreateTestSuiteRequest.Builder, CreateTestSuiteRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateTestSuiteRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateTestSuiteRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Step>> BEFORE_STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("beforeSteps")
            .getter(getter(CreateTestSuiteRequest::beforeSteps))
            .setter(setter(Builder::beforeSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Step>> AFTER_STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("afterSteps")
            .getter(getter(CreateTestSuiteRequest::afterSteps))
            .setter(setter(Builder::afterSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TestCases> TEST_CASES_FIELD = SdkField.<TestCases> builder(MarshallingType.SDK_POJO)
            .memberName("testCases").getter(getter(CreateTestSuiteRequest::testCases)).setter(setter(Builder::testCases))
            .constructor(TestCases::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateTestSuiteRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateTestSuiteRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            BEFORE_STEPS_FIELD, AFTER_STEPS_FIELD, TEST_CASES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final List<Step> beforeSteps;

    private final List<Step> afterSteps;

    private final TestCases testCases;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateTestSuiteRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.beforeSteps = builder.beforeSteps;
        this.afterSteps = builder.afterSteps;
        this.testCases = builder.testCases;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the test suite.
     * </p>
     * 
     * @return The name of the test suite.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the test suite.
     * </p>
     * 
     * @return The description of the test suite.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the BeforeSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBeforeSteps() {
        return beforeSteps != null && !(beforeSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The before steps of the test suite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBeforeSteps} method.
     * </p>
     * 
     * @return The before steps of the test suite.
     */
    public final List<Step> beforeSteps() {
        return beforeSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the AfterSteps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAfterSteps() {
        return afterSteps != null && !(afterSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The after steps of the test suite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAfterSteps} method.
     * </p>
     * 
     * @return The after steps of the test suite.
     */
    public final List<Step> afterSteps() {
        return afterSteps;
    }

    /**
     * <p>
     * The test cases in the test suite.
     * </p>
     * 
     * @return The test cases in the test suite.
     */
    public final TestCases testCases() {
        return testCases;
    }

    /**
     * <p>
     * The client token of the test suite.
     * </p>
     * 
     * @return The client token of the test suite.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the test suite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the test suite.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasBeforeSteps() ? beforeSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAfterSteps() ? afterSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(testCases());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestSuiteRequest)) {
            return false;
        }
        CreateTestSuiteRequest other = (CreateTestSuiteRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasBeforeSteps() == other.hasBeforeSteps() && Objects.equals(beforeSteps(), other.beforeSteps())
                && hasAfterSteps() == other.hasAfterSteps() && Objects.equals(afterSteps(), other.afterSteps())
                && Objects.equals(testCases(), other.testCases()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTestSuiteRequest").add("Name", name()).add("Description", description())
                .add("BeforeSteps", hasBeforeSteps() ? beforeSteps() : null)
                .add("AfterSteps", hasAfterSteps() ? afterSteps() : null).add("TestCases", testCases())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "beforeSteps":
            return Optional.ofNullable(clazz.cast(beforeSteps()));
        case "afterSteps":
            return Optional.ofNullable(clazz.cast(afterSteps()));
        case "testCases":
            return Optional.ofNullable(clazz.cast(testCases()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTestSuiteRequest, T> g) {
        return obj -> g.apply((CreateTestSuiteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTestSuiteRequest> {
        /**
         * <p>
         * The name of the test suite.
         * </p>
         * 
         * @param name
         *        The name of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the test suite.
         * </p>
         * 
         * @param description
         *        The description of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The before steps of the test suite.
         * </p>
         * 
         * @param beforeSteps
         *        The before steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeSteps(Collection<Step> beforeSteps);

        /**
         * <p>
         * The before steps of the test suite.
         * </p>
         * 
         * @param beforeSteps
         *        The before steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeSteps(Step... beforeSteps);

        /**
         * <p>
         * The before steps of the test suite.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apptest.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder#build()} is called immediately and its
         * result is passed to {@link #beforeSteps(List<Step>)}.
         * 
         * @param beforeSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #beforeSteps(java.util.Collection<Step>)
         */
        Builder beforeSteps(Consumer<Step.Builder>... beforeSteps);

        /**
         * <p>
         * The after steps of the test suite.
         * </p>
         * 
         * @param afterSteps
         *        The after steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterSteps(Collection<Step> afterSteps);

        /**
         * <p>
         * The after steps of the test suite.
         * </p>
         * 
         * @param afterSteps
         *        The after steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterSteps(Step... afterSteps);

        /**
         * <p>
         * The after steps of the test suite.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apptest.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder#build()} is called immediately and its
         * result is passed to {@link #afterSteps(List<Step>)}.
         * 
         * @param afterSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #afterSteps(java.util.Collection<Step>)
         */
        Builder afterSteps(Consumer<Step.Builder>... afterSteps);

        /**
         * <p>
         * The test cases in the test suite.
         * </p>
         * 
         * @param testCases
         *        The test cases in the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCases(TestCases testCases);

        /**
         * <p>
         * The test cases in the test suite.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestCases.Builder} avoiding the need to
         * create one manually via {@link TestCases#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestCases.Builder#build()} is called immediately and its result
         * is passed to {@link #testCases(TestCases)}.
         * 
         * @param testCases
         *        a consumer that will call methods on {@link TestCases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testCases(TestCases)
         */
        default Builder testCases(Consumer<TestCases.Builder> testCases) {
            return testCases(TestCases.builder().applyMutation(testCases).build());
        }

        /**
         * <p>
         * The client token of the test suite.
         * </p>
         * 
         * @param clientToken
         *        The client token of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags of the test suite.
         * </p>
         * 
         * @param tags
         *        The tags of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppTestRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Step> beforeSteps = DefaultSdkAutoConstructList.getInstance();

        private List<Step> afterSteps = DefaultSdkAutoConstructList.getInstance();

        private TestCases testCases;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTestSuiteRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            beforeSteps(model.beforeSteps);
            afterSteps(model.afterSteps);
            testCases(model.testCases);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Step.Builder> getBeforeSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.beforeSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBeforeSteps(Collection<Step.BuilderImpl> beforeSteps) {
            this.beforeSteps = StepListCopier.copyFromBuilder(beforeSteps);
        }

        @Override
        public final Builder beforeSteps(Collection<Step> beforeSteps) {
            this.beforeSteps = StepListCopier.copy(beforeSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Step... beforeSteps) {
            beforeSteps(Arrays.asList(beforeSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Consumer<Step.Builder>... beforeSteps) {
            beforeSteps(Stream.of(beforeSteps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Step.Builder> getAfterSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.afterSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAfterSteps(Collection<Step.BuilderImpl> afterSteps) {
            this.afterSteps = StepListCopier.copyFromBuilder(afterSteps);
        }

        @Override
        public final Builder afterSteps(Collection<Step> afterSteps) {
            this.afterSteps = StepListCopier.copy(afterSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Step... afterSteps) {
            afterSteps(Arrays.asList(afterSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Consumer<Step.Builder>... afterSteps) {
            afterSteps(Stream.of(afterSteps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TestCases.Builder getTestCases() {
            return testCases != null ? testCases.toBuilder() : null;
        }

        public final void setTestCases(TestCases.BuilderImpl testCases) {
            this.testCases = testCases != null ? testCases.build() : null;
        }

        @Override
        public final Builder testCases(TestCases testCases) {
            this.testCases = testCases;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTestSuiteRequest build() {
            return new CreateTestSuiteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
