/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestRunTestCasesResponse extends AppTestResponse implements
        ToCopyableBuilder<ListTestRunTestCasesResponse.Builder, ListTestRunTestCasesResponse> {
    private static final SdkField<List<TestCaseRunSummary>> TEST_RUN_TEST_CASES_FIELD = SdkField
            .<List<TestCaseRunSummary>> builder(MarshallingType.LIST)
            .memberName("testRunTestCases")
            .getter(getter(ListTestRunTestCasesResponse::testRunTestCases))
            .setter(setter(Builder::testRunTestCases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunTestCases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestCaseRunSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestCaseRunSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestRunTestCasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RUN_TEST_CASES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TestCaseRunSummary> testRunTestCases;

    private final String nextToken;

    private ListTestRunTestCasesResponse(BuilderImpl builder) {
        super(builder);
        this.testRunTestCases = builder.testRunTestCases;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestRunTestCases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTestRunTestCases() {
        return testRunTestCases != null && !(testRunTestCases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The test run of the test cases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestRunTestCases} method.
     * </p>
     * 
     * @return The test run of the test cases.
     */
    public final List<TestCaseRunSummary> testRunTestCases() {
        return testRunTestCases;
    }

    /**
     * <p>
     * The token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return The token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTestRunTestCases() ? testRunTestCases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestRunTestCasesResponse)) {
            return false;
        }
        ListTestRunTestCasesResponse other = (ListTestRunTestCasesResponse) obj;
        return hasTestRunTestCases() == other.hasTestRunTestCases()
                && Objects.equals(testRunTestCases(), other.testRunTestCases()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestRunTestCasesResponse")
                .add("TestRunTestCases", hasTestRunTestCases() ? testRunTestCases() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testRunTestCases":
            return Optional.ofNullable(clazz.cast(testRunTestCases()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestRunTestCasesResponse, T> g) {
        return obj -> g.apply((ListTestRunTestCasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTestRunTestCasesResponse> {
        /**
         * <p>
         * The test run of the test cases.
         * </p>
         * 
         * @param testRunTestCases
         *        The test run of the test cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunTestCases(Collection<TestCaseRunSummary> testRunTestCases);

        /**
         * <p>
         * The test run of the test cases.
         * </p>
         * 
         * @param testRunTestCases
         *        The test run of the test cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunTestCases(TestCaseRunSummary... testRunTestCases);

        /**
         * <p>
         * The test run of the test cases.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.TestCaseRunSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.apptest.model.TestCaseRunSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.TestCaseRunSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #testRunTestCases(List<TestCaseRunSummary>)}.
         * 
         * @param testRunTestCases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.TestCaseRunSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testRunTestCases(java.util.Collection<TestCaseRunSummary>)
         */
        Builder testRunTestCases(Consumer<TestCaseRunSummary.Builder>... testRunTestCases);

        /**
         * <p>
         * The token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppTestResponse.BuilderImpl implements Builder {
        private List<TestCaseRunSummary> testRunTestCases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestRunTestCasesResponse model) {
            super(model);
            testRunTestCases(model.testRunTestCases);
            nextToken(model.nextToken);
        }

        public final List<TestCaseRunSummary.Builder> getTestRunTestCases() {
            List<TestCaseRunSummary.Builder> result = TestCaseRunSummaryListCopier.copyToBuilder(this.testRunTestCases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestRunTestCases(Collection<TestCaseRunSummary.BuilderImpl> testRunTestCases) {
            this.testRunTestCases = TestCaseRunSummaryListCopier.copyFromBuilder(testRunTestCases);
        }

        @Override
        public final Builder testRunTestCases(Collection<TestCaseRunSummary> testRunTestCases) {
            this.testRunTestCases = TestCaseRunSummaryListCopier.copy(testRunTestCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRunTestCases(TestCaseRunSummary... testRunTestCases) {
            testRunTestCases(Arrays.asList(testRunTestCases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRunTestCases(Consumer<TestCaseRunSummary.Builder>... testRunTestCases) {
            testRunTestCases(Stream.of(testRunTestCases).map(c -> TestCaseRunSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestRunTestCasesResponse build() {
            return new ListTestRunTestCasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
