/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the AWS Mainframe Modernization non-managed application step summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2NonManagedApplicationStepSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<M2NonManagedApplicationStepSummary.Builder, M2NonManagedApplicationStepSummary> {
    private static final SdkField<M2NonManagedApplicationStepInput> STEP_INPUT_FIELD = SdkField
            .<M2NonManagedApplicationStepInput> builder(MarshallingType.SDK_POJO).memberName("stepInput")
            .getter(getter(M2NonManagedApplicationStepSummary::stepInput)).setter(setter(Builder::stepInput))
            .constructor(M2NonManagedApplicationStepInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepInput").build()).build();

    private static final SdkField<M2NonManagedApplicationStepOutput> STEP_OUTPUT_FIELD = SdkField
            .<M2NonManagedApplicationStepOutput> builder(MarshallingType.SDK_POJO).memberName("stepOutput")
            .getter(getter(M2NonManagedApplicationStepSummary::stepOutput)).setter(setter(Builder::stepOutput))
            .constructor(M2NonManagedApplicationStepOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_INPUT_FIELD,
            STEP_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final M2NonManagedApplicationStepInput stepInput;

    private final M2NonManagedApplicationStepOutput stepOutput;

    private M2NonManagedApplicationStepSummary(BuilderImpl builder) {
        this.stepInput = builder.stepInput;
        this.stepOutput = builder.stepOutput;
    }

    /**
     * <p>
     * The step input of the AWS Mainframe Modernization non-managed application step summary.
     * </p>
     * 
     * @return The step input of the AWS Mainframe Modernization non-managed application step summary.
     */
    public final M2NonManagedApplicationStepInput stepInput() {
        return stepInput;
    }

    /**
     * <p>
     * The step output of the AWS Mainframe Modernization non-managed application step summary.
     * </p>
     * 
     * @return The step output of the AWS Mainframe Modernization non-managed application step summary.
     */
    public final M2NonManagedApplicationStepOutput stepOutput() {
        return stepOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepInput());
        hashCode = 31 * hashCode + Objects.hashCode(stepOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2NonManagedApplicationStepSummary)) {
            return false;
        }
        M2NonManagedApplicationStepSummary other = (M2NonManagedApplicationStepSummary) obj;
        return Objects.equals(stepInput(), other.stepInput()) && Objects.equals(stepOutput(), other.stepOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("M2NonManagedApplicationStepSummary").add("StepInput", stepInput())
                .add("StepOutput", stepOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepInput":
            return Optional.ofNullable(clazz.cast(stepInput()));
        case "stepOutput":
            return Optional.ofNullable(clazz.cast(stepOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<M2NonManagedApplicationStepSummary, T> g) {
        return obj -> g.apply((M2NonManagedApplicationStepSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2NonManagedApplicationStepSummary> {
        /**
         * <p>
         * The step input of the AWS Mainframe Modernization non-managed application step summary.
         * </p>
         * 
         * @param stepInput
         *        The step input of the AWS Mainframe Modernization non-managed application step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepInput(M2NonManagedApplicationStepInput stepInput);

        /**
         * <p>
         * The step input of the AWS Mainframe Modernization non-managed application step summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2NonManagedApplicationStepInput.Builder}
         * avoiding the need to create one manually via {@link M2NonManagedApplicationStepInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2NonManagedApplicationStepInput.Builder#build()} is called
         * immediately and its result is passed to {@link #stepInput(M2NonManagedApplicationStepInput)}.
         * 
         * @param stepInput
         *        a consumer that will call methods on {@link M2NonManagedApplicationStepInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepInput(M2NonManagedApplicationStepInput)
         */
        default Builder stepInput(Consumer<M2NonManagedApplicationStepInput.Builder> stepInput) {
            return stepInput(M2NonManagedApplicationStepInput.builder().applyMutation(stepInput).build());
        }

        /**
         * <p>
         * The step output of the AWS Mainframe Modernization non-managed application step summary.
         * </p>
         * 
         * @param stepOutput
         *        The step output of the AWS Mainframe Modernization non-managed application step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepOutput(M2NonManagedApplicationStepOutput stepOutput);

        /**
         * <p>
         * The step output of the AWS Mainframe Modernization non-managed application step summary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link M2NonManagedApplicationStepOutput.Builder} avoiding the need to create one manually via
         * {@link M2NonManagedApplicationStepOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2NonManagedApplicationStepOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #stepOutput(M2NonManagedApplicationStepOutput)}.
         * 
         * @param stepOutput
         *        a consumer that will call methods on {@link M2NonManagedApplicationStepOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepOutput(M2NonManagedApplicationStepOutput)
         */
        default Builder stepOutput(Consumer<M2NonManagedApplicationStepOutput.Builder> stepOutput) {
            return stepOutput(M2NonManagedApplicationStepOutput.builder().applyMutation(stepOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private M2NonManagedApplicationStepInput stepInput;

        private M2NonManagedApplicationStepOutput stepOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(M2NonManagedApplicationStepSummary model) {
            stepInput(model.stepInput);
            stepOutput(model.stepOutput);
        }

        public final M2NonManagedApplicationStepInput.Builder getStepInput() {
            return stepInput != null ? stepInput.toBuilder() : null;
        }

        public final void setStepInput(M2NonManagedApplicationStepInput.BuilderImpl stepInput) {
            this.stepInput = stepInput != null ? stepInput.build() : null;
        }

        @Override
        public final Builder stepInput(M2NonManagedApplicationStepInput stepInput) {
            this.stepInput = stepInput;
            return this;
        }

        public final M2NonManagedApplicationStepOutput.Builder getStepOutput() {
            return stepOutput != null ? stepOutput.toBuilder() : null;
        }

        public final void setStepOutput(M2NonManagedApplicationStepOutput.BuilderImpl stepOutput) {
            this.stepOutput = stepOutput != null ? stepOutput.build() : null;
        }

        @Override
        public final Builder stepOutput(M2NonManagedApplicationStepOutput stepOutput) {
            this.stepOutput = stepOutput;
            return this;
        }

        @Override
        public M2NonManagedApplicationStepSummary build() {
            return new M2NonManagedApplicationStepSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
