/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a TN3270 summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TN3270Summary implements SdkPojo, Serializable, ToCopyableBuilder<TN3270Summary.Builder, TN3270Summary> {
    private static final SdkField<TN3270StepInput> STEP_INPUT_FIELD = SdkField
            .<TN3270StepInput> builder(MarshallingType.SDK_POJO).memberName("stepInput").getter(getter(TN3270Summary::stepInput))
            .setter(setter(Builder::stepInput)).constructor(TN3270StepInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepInput").build()).build();

    private static final SdkField<TN3270StepOutput> STEP_OUTPUT_FIELD = SdkField
            .<TN3270StepOutput> builder(MarshallingType.SDK_POJO).memberName("stepOutput")
            .getter(getter(TN3270Summary::stepOutput)).setter(setter(Builder::stepOutput)).constructor(TN3270StepOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_INPUT_FIELD,
            STEP_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final TN3270StepInput stepInput;

    private final TN3270StepOutput stepOutput;

    private TN3270Summary(BuilderImpl builder) {
        this.stepInput = builder.stepInput;
        this.stepOutput = builder.stepOutput;
    }

    /**
     * <p>
     * The step input of the TN3270 summary.
     * </p>
     * 
     * @return The step input of the TN3270 summary.
     */
    public final TN3270StepInput stepInput() {
        return stepInput;
    }

    /**
     * <p>
     * The step output of the TN3270 summary.
     * </p>
     * 
     * @return The step output of the TN3270 summary.
     */
    public final TN3270StepOutput stepOutput() {
        return stepOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepInput());
        hashCode = 31 * hashCode + Objects.hashCode(stepOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TN3270Summary)) {
            return false;
        }
        TN3270Summary other = (TN3270Summary) obj;
        return Objects.equals(stepInput(), other.stepInput()) && Objects.equals(stepOutput(), other.stepOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TN3270Summary").add("StepInput", stepInput()).add("StepOutput", stepOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepInput":
            return Optional.ofNullable(clazz.cast(stepInput()));
        case "stepOutput":
            return Optional.ofNullable(clazz.cast(stepOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TN3270Summary, T> g) {
        return obj -> g.apply((TN3270Summary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TN3270Summary> {
        /**
         * <p>
         * The step input of the TN3270 summary.
         * </p>
         * 
         * @param stepInput
         *        The step input of the TN3270 summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepInput(TN3270StepInput stepInput);

        /**
         * <p>
         * The step input of the TN3270 summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link TN3270StepInput.Builder} avoiding the
         * need to create one manually via {@link TN3270StepInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TN3270StepInput.Builder#build()} is called immediately and its
         * result is passed to {@link #stepInput(TN3270StepInput)}.
         * 
         * @param stepInput
         *        a consumer that will call methods on {@link TN3270StepInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepInput(TN3270StepInput)
         */
        default Builder stepInput(Consumer<TN3270StepInput.Builder> stepInput) {
            return stepInput(TN3270StepInput.builder().applyMutation(stepInput).build());
        }

        /**
         * <p>
         * The step output of the TN3270 summary.
         * </p>
         * 
         * @param stepOutput
         *        The step output of the TN3270 summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepOutput(TN3270StepOutput stepOutput);

        /**
         * <p>
         * The step output of the TN3270 summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link TN3270StepOutput.Builder} avoiding the
         * need to create one manually via {@link TN3270StepOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TN3270StepOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #stepOutput(TN3270StepOutput)}.
         * 
         * @param stepOutput
         *        a consumer that will call methods on {@link TN3270StepOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepOutput(TN3270StepOutput)
         */
        default Builder stepOutput(Consumer<TN3270StepOutput.Builder> stepOutput) {
            return stepOutput(TN3270StepOutput.builder().applyMutation(stepOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TN3270StepInput stepInput;

        private TN3270StepOutput stepOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(TN3270Summary model) {
            stepInput(model.stepInput);
            stepOutput(model.stepOutput);
        }

        public final TN3270StepInput.Builder getStepInput() {
            return stepInput != null ? stepInput.toBuilder() : null;
        }

        public final void setStepInput(TN3270StepInput.BuilderImpl stepInput) {
            this.stepInput = stepInput != null ? stepInput.build() : null;
        }

        @Override
        public final Builder stepInput(TN3270StepInput stepInput) {
            this.stepInput = stepInput;
            return this;
        }

        public final TN3270StepOutput.Builder getStepOutput() {
            return stepOutput != null ? stepOutput.toBuilder() : null;
        }

        public final void setStepOutput(TN3270StepOutput.BuilderImpl stepOutput) {
            this.stepOutput = stepOutput != null ? stepOutput.build() : null;
        }

        @Override
        public final Builder stepOutput(TN3270StepOutput stepOutput) {
            this.stepOutput = stepOutput;
            return this;
        }

        @Override
        public TN3270Summary build() {
            return new TN3270Summary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
