/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the test suite summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestSuiteSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TestSuiteSummary.Builder, TestSuiteSummary> {
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteId").getter(getter(TestSuiteSummary::testSuiteId)).setter(setter(Builder::testSuiteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TestSuiteSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(TestSuiteSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Integer> LATEST_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("latestVersion").getter(getter(TestSuiteSummary::latestVersion)).setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final SdkField<String> TEST_SUITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteArn").getter(getter(TestSuiteSummary::testSuiteArn)).setter(setter(Builder::testSuiteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestSuiteSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(TestSuiteSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(TestSuiteSummary::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITE_ID_FIELD,
            NAME_FIELD, STATUS_REASON_FIELD, LATEST_VERSION_FIELD, TEST_SUITE_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String testSuiteId;

    private final String name;

    private final String statusReason;

    private final Integer latestVersion;

    private final String testSuiteArn;

    private final String status;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private TestSuiteSummary(BuilderImpl builder) {
        this.testSuiteId = builder.testSuiteId;
        this.name = builder.name;
        this.statusReason = builder.statusReason;
        this.latestVersion = builder.latestVersion;
        this.testSuiteArn = builder.testSuiteArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The test suite ID of the test suite summary.
     * </p>
     * 
     * @return The test suite ID of the test suite summary.
     */
    public final String testSuiteId() {
        return testSuiteId;
    }

    /**
     * <p>
     * The name of the test suite summary.
     * </p>
     * 
     * @return The name of the test suite summary.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status reason of the test suite summary.
     * </p>
     * 
     * @return The status reason of the test suite summary.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The latest version of the test suite summary.
     * </p>
     * 
     * @return The latest version of the test suite summary.
     */
    public final Integer latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The test suite Amazon Resource Name (ARN) of the test suite summary.
     * </p>
     * 
     * @return The test suite Amazon Resource Name (ARN) of the test suite summary.
     */
    public final String testSuiteArn() {
        return testSuiteArn;
    }

    /**
     * <p>
     * The status of the test suite summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestSuiteLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test suite summary.
     * @see TestSuiteLifecycle
     */
    public final TestSuiteLifecycle status() {
        return TestSuiteLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the test suite summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestSuiteLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test suite summary.
     * @see TestSuiteLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time of the test suite summary.
     * </p>
     * 
     * @return The creation time of the test suite summary.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last update time of the test suite summary.
     * </p>
     * 
     * @return The last update time of the test suite summary.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSuiteSummary)) {
            return false;
        }
        TestSuiteSummary other = (TestSuiteSummary) obj;
        return Objects.equals(testSuiteId(), other.testSuiteId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(testSuiteArn(), other.testSuiteArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestSuiteSummary").add("TestSuiteId", testSuiteId()).add("Name", name())
                .add("StatusReason", statusReason()).add("LatestVersion", latestVersion()).add("TestSuiteArn", testSuiteArn())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSuiteId":
            return Optional.ofNullable(clazz.cast(testSuiteId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "testSuiteArn":
            return Optional.ofNullable(clazz.cast(testSuiteArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestSuiteSummary, T> g) {
        return obj -> g.apply((TestSuiteSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestSuiteSummary> {
        /**
         * <p>
         * The test suite ID of the test suite summary.
         * </p>
         * 
         * @param testSuiteId
         *        The test suite ID of the test suite summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteId(String testSuiteId);

        /**
         * <p>
         * The name of the test suite summary.
         * </p>
         * 
         * @param name
         *        The name of the test suite summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status reason of the test suite summary.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the test suite summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The latest version of the test suite summary.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the test suite summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(Integer latestVersion);

        /**
         * <p>
         * The test suite Amazon Resource Name (ARN) of the test suite summary.
         * </p>
         * 
         * @param testSuiteArn
         *        The test suite Amazon Resource Name (ARN) of the test suite summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteArn(String testSuiteArn);

        /**
         * <p>
         * The status of the test suite summary.
         * </p>
         * 
         * @param status
         *        The status of the test suite summary.
         * @see TestSuiteLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSuiteLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test suite summary.
         * </p>
         * 
         * @param status
         *        The status of the test suite summary.
         * @see TestSuiteLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSuiteLifecycle
         */
        Builder status(TestSuiteLifecycle status);

        /**
         * <p>
         * The creation time of the test suite summary.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the test suite summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last update time of the test suite summary.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last update time of the test suite summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String testSuiteId;

        private String name;

        private String statusReason;

        private Integer latestVersion;

        private String testSuiteArn;

        private String status;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestSuiteSummary model) {
            testSuiteId(model.testSuiteId);
            name(model.name);
            statusReason(model.statusReason);
            latestVersion(model.latestVersion);
            testSuiteArn(model.testSuiteArn);
            status(model.status);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getTestSuiteId() {
            return testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Integer getLatestVersion() {
            return latestVersion;
        }

        public final void setLatestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final String getTestSuiteArn() {
            return testSuiteArn;
        }

        public final void setTestSuiteArn(String testSuiteArn) {
            this.testSuiteArn = testSuiteArn;
        }

        @Override
        public final Builder testSuiteArn(String testSuiteArn) {
            this.testSuiteArn = testSuiteArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestSuiteLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public TestSuiteSummary build() {
            return new TestSuiteSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
