/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the AWS Mainframe Modernization managed application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2ManagedApplication implements SdkPojo, Serializable,
        ToCopyableBuilder<M2ManagedApplication.Builder, M2ManagedApplication> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(M2ManagedApplication::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runtime")
            .getter(getter(M2ManagedApplication::runtimeAsString)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointServiceName").getter(getter(M2ManagedApplication::vpcEndpointServiceName))
            .setter(setter(Builder::vpcEndpointServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointServiceName").build())
            .build();

    private static final SdkField<String> LISTENER_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listenerPort").getter(getter(M2ManagedApplication::listenerPort)).setter(setter(Builder::listenerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            RUNTIME_FIELD, VPC_ENDPOINT_SERVICE_NAME_FIELD, LISTENER_PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String runtime;

    private final String vpcEndpointServiceName;

    private final String listenerPort;

    private M2ManagedApplication(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.runtime = builder.runtime;
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.listenerPort = builder.listenerPort;
    }

    /**
     * <p>
     * The application ID of the AWS Mainframe Modernization managed application.
     * </p>
     * 
     * @return The application ID of the AWS Mainframe Modernization managed application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The runtime of the AWS Mainframe Modernization managed application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link M2ManagedRuntime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The runtime of the AWS Mainframe Modernization managed application.
     * @see M2ManagedRuntime
     */
    public final M2ManagedRuntime runtime() {
        return M2ManagedRuntime.fromValue(runtime);
    }

    /**
     * <p>
     * The runtime of the AWS Mainframe Modernization managed application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link M2ManagedRuntime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The runtime of the AWS Mainframe Modernization managed application.
     * @see M2ManagedRuntime
     */
    public final String runtimeAsString() {
        return runtime;
    }

    /**
     * <p>
     * The VPC endpoint service name of the AWS Mainframe Modernization managed application.
     * </p>
     * 
     * @return The VPC endpoint service name of the AWS Mainframe Modernization managed application.
     */
    public final String vpcEndpointServiceName() {
        return vpcEndpointServiceName;
    }

    /**
     * <p>
     * The listener port of the AWS Mainframe Modernization managed application.
     * </p>
     * 
     * @return The listener port of the AWS Mainframe Modernization managed application.
     */
    public final String listenerPort() {
        return listenerPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(listenerPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedApplication)) {
            return false;
        }
        M2ManagedApplication other = (M2ManagedApplication) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(runtimeAsString(), other.runtimeAsString())
                && Objects.equals(vpcEndpointServiceName(), other.vpcEndpointServiceName())
                && Objects.equals(listenerPort(), other.listenerPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("M2ManagedApplication").add("ApplicationId", applicationId()).add("Runtime", runtimeAsString())
                .add("VpcEndpointServiceName", vpcEndpointServiceName()).add("ListenerPort", listenerPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtimeAsString()));
        case "vpcEndpointServiceName":
            return Optional.ofNullable(clazz.cast(vpcEndpointServiceName()));
        case "listenerPort":
            return Optional.ofNullable(clazz.cast(listenerPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedApplication, T> g) {
        return obj -> g.apply((M2ManagedApplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2ManagedApplication> {
        /**
         * <p>
         * The application ID of the AWS Mainframe Modernization managed application.
         * </p>
         * 
         * @param applicationId
         *        The application ID of the AWS Mainframe Modernization managed application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The runtime of the AWS Mainframe Modernization managed application.
         * </p>
         * 
         * @param runtime
         *        The runtime of the AWS Mainframe Modernization managed application.
         * @see M2ManagedRuntime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2ManagedRuntime
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The runtime of the AWS Mainframe Modernization managed application.
         * </p>
         * 
         * @param runtime
         *        The runtime of the AWS Mainframe Modernization managed application.
         * @see M2ManagedRuntime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2ManagedRuntime
         */
        Builder runtime(M2ManagedRuntime runtime);

        /**
         * <p>
         * The VPC endpoint service name of the AWS Mainframe Modernization managed application.
         * </p>
         * 
         * @param vpcEndpointServiceName
         *        The VPC endpoint service name of the AWS Mainframe Modernization managed application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointServiceName(String vpcEndpointServiceName);

        /**
         * <p>
         * The listener port of the AWS Mainframe Modernization managed application.
         * </p>
         * 
         * @param listenerPort
         *        The listener port of the AWS Mainframe Modernization managed application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPort(String listenerPort);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String runtime;

        private String vpcEndpointServiceName;

        private String listenerPort;

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedApplication model) {
            applicationId(model.applicationId);
            runtime(model.runtime);
            vpcEndpointServiceName(model.vpcEndpointServiceName);
            listenerPort(model.listenerPort);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(M2ManagedRuntime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getVpcEndpointServiceName() {
            return vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final String getListenerPort() {
            return listenerPort;
        }

        public final void setListenerPort(String listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(String listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        @Override
        public M2ManagedApplication build() {
            return new M2ManagedApplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
