/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTestConfigurationResponse extends AppTestResponse implements
        ToCopyableBuilder<UpdateTestConfigurationResponse.Builder, UpdateTestConfigurationResponse> {
    private static final SdkField<String> TEST_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testConfigurationId").getter(getter(UpdateTestConfigurationResponse::testConfigurationId))
            .setter(setter(Builder::testConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationId").build())
            .build();

    private static final SdkField<Integer> TEST_CONFIGURATION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testConfigurationVersion").getter(getter(UpdateTestConfigurationResponse::testConfigurationVersion))
            .setter(setter(Builder::testConfigurationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CONFIGURATION_ID_FIELD,
            TEST_CONFIGURATION_VERSION_FIELD));

    private final String testConfigurationId;

    private final Integer testConfigurationVersion;

    private UpdateTestConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.testConfigurationId = builder.testConfigurationId;
        this.testConfigurationVersion = builder.testConfigurationVersion;
    }

    /**
     * <p>
     * The configuration ID of the test configuration.
     * </p>
     * 
     * @return The configuration ID of the test configuration.
     */
    public final String testConfigurationId() {
        return testConfigurationId;
    }

    /**
     * <p>
     * The configuration version of the test configuration.
     * </p>
     * 
     * @return The configuration version of the test configuration.
     */
    public final Integer testConfigurationVersion() {
        return testConfigurationVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(testConfigurationVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestConfigurationResponse)) {
            return false;
        }
        UpdateTestConfigurationResponse other = (UpdateTestConfigurationResponse) obj;
        return Objects.equals(testConfigurationId(), other.testConfigurationId())
                && Objects.equals(testConfigurationVersion(), other.testConfigurationVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTestConfigurationResponse").add("TestConfigurationId", testConfigurationId())
                .add("TestConfigurationVersion", testConfigurationVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testConfigurationId":
            return Optional.ofNullable(clazz.cast(testConfigurationId()));
        case "testConfigurationVersion":
            return Optional.ofNullable(clazz.cast(testConfigurationVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTestConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateTestConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTestConfigurationResponse> {
        /**
         * <p>
         * The configuration ID of the test configuration.
         * </p>
         * 
         * @param testConfigurationId
         *        The configuration ID of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigurationId(String testConfigurationId);

        /**
         * <p>
         * The configuration version of the test configuration.
         * </p>
         * 
         * @param testConfigurationVersion
         *        The configuration version of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigurationVersion(Integer testConfigurationVersion);
    }

    static final class BuilderImpl extends AppTestResponse.BuilderImpl implements Builder {
        private String testConfigurationId;

        private Integer testConfigurationVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTestConfigurationResponse model) {
            super(model);
            testConfigurationId(model.testConfigurationId);
            testConfigurationVersion(model.testConfigurationVersion);
        }

        public final String getTestConfigurationId() {
            return testConfigurationId;
        }

        public final void setTestConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
        }

        @Override
        public final Builder testConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
            return this;
        }

        public final Integer getTestConfigurationVersion() {
            return testConfigurationVersion;
        }

        public final void setTestConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
        }

        @Override
        public final Builder testConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
            return this;
        }

        @Override
        public UpdateTestConfigurationResponse build() {
            return new UpdateTestConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
