/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTestSuiteRequest extends AppTestRequest implements
        ToCopyableBuilder<UpdateTestSuiteRequest.Builder, UpdateTestSuiteRequest> {
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteId").getter(getter(UpdateTestSuiteRequest::testSuiteId)).setter(setter(Builder::testSuiteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testSuiteId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateTestSuiteRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Step>> BEFORE_STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("beforeSteps")
            .getter(getter(UpdateTestSuiteRequest::beforeSteps))
            .setter(setter(Builder::beforeSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Step>> AFTER_STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("afterSteps")
            .getter(getter(UpdateTestSuiteRequest::afterSteps))
            .setter(setter(Builder::afterSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TestCases> TEST_CASES_FIELD = SdkField.<TestCases> builder(MarshallingType.SDK_POJO)
            .memberName("testCases").getter(getter(UpdateTestSuiteRequest::testCases)).setter(setter(Builder::testCases))
            .constructor(TestCases::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITE_ID_FIELD,
            DESCRIPTION_FIELD, BEFORE_STEPS_FIELD, AFTER_STEPS_FIELD, TEST_CASES_FIELD));

    private final String testSuiteId;

    private final String description;

    private final List<Step> beforeSteps;

    private final List<Step> afterSteps;

    private final TestCases testCases;

    private UpdateTestSuiteRequest(BuilderImpl builder) {
        super(builder);
        this.testSuiteId = builder.testSuiteId;
        this.description = builder.description;
        this.beforeSteps = builder.beforeSteps;
        this.afterSteps = builder.afterSteps;
        this.testCases = builder.testCases;
    }

    /**
     * <p>
     * The test suite ID of the test suite.
     * </p>
     * 
     * @return The test suite ID of the test suite.
     */
    public final String testSuiteId() {
        return testSuiteId;
    }

    /**
     * <p>
     * The description of the test suite.
     * </p>
     * 
     * @return The description of the test suite.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the BeforeSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBeforeSteps() {
        return beforeSteps != null && !(beforeSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The before steps for the test suite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBeforeSteps} method.
     * </p>
     * 
     * @return The before steps for the test suite.
     */
    public final List<Step> beforeSteps() {
        return beforeSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the AfterSteps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAfterSteps() {
        return afterSteps != null && !(afterSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The after steps of the test suite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAfterSteps} method.
     * </p>
     * 
     * @return The after steps of the test suite.
     */
    public final List<Step> afterSteps() {
        return afterSteps;
    }

    /**
     * <p>
     * The test cases in the test suite.
     * </p>
     * 
     * @return The test cases in the test suite.
     */
    public final TestCases testCases() {
        return testCases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasBeforeSteps() ? beforeSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAfterSteps() ? afterSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(testCases());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestSuiteRequest)) {
            return false;
        }
        UpdateTestSuiteRequest other = (UpdateTestSuiteRequest) obj;
        return Objects.equals(testSuiteId(), other.testSuiteId()) && Objects.equals(description(), other.description())
                && hasBeforeSteps() == other.hasBeforeSteps() && Objects.equals(beforeSteps(), other.beforeSteps())
                && hasAfterSteps() == other.hasAfterSteps() && Objects.equals(afterSteps(), other.afterSteps())
                && Objects.equals(testCases(), other.testCases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTestSuiteRequest").add("TestSuiteId", testSuiteId()).add("Description", description())
                .add("BeforeSteps", hasBeforeSteps() ? beforeSteps() : null)
                .add("AfterSteps", hasAfterSteps() ? afterSteps() : null).add("TestCases", testCases()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSuiteId":
            return Optional.ofNullable(clazz.cast(testSuiteId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "beforeSteps":
            return Optional.ofNullable(clazz.cast(beforeSteps()));
        case "afterSteps":
            return Optional.ofNullable(clazz.cast(afterSteps()));
        case "testCases":
            return Optional.ofNullable(clazz.cast(testCases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTestSuiteRequest, T> g) {
        return obj -> g.apply((UpdateTestSuiteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTestSuiteRequest> {
        /**
         * <p>
         * The test suite ID of the test suite.
         * </p>
         * 
         * @param testSuiteId
         *        The test suite ID of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteId(String testSuiteId);

        /**
         * <p>
         * The description of the test suite.
         * </p>
         * 
         * @param description
         *        The description of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The before steps for the test suite.
         * </p>
         * 
         * @param beforeSteps
         *        The before steps for the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeSteps(Collection<Step> beforeSteps);

        /**
         * <p>
         * The before steps for the test suite.
         * </p>
         * 
         * @param beforeSteps
         *        The before steps for the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeSteps(Step... beforeSteps);

        /**
         * <p>
         * The before steps for the test suite.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apptest.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder#build()} is called immediately and its
         * result is passed to {@link #beforeSteps(List<Step>)}.
         * 
         * @param beforeSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #beforeSteps(java.util.Collection<Step>)
         */
        Builder beforeSteps(Consumer<Step.Builder>... beforeSteps);

        /**
         * <p>
         * The after steps of the test suite.
         * </p>
         * 
         * @param afterSteps
         *        The after steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterSteps(Collection<Step> afterSteps);

        /**
         * <p>
         * The after steps of the test suite.
         * </p>
         * 
         * @param afterSteps
         *        The after steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterSteps(Step... afterSteps);

        /**
         * <p>
         * The after steps of the test suite.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apptest.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder#build()} is called immediately and its
         * result is passed to {@link #afterSteps(List<Step>)}.
         * 
         * @param afterSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #afterSteps(java.util.Collection<Step>)
         */
        Builder afterSteps(Consumer<Step.Builder>... afterSteps);

        /**
         * <p>
         * The test cases in the test suite.
         * </p>
         * 
         * @param testCases
         *        The test cases in the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCases(TestCases testCases);

        /**
         * <p>
         * The test cases in the test suite.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestCases.Builder} avoiding the need to
         * create one manually via {@link TestCases#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestCases.Builder#build()} is called immediately and its result
         * is passed to {@link #testCases(TestCases)}.
         * 
         * @param testCases
         *        a consumer that will call methods on {@link TestCases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testCases(TestCases)
         */
        default Builder testCases(Consumer<TestCases.Builder> testCases) {
            return testCases(TestCases.builder().applyMutation(testCases).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppTestRequest.BuilderImpl implements Builder {
        private String testSuiteId;

        private String description;

        private List<Step> beforeSteps = DefaultSdkAutoConstructList.getInstance();

        private List<Step> afterSteps = DefaultSdkAutoConstructList.getInstance();

        private TestCases testCases;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTestSuiteRequest model) {
            super(model);
            testSuiteId(model.testSuiteId);
            description(model.description);
            beforeSteps(model.beforeSteps);
            afterSteps(model.afterSteps);
            testCases(model.testCases);
        }

        public final String getTestSuiteId() {
            return testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Step.Builder> getBeforeSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.beforeSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBeforeSteps(Collection<Step.BuilderImpl> beforeSteps) {
            this.beforeSteps = StepListCopier.copyFromBuilder(beforeSteps);
        }

        @Override
        public final Builder beforeSteps(Collection<Step> beforeSteps) {
            this.beforeSteps = StepListCopier.copy(beforeSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Step... beforeSteps) {
            beforeSteps(Arrays.asList(beforeSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Consumer<Step.Builder>... beforeSteps) {
            beforeSteps(Stream.of(beforeSteps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Step.Builder> getAfterSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.afterSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAfterSteps(Collection<Step.BuilderImpl> afterSteps) {
            this.afterSteps = StepListCopier.copyFromBuilder(afterSteps);
        }

        @Override
        public final Builder afterSteps(Collection<Step> afterSteps) {
            this.afterSteps = StepListCopier.copy(afterSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Step... afterSteps) {
            afterSteps(Arrays.asList(afterSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Consumer<Step.Builder>... afterSteps) {
            afterSteps(Stream.of(afterSteps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TestCases.Builder getTestCases() {
            return testCases != null ? testCases.toBuilder() : null;
        }

        public final void setTestCases(TestCases.BuilderImpl testCases) {
            this.testCases = testCases != null ? testCases.build() : null;
        }

        @Override
        public final Builder testCases(TestCases testCases) {
            this.testCases = testCases;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTestSuiteRequest build() {
            return new UpdateTestSuiteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
