/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the compare action summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareActionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CompareActionSummary.Builder, CompareActionSummary> {
    private static final SdkField<File> TYPE_FIELD = SdkField.<File> builder(MarshallingType.SDK_POJO).memberName("type")
            .getter(getter(CompareActionSummary::type)).setter(setter(Builder::type)).constructor(File::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final File type;

    private CompareActionSummary(BuilderImpl builder) {
        this.type = builder.type;
    }

    /**
     * <p>
     * The type of the compare action summary.
     * </p>
     * 
     * @return The type of the compare action summary.
     */
    public final File type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareActionSummary)) {
            return false;
        }
        CompareActionSummary other = (CompareActionSummary) obj;
        return Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareActionSummary").add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompareActionSummary, T> g) {
        return obj -> g.apply((CompareActionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompareActionSummary> {
        /**
         * <p>
         * The type of the compare action summary.
         * </p>
         * 
         * @param type
         *        The type of the compare action summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(File type);

        /**
         * <p>
         * The type of the compare action summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link File.Builder} avoiding the need to create
         * one manually via {@link File#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link File.Builder#build()} is called immediately and its result is
         * passed to {@link #type(File)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link File.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(File)
         */
        default Builder type(Consumer<File.Builder> type) {
            return type(File.builder().applyMutation(type).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private File type;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareActionSummary model) {
            type(model.type);
        }

        public final File.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(File.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(File type) {
            this.type = type;
            return this;
        }

        @Override
        public CompareActionSummary build() {
            return new CompareActionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
