/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compares the file type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareFileType implements SdkPojo, Serializable, ToCopyableBuilder<CompareFileType.Builder, CompareFileType> {
    private static final SdkField<CompareDataSetsSummary> DATASETS_FIELD = SdkField
            .<CompareDataSetsSummary> builder(MarshallingType.SDK_POJO).memberName("datasets")
            .getter(getter(CompareFileType::datasets)).setter(setter(Builder::datasets))
            .constructor(CompareDataSetsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasets").build()).build();

    private static final SdkField<CompareDatabaseCDCSummary> DATABASE_CDC_FIELD = SdkField
            .<CompareDatabaseCDCSummary> builder(MarshallingType.SDK_POJO).memberName("databaseCDC")
            .getter(getter(CompareFileType::databaseCDC)).setter(setter(Builder::databaseCDC))
            .constructor(CompareDatabaseCDCSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseCDC").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASETS_FIELD,
            DATABASE_CDC_FIELD));

    private static final long serialVersionUID = 1L;

    private final CompareDataSetsSummary datasets;

    private final CompareDatabaseCDCSummary databaseCDC;

    private final Type type;

    private CompareFileType(BuilderImpl builder) {
        this.datasets = builder.datasets;
        this.databaseCDC = builder.databaseCDC;
        this.type = builder.type;
    }

    /**
     * <p>
     * The data sets in the compare file type.
     * </p>
     * 
     * @return The data sets in the compare file type.
     */
    public final CompareDataSetsSummary datasets() {
        return datasets;
    }

    /**
     * <p>
     * The database CDC of the compare file type.
     * </p>
     * 
     * @return The database CDC of the compare file type.
     */
    public final CompareDatabaseCDCSummary databaseCDC() {
        return databaseCDC;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasets());
        hashCode = 31 * hashCode + Objects.hashCode(databaseCDC());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFileType)) {
            return false;
        }
        CompareFileType other = (CompareFileType) obj;
        return Objects.equals(datasets(), other.datasets()) && Objects.equals(databaseCDC(), other.databaseCDC());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareFileType").add("Datasets", datasets()).add("DatabaseCDC", databaseCDC()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasets":
            return Optional.ofNullable(clazz.cast(datasets()));
        case "databaseCDC":
            return Optional.ofNullable(clazz.cast(databaseCDC()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #datasets()} initialized to the given value.
     *
     * <p>
     * The data sets in the compare file type.
     * </p>
     * 
     * @param datasets
     *        The data sets in the compare file type.
     */
    public static CompareFileType fromDatasets(CompareDataSetsSummary datasets) {
        return builder().datasets(datasets).build();
    }

    /**
     * Create an instance of this class with {@link #datasets()} initialized to the given value.
     *
     * <p>
     * The data sets in the compare file type.
     * </p>
     * 
     * @param datasets
     *        The data sets in the compare file type.
     */
    public static CompareFileType fromDatasets(Consumer<CompareDataSetsSummary.Builder> datasets) {
        CompareDataSetsSummary.Builder builder = CompareDataSetsSummary.builder();
        datasets.accept(builder);
        return fromDatasets(builder.build());
    }

    /**
     * Create an instance of this class with {@link #databaseCDC()} initialized to the given value.
     *
     * <p>
     * The database CDC of the compare file type.
     * </p>
     * 
     * @param databaseCDC
     *        The database CDC of the compare file type.
     */
    public static CompareFileType fromDatabaseCDC(CompareDatabaseCDCSummary databaseCDC) {
        return builder().databaseCDC(databaseCDC).build();
    }

    /**
     * Create an instance of this class with {@link #databaseCDC()} initialized to the given value.
     *
     * <p>
     * The database CDC of the compare file type.
     * </p>
     * 
     * @param databaseCDC
     *        The database CDC of the compare file type.
     */
    public static CompareFileType fromDatabaseCDC(Consumer<CompareDatabaseCDCSummary.Builder> databaseCDC) {
        CompareDatabaseCDCSummary.Builder builder = CompareDatabaseCDCSummary.builder();
        databaseCDC.accept(builder);
        return fromDatabaseCDC(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompareFileType, T> g) {
        return obj -> g.apply((CompareFileType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompareFileType> {
        /**
         * <p>
         * The data sets in the compare file type.
         * </p>
         * 
         * @param datasets
         *        The data sets in the compare file type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasets(CompareDataSetsSummary datasets);

        /**
         * <p>
         * The data sets in the compare file type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompareDataSetsSummary.Builder} avoiding
         * the need to create one manually via {@link CompareDataSetsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompareDataSetsSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #datasets(CompareDataSetsSummary)}.
         * 
         * @param datasets
         *        a consumer that will call methods on {@link CompareDataSetsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasets(CompareDataSetsSummary)
         */
        default Builder datasets(Consumer<CompareDataSetsSummary.Builder> datasets) {
            return datasets(CompareDataSetsSummary.builder().applyMutation(datasets).build());
        }

        /**
         * <p>
         * The database CDC of the compare file type.
         * </p>
         * 
         * @param databaseCDC
         *        The database CDC of the compare file type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseCDC(CompareDatabaseCDCSummary databaseCDC);

        /**
         * <p>
         * The database CDC of the compare file type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompareDatabaseCDCSummary.Builder}
         * avoiding the need to create one manually via {@link CompareDatabaseCDCSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompareDatabaseCDCSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #databaseCDC(CompareDatabaseCDCSummary)}.
         * 
         * @param databaseCDC
         *        a consumer that will call methods on {@link CompareDatabaseCDCSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseCDC(CompareDatabaseCDCSummary)
         */
        default Builder databaseCDC(Consumer<CompareDatabaseCDCSummary.Builder> databaseCDC) {
            return databaseCDC(CompareDatabaseCDCSummary.builder().applyMutation(databaseCDC).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CompareDataSetsSummary datasets;

        private CompareDatabaseCDCSummary databaseCDC;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFileType model) {
            datasets(model.datasets);
            databaseCDC(model.databaseCDC);
        }

        public final CompareDataSetsSummary.Builder getDatasets() {
            return datasets != null ? datasets.toBuilder() : null;
        }

        public final void setDatasets(CompareDataSetsSummary.BuilderImpl datasets) {
            Object oldValue = this.datasets;
            this.datasets = datasets != null ? datasets.build() : null;
            handleUnionValueChange(Type.DATASETS, oldValue, this.datasets);
        }

        @Override
        public final Builder datasets(CompareDataSetsSummary datasets) {
            Object oldValue = this.datasets;
            this.datasets = datasets;
            handleUnionValueChange(Type.DATASETS, oldValue, this.datasets);
            return this;
        }

        public final CompareDatabaseCDCSummary.Builder getDatabaseCDC() {
            return databaseCDC != null ? databaseCDC.toBuilder() : null;
        }

        public final void setDatabaseCDC(CompareDatabaseCDCSummary.BuilderImpl databaseCDC) {
            Object oldValue = this.databaseCDC;
            this.databaseCDC = databaseCDC != null ? databaseCDC.build() : null;
            handleUnionValueChange(Type.DATABASE_CDC, oldValue, this.databaseCDC);
        }

        @Override
        public final Builder databaseCDC(CompareDatabaseCDCSummary databaseCDC) {
            Object oldValue = this.databaseCDC;
            this.databaseCDC = databaseCDC;
            handleUnionValueChange(Type.DATABASE_CDC, oldValue, this.databaseCDC);
            return this;
        }

        @Override
        public CompareFileType build() {
            return new CompareFileType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CompareFileType#type()
     */
    public enum Type {
        DATASETS,

        DATABASE_CDC,

        UNKNOWN_TO_SDK_VERSION
    }
}
