/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestConfigurationResponse extends AppTestResponse implements
        ToCopyableBuilder<GetTestConfigurationResponse.Builder, GetTestConfigurationResponse> {
    private static final SdkField<String> TEST_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testConfigurationId").getter(getter(GetTestConfigurationResponse::testConfigurationId))
            .setter(setter(Builder::testConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTestConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TEST_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testConfigurationArn").getter(getter(GetTestConfigurationResponse::testConfigurationArn))
            .setter(setter(Builder::testConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationArn").build())
            .build();

    private static final SdkField<TestConfigurationLatestVersion> LATEST_VERSION_FIELD = SdkField
            .<TestConfigurationLatestVersion> builder(MarshallingType.SDK_POJO).memberName("latestVersion")
            .getter(getter(GetTestConfigurationResponse::latestVersion)).setter(setter(Builder::latestVersion))
            .constructor(TestConfigurationLatestVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final SdkField<Integer> TEST_CONFIGURATION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testConfigurationVersion").getter(getter(GetTestConfigurationResponse::testConfigurationVersion))
            .setter(setter(Builder::testConfigurationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationVersion").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTestConfigurationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetTestConfigurationResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetTestConfigurationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(GetTestConfigurationResponse::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetTestConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(GetTestConfigurationResponse::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("properties")
            .getter(getter(GetTestConfigurationResponse::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetTestConfigurationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ServiceSettings> SERVICE_SETTINGS_FIELD = SdkField
            .<ServiceSettings> builder(MarshallingType.SDK_POJO).memberName("serviceSettings")
            .getter(getter(GetTestConfigurationResponse::serviceSettings)).setter(setter(Builder::serviceSettings))
            .constructor(ServiceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CONFIGURATION_ID_FIELD,
            NAME_FIELD, TEST_CONFIGURATION_ARN_FIELD, LATEST_VERSION_FIELD, TEST_CONFIGURATION_VERSION_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, DESCRIPTION_FIELD, RESOURCES_FIELD,
            PROPERTIES_FIELD, TAGS_FIELD, SERVICE_SETTINGS_FIELD));

    private final String testConfigurationId;

    private final String name;

    private final String testConfigurationArn;

    private final TestConfigurationLatestVersion latestVersion;

    private final Integer testConfigurationVersion;

    private final String status;

    private final String statusReason;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final String description;

    private final List<Resource> resources;

    private final Map<String, String> properties;

    private final Map<String, String> tags;

    private final ServiceSettings serviceSettings;

    private GetTestConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.testConfigurationId = builder.testConfigurationId;
        this.name = builder.name;
        this.testConfigurationArn = builder.testConfigurationArn;
        this.latestVersion = builder.latestVersion;
        this.testConfigurationVersion = builder.testConfigurationVersion;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.description = builder.description;
        this.resources = builder.resources;
        this.properties = builder.properties;
        this.tags = builder.tags;
        this.serviceSettings = builder.serviceSettings;
    }

    /**
     * <p>
     * The response test configuration ID.
     * </p>
     * 
     * @return The response test configuration ID.
     */
    public final String testConfigurationId() {
        return testConfigurationId;
    }

    /**
     * <p>
     * The test configuration name
     * </p>
     * 
     * @return The test configuration name
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The test configuration Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The test configuration Amazon Resource Name (ARN).
     */
    public final String testConfigurationArn() {
        return testConfigurationArn;
    }

    /**
     * <p>
     * The latest version of the test configuration.
     * </p>
     * 
     * @return The latest version of the test configuration.
     */
    public final TestConfigurationLatestVersion latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The test configuration version.
     * </p>
     * 
     * @return The test configuration version.
     */
    public final Integer testConfigurationVersion() {
        return testConfigurationVersion;
    }

    /**
     * <p>
     * The status of the test configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestConfigurationLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test configuration.
     * @see TestConfigurationLifecycle
     */
    public final TestConfigurationLifecycle status() {
        return TestConfigurationLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the test configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestConfigurationLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test configuration.
     * @see TestConfigurationLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the test configuration.
     * </p>
     * 
     * @return The status reason of the test configuration.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The creation time of the test configuration.
     * </p>
     * 
     * @return The creation time of the test configuration.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last update time of the test configuration.
     * </p>
     * 
     * @return The last update time of the test configuration.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The description of the test configuration.
     * </p>
     * 
     * @return The description of the test configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources of the test configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return The resources of the test configuration.
     */
    public final List<Resource> resources() {
        return resources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The properties of the test configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The properties of the test configuration.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the test configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the test configuration.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The service settings of the test configuration.
     * </p>
     * 
     * @return The service settings of the test configuration.
     */
    public final ServiceSettings serviceSettings() {
        return serviceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(testConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(testConfigurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestConfigurationResponse)) {
            return false;
        }
        GetTestConfigurationResponse other = (GetTestConfigurationResponse) obj;
        return Objects.equals(testConfigurationId(), other.testConfigurationId()) && Objects.equals(name(), other.name())
                && Objects.equals(testConfigurationArn(), other.testConfigurationArn())
                && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(testConfigurationVersion(), other.testConfigurationVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(description(), other.description())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(serviceSettings(), other.serviceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTestConfigurationResponse").add("TestConfigurationId", testConfigurationId())
                .add("Name", name()).add("TestConfigurationArn", testConfigurationArn()).add("LatestVersion", latestVersion())
                .add("TestConfigurationVersion", testConfigurationVersion()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .add("Description", description()).add("Resources", hasResources() ? resources() : null)
                .add("Properties", hasProperties() ? properties() : null).add("Tags", hasTags() ? tags() : null)
                .add("ServiceSettings", serviceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testConfigurationId":
            return Optional.ofNullable(clazz.cast(testConfigurationId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "testConfigurationArn":
            return Optional.ofNullable(clazz.cast(testConfigurationArn()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "testConfigurationVersion":
            return Optional.ofNullable(clazz.cast(testConfigurationVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "serviceSettings":
            return Optional.ofNullable(clazz.cast(serviceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTestConfigurationResponse, T> g) {
        return obj -> g.apply((GetTestConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTestConfigurationResponse> {
        /**
         * <p>
         * The response test configuration ID.
         * </p>
         * 
         * @param testConfigurationId
         *        The response test configuration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigurationId(String testConfigurationId);

        /**
         * <p>
         * The test configuration name
         * </p>
         * 
         * @param name
         *        The test configuration name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The test configuration Amazon Resource Name (ARN).
         * </p>
         * 
         * @param testConfigurationArn
         *        The test configuration Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigurationArn(String testConfigurationArn);

        /**
         * <p>
         * The latest version of the test configuration.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(TestConfigurationLatestVersion latestVersion);

        /**
         * <p>
         * The latest version of the test configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestConfigurationLatestVersion.Builder}
         * avoiding the need to create one manually via {@link TestConfigurationLatestVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestConfigurationLatestVersion.Builder#build()} is called
         * immediately and its result is passed to {@link #latestVersion(TestConfigurationLatestVersion)}.
         * 
         * @param latestVersion
         *        a consumer that will call methods on {@link TestConfigurationLatestVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestVersion(TestConfigurationLatestVersion)
         */
        default Builder latestVersion(Consumer<TestConfigurationLatestVersion.Builder> latestVersion) {
            return latestVersion(TestConfigurationLatestVersion.builder().applyMutation(latestVersion).build());
        }

        /**
         * <p>
         * The test configuration version.
         * </p>
         * 
         * @param testConfigurationVersion
         *        The test configuration version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigurationVersion(Integer testConfigurationVersion);

        /**
         * <p>
         * The status of the test configuration.
         * </p>
         * 
         * @param status
         *        The status of the test configuration.
         * @see TestConfigurationLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestConfigurationLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test configuration.
         * </p>
         * 
         * @param status
         *        The status of the test configuration.
         * @see TestConfigurationLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestConfigurationLifecycle
         */
        Builder status(TestConfigurationLifecycle status);

        /**
         * <p>
         * The status reason of the test configuration.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The creation time of the test configuration.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last update time of the test configuration.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last update time of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The description of the test configuration.
         * </p>
         * 
         * @param description
         *        The description of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The resources of the test configuration.
         * </p>
         * 
         * @param resources
         *        The resources of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * <p>
         * The resources of the test configuration.
         * </p>
         * 
         * @param resources
         *        The resources of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);

        /**
         * <p>
         * The resources of the test configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.Resource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.apptest.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.Resource.Builder#build()} is called immediately and its
         * result is passed to {@link #resources(List<Resource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<Resource>)
         */
        Builder resources(Consumer<Resource.Builder>... resources);

        /**
         * <p>
         * The properties of the test configuration.
         * </p>
         * 
         * @param properties
         *        The properties of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);

        /**
         * <p>
         * The tags of the test configuration.
         * </p>
         * 
         * @param tags
         *        The tags of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The service settings of the test configuration.
         * </p>
         * 
         * @param serviceSettings
         *        The service settings of the test configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSettings(ServiceSettings serviceSettings);

        /**
         * <p>
         * The service settings of the test configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceSettings.Builder} avoiding the
         * need to create one manually via {@link ServiceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceSettings(ServiceSettings)}.
         * 
         * @param serviceSettings
         *        a consumer that will call methods on {@link ServiceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSettings(ServiceSettings)
         */
        default Builder serviceSettings(Consumer<ServiceSettings.Builder> serviceSettings) {
            return serviceSettings(ServiceSettings.builder().applyMutation(serviceSettings).build());
        }
    }

    static final class BuilderImpl extends AppTestResponse.BuilderImpl implements Builder {
        private String testConfigurationId;

        private String name;

        private String testConfigurationArn;

        private TestConfigurationLatestVersion latestVersion;

        private Integer testConfigurationVersion;

        private String status;

        private String statusReason;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private String description;

        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ServiceSettings serviceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestConfigurationResponse model) {
            super(model);
            testConfigurationId(model.testConfigurationId);
            name(model.name);
            testConfigurationArn(model.testConfigurationArn);
            latestVersion(model.latestVersion);
            testConfigurationVersion(model.testConfigurationVersion);
            status(model.status);
            statusReason(model.statusReason);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            description(model.description);
            resources(model.resources);
            properties(model.properties);
            tags(model.tags);
            serviceSettings(model.serviceSettings);
        }

        public final String getTestConfigurationId() {
            return testConfigurationId;
        }

        public final void setTestConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
        }

        @Override
        public final Builder testConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTestConfigurationArn() {
            return testConfigurationArn;
        }

        public final void setTestConfigurationArn(String testConfigurationArn) {
            this.testConfigurationArn = testConfigurationArn;
        }

        @Override
        public final Builder testConfigurationArn(String testConfigurationArn) {
            this.testConfigurationArn = testConfigurationArn;
            return this;
        }

        public final TestConfigurationLatestVersion.Builder getLatestVersion() {
            return latestVersion != null ? latestVersion.toBuilder() : null;
        }

        public final void setLatestVersion(TestConfigurationLatestVersion.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        @Override
        public final Builder latestVersion(TestConfigurationLatestVersion latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Integer getTestConfigurationVersion() {
            return testConfigurationVersion;
        }

        public final void setTestConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
        }

        @Override
        public final Builder testConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestConfigurationLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> Resource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = PropertiesCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = PropertiesCopier.copy(properties);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ServiceSettings.Builder getServiceSettings() {
            return serviceSettings != null ? serviceSettings.toBuilder() : null;
        }

        public final void setServiceSettings(ServiceSettings.BuilderImpl serviceSettings) {
            this.serviceSettings = serviceSettings != null ? serviceSettings.build() : null;
        }

        @Override
        public final Builder serviceSettings(ServiceSettings serviceSettings) {
            this.serviceSettings = serviceSettings;
            return this;
        }

        @Override
        public GetTestConfigurationResponse build() {
            return new GetTestConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
