/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestRunStepRequest extends AppTestRequest implements
        ToCopyableBuilder<GetTestRunStepRequest.Builder, GetTestRunStepRequest> {
    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testRunId").getter(getter(GetTestRunStepRequest::testRunId)).setter(setter(Builder::testRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testRunId").build()).build();

    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepName").getter(getter(GetTestRunStepRequest::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("stepName").build()).build();

    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(GetTestRunStepRequest::testCaseId)).setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testCaseId").build()).build();

    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteId").getter(getter(GetTestRunStepRequest::testSuiteId)).setter(setter(Builder::testSuiteId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testSuiteId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RUN_ID_FIELD,
            STEP_NAME_FIELD, TEST_CASE_ID_FIELD, TEST_SUITE_ID_FIELD));

    private final String testRunId;

    private final String stepName;

    private final String testCaseId;

    private final String testSuiteId;

    private GetTestRunStepRequest(BuilderImpl builder) {
        super(builder);
        this.testRunId = builder.testRunId;
        this.stepName = builder.stepName;
        this.testCaseId = builder.testCaseId;
        this.testSuiteId = builder.testSuiteId;
    }

    /**
     * <p>
     * The test run ID of the test run step.
     * </p>
     * 
     * @return The test run ID of the test run step.
     */
    public final String testRunId() {
        return testRunId;
    }

    /**
     * <p>
     * The step name of the test run step.
     * </p>
     * 
     * @return The step name of the test run step.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The test case ID of a test run step.
     * </p>
     * 
     * @return The test case ID of a test run step.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    /**
     * <p>
     * The test suite ID of a test run step.
     * </p>
     * 
     * @return The test suite ID of a test run step.
     */
    public final String testSuiteId() {
        return testSuiteId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestRunStepRequest)) {
            return false;
        }
        GetTestRunStepRequest other = (GetTestRunStepRequest) obj;
        return Objects.equals(testRunId(), other.testRunId()) && Objects.equals(stepName(), other.stepName())
                && Objects.equals(testCaseId(), other.testCaseId()) && Objects.equals(testSuiteId(), other.testSuiteId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTestRunStepRequest").add("TestRunId", testRunId()).add("StepName", stepName())
                .add("TestCaseId", testCaseId()).add("TestSuiteId", testSuiteId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testRunId":
            return Optional.ofNullable(clazz.cast(testRunId()));
        case "stepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        case "testSuiteId":
            return Optional.ofNullable(clazz.cast(testSuiteId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTestRunStepRequest, T> g) {
        return obj -> g.apply((GetTestRunStepRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTestRunStepRequest> {
        /**
         * <p>
         * The test run ID of the test run step.
         * </p>
         * 
         * @param testRunId
         *        The test run ID of the test run step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunId(String testRunId);

        /**
         * <p>
         * The step name of the test run step.
         * </p>
         * 
         * @param stepName
         *        The step name of the test run step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The test case ID of a test run step.
         * </p>
         * 
         * @param testCaseId
         *        The test case ID of a test run step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        /**
         * <p>
         * The test suite ID of a test run step.
         * </p>
         * 
         * @param testSuiteId
         *        The test suite ID of a test run step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteId(String testSuiteId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppTestRequest.BuilderImpl implements Builder {
        private String testRunId;

        private String stepName;

        private String testCaseId;

        private String testSuiteId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestRunStepRequest model) {
            super(model);
            testRunId(model.testRunId);
            stepName(model.stepName);
            testCaseId(model.testCaseId);
            testSuiteId(model.testSuiteId);
        }

        public final String getTestRunId() {
            return testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getStepName() {
            return stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getTestSuiteId() {
            return testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTestRunStepRequest build() {
            return new GetTestRunStepRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
