/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestCasesResponse extends AppTestResponse implements
        ToCopyableBuilder<ListTestCasesResponse.Builder, ListTestCasesResponse> {
    private static final SdkField<List<TestCaseSummary>> TEST_CASES_FIELD = SdkField
            .<List<TestCaseSummary>> builder(MarshallingType.LIST)
            .memberName("testCases")
            .getter(getter(ListTestCasesResponse::testCases))
            .setter(setter(Builder::testCases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestCaseSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestCaseSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestCasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TestCaseSummary> testCases;

    private final String nextToken;

    private ListTestCasesResponse(BuilderImpl builder) {
        super(builder);
        this.testCases = builder.testCases;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestCases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTestCases() {
        return testCases != null && !(testCases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The test cases in an application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestCases} method.
     * </p>
     * 
     * @return The test cases in an application.
     */
    public final List<TestCaseSummary> testCases() {
        return testCases;
    }

    /**
     * <p>
     * The next token in test cases.
     * </p>
     * 
     * @return The next token in test cases.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTestCases() ? testCases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestCasesResponse)) {
            return false;
        }
        ListTestCasesResponse other = (ListTestCasesResponse) obj;
        return hasTestCases() == other.hasTestCases() && Objects.equals(testCases(), other.testCases())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestCasesResponse").add("TestCases", hasTestCases() ? testCases() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCases":
            return Optional.ofNullable(clazz.cast(testCases()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestCasesResponse, T> g) {
        return obj -> g.apply((ListTestCasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTestCasesResponse> {
        /**
         * <p>
         * The test cases in an application.
         * </p>
         * 
         * @param testCases
         *        The test cases in an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCases(Collection<TestCaseSummary> testCases);

        /**
         * <p>
         * The test cases in an application.
         * </p>
         * 
         * @param testCases
         *        The test cases in an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCases(TestCaseSummary... testCases);

        /**
         * <p>
         * The test cases in an application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.TestCaseSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.apptest.model.TestCaseSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.TestCaseSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #testCases(List<TestCaseSummary>)}.
         * 
         * @param testCases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.TestCaseSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testCases(java.util.Collection<TestCaseSummary>)
         */
        Builder testCases(Consumer<TestCaseSummary.Builder>... testCases);

        /**
         * <p>
         * The next token in test cases.
         * </p>
         * 
         * @param nextToken
         *        The next token in test cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppTestResponse.BuilderImpl implements Builder {
        private List<TestCaseSummary> testCases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestCasesResponse model) {
            super(model);
            testCases(model.testCases);
            nextToken(model.nextToken);
        }

        public final List<TestCaseSummary.Builder> getTestCases() {
            List<TestCaseSummary.Builder> result = TestCaseSummaryListCopier.copyToBuilder(this.testCases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestCases(Collection<TestCaseSummary.BuilderImpl> testCases) {
            this.testCases = TestCaseSummaryListCopier.copyFromBuilder(testCases);
        }

        @Override
        public final Builder testCases(Collection<TestCaseSummary> testCases) {
            this.testCases = TestCaseSummaryListCopier.copy(testCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(TestCaseSummary... testCases) {
            testCases(Arrays.asList(testCases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(Consumer<TestCaseSummary.Builder>... testCases) {
            testCases(Stream.of(testCases).map(c -> TestCaseSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestCasesResponse build() {
            return new ListTestCasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
