/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestRunsRequest extends AppTestRequest implements
        ToCopyableBuilder<ListTestRunsRequest.Builder, ListTestRunsRequest> {
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteId").getter(getter(ListTestRunsRequest::testSuiteId)).setter(setter(Builder::testSuiteId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testSuiteId").build()).build();

    private static final SdkField<List<String>> TEST_RUN_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("testRunIds")
            .getter(getter(ListTestRunsRequest::testRunIds))
            .setter(setter(Builder::testRunIds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testrunIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestRunsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTestRunsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITE_ID_FIELD,
            TEST_RUN_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String testSuiteId;

    private final List<String> testRunIds;

    private final String nextToken;

    private final Integer maxResults;

    private ListTestRunsRequest(BuilderImpl builder) {
        super(builder);
        this.testSuiteId = builder.testSuiteId;
        this.testRunIds = builder.testRunIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The test suite ID of the test runs.
     * </p>
     * 
     * @return The test suite ID of the test runs.
     */
    public final String testSuiteId() {
        return testSuiteId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestRunIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTestRunIds() {
        return testRunIds != null && !(testRunIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The test run IDs of the test runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestRunIds} method.
     * </p>
     * 
     * @return The test run IDs of the test runs.
     */
    public final List<String> testRunIds() {
        return testRunIds;
    }

    /**
     * <p>
     * The token from the previous request to retrieve the next page of test run results.
     * </p>
     * 
     * @return The token from the previous request to retrieve the next page of test run results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of test runs to return in one page of results.
     * </p>
     * 
     * @return The maximum number of test runs to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTestRunIds() ? testRunIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestRunsRequest)) {
            return false;
        }
        ListTestRunsRequest other = (ListTestRunsRequest) obj;
        return Objects.equals(testSuiteId(), other.testSuiteId()) && hasTestRunIds() == other.hasTestRunIds()
                && Objects.equals(testRunIds(), other.testRunIds()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestRunsRequest").add("TestSuiteId", testSuiteId())
                .add("TestRunIds", hasTestRunIds() ? testRunIds() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSuiteId":
            return Optional.ofNullable(clazz.cast(testSuiteId()));
        case "testRunIds":
            return Optional.ofNullable(clazz.cast(testRunIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestRunsRequest, T> g) {
        return obj -> g.apply((ListTestRunsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTestRunsRequest> {
        /**
         * <p>
         * The test suite ID of the test runs.
         * </p>
         * 
         * @param testSuiteId
         *        The test suite ID of the test runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteId(String testSuiteId);

        /**
         * <p>
         * The test run IDs of the test runs.
         * </p>
         * 
         * @param testRunIds
         *        The test run IDs of the test runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunIds(Collection<String> testRunIds);

        /**
         * <p>
         * The test run IDs of the test runs.
         * </p>
         * 
         * @param testRunIds
         *        The test run IDs of the test runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunIds(String... testRunIds);

        /**
         * <p>
         * The token from the previous request to retrieve the next page of test run results.
         * </p>
         * 
         * @param nextToken
         *        The token from the previous request to retrieve the next page of test run results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of test runs to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of test runs to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppTestRequest.BuilderImpl implements Builder {
        private String testSuiteId;

        private List<String> testRunIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestRunsRequest model) {
            super(model);
            testSuiteId(model.testSuiteId);
            testRunIds(model.testRunIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getTestSuiteId() {
            return testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final Collection<String> getTestRunIds() {
            if (testRunIds instanceof SdkAutoConstructList) {
                return null;
            }
            return testRunIds;
        }

        public final void setTestRunIds(Collection<String> testRunIds) {
            this.testRunIds = TestRunIdListCopier.copy(testRunIds);
        }

        @Override
        public final Builder testRunIds(Collection<String> testRunIds) {
            this.testRunIds = TestRunIdListCopier.copy(testRunIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRunIds(String... testRunIds) {
            testRunIds(Arrays.asList(testRunIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTestRunsRequest build() {
            return new ListTestRunsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
