/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the AWS Mainframe Modernization managed application step input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2ManagedApplicationStepInput implements SdkPojo, Serializable,
        ToCopyableBuilder<M2ManagedApplicationStepInput.Builder, M2ManagedApplicationStepInput> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(M2ManagedApplicationStepInput::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runtime")
            .getter(getter(M2ManagedApplicationStepInput::runtime)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointServiceName").getter(getter(M2ManagedApplicationStepInput::vpcEndpointServiceName))
            .setter(setter(Builder::vpcEndpointServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointServiceName").build())
            .build();

    private static final SdkField<Integer> LISTENER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("listenerPort").getter(getter(M2ManagedApplicationStepInput::listenerPort))
            .setter(setter(Builder::listenerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(M2ManagedApplicationStepInput::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<M2ManagedActionProperties> PROPERTIES_FIELD = SdkField
            .<M2ManagedActionProperties> builder(MarshallingType.SDK_POJO).memberName("properties")
            .getter(getter(M2ManagedApplicationStepInput::properties)).setter(setter(Builder::properties))
            .constructor(M2ManagedActionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            RUNTIME_FIELD, VPC_ENDPOINT_SERVICE_NAME_FIELD, LISTENER_PORT_FIELD, ACTION_TYPE_FIELD, PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String runtime;

    private final String vpcEndpointServiceName;

    private final Integer listenerPort;

    private final String actionType;

    private final M2ManagedActionProperties properties;

    private M2ManagedApplicationStepInput(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.runtime = builder.runtime;
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.listenerPort = builder.listenerPort;
        this.actionType = builder.actionType;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The application ID of the AWS Mainframe Modernization managed application step input.
     * </p>
     * 
     * @return The application ID of the AWS Mainframe Modernization managed application step input.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The runtime of the AWS Mainframe Modernization managed application step input.
     * </p>
     * 
     * @return The runtime of the AWS Mainframe Modernization managed application step input.
     */
    public final String runtime() {
        return runtime;
    }

    /**
     * <p>
     * The VPC endpoint service name of the AWS Mainframe Modernization managed application step input.
     * </p>
     * 
     * @return The VPC endpoint service name of the AWS Mainframe Modernization managed application step input.
     */
    public final String vpcEndpointServiceName() {
        return vpcEndpointServiceName;
    }

    /**
     * <p>
     * The listener port of the AWS Mainframe Modernization managed application step input.
     * </p>
     * 
     * @return The listener port of the AWS Mainframe Modernization managed application step input.
     */
    public final Integer listenerPort() {
        return listenerPort;
    }

    /**
     * <p>
     * The action type of the AWS Mainframe Modernization managed application step input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link M2ManagedActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type of the AWS Mainframe Modernization managed application step input.
     * @see M2ManagedActionType
     */
    public final M2ManagedActionType actionType() {
        return M2ManagedActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The action type of the AWS Mainframe Modernization managed application step input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link M2ManagedActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type of the AWS Mainframe Modernization managed application step input.
     * @see M2ManagedActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The properties of the AWS Mainframe Modernization managed application step input.
     * </p>
     * 
     * @return The properties of the AWS Mainframe Modernization managed application step input.
     */
    public final M2ManagedActionProperties properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(runtime());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(listenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedApplicationStepInput)) {
            return false;
        }
        M2ManagedApplicationStepInput other = (M2ManagedApplicationStepInput) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(runtime(), other.runtime())
                && Objects.equals(vpcEndpointServiceName(), other.vpcEndpointServiceName())
                && Objects.equals(listenerPort(), other.listenerPort())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("M2ManagedApplicationStepInput").add("ApplicationId", applicationId()).add("Runtime", runtime())
                .add("VpcEndpointServiceName", vpcEndpointServiceName()).add("ListenerPort", listenerPort())
                .add("ActionType", actionTypeAsString()).add("Properties", properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtime()));
        case "vpcEndpointServiceName":
            return Optional.ofNullable(clazz.cast(vpcEndpointServiceName()));
        case "listenerPort":
            return Optional.ofNullable(clazz.cast(listenerPort()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedApplicationStepInput, T> g) {
        return obj -> g.apply((M2ManagedApplicationStepInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2ManagedApplicationStepInput> {
        /**
         * <p>
         * The application ID of the AWS Mainframe Modernization managed application step input.
         * </p>
         * 
         * @param applicationId
         *        The application ID of the AWS Mainframe Modernization managed application step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The runtime of the AWS Mainframe Modernization managed application step input.
         * </p>
         * 
         * @param runtime
         *        The runtime of the AWS Mainframe Modernization managed application step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The VPC endpoint service name of the AWS Mainframe Modernization managed application step input.
         * </p>
         * 
         * @param vpcEndpointServiceName
         *        The VPC endpoint service name of the AWS Mainframe Modernization managed application step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointServiceName(String vpcEndpointServiceName);

        /**
         * <p>
         * The listener port of the AWS Mainframe Modernization managed application step input.
         * </p>
         * 
         * @param listenerPort
         *        The listener port of the AWS Mainframe Modernization managed application step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPort(Integer listenerPort);

        /**
         * <p>
         * The action type of the AWS Mainframe Modernization managed application step input.
         * </p>
         * 
         * @param actionType
         *        The action type of the AWS Mainframe Modernization managed application step input.
         * @see M2ManagedActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2ManagedActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The action type of the AWS Mainframe Modernization managed application step input.
         * </p>
         * 
         * @param actionType
         *        The action type of the AWS Mainframe Modernization managed application step input.
         * @see M2ManagedActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2ManagedActionType
         */
        Builder actionType(M2ManagedActionType actionType);

        /**
         * <p>
         * The properties of the AWS Mainframe Modernization managed application step input.
         * </p>
         * 
         * @param properties
         *        The properties of the AWS Mainframe Modernization managed application step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(M2ManagedActionProperties properties);

        /**
         * <p>
         * The properties of the AWS Mainframe Modernization managed application step input.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2ManagedActionProperties.Builder}
         * avoiding the need to create one manually via {@link M2ManagedActionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2ManagedActionProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #properties(M2ManagedActionProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link M2ManagedActionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(M2ManagedActionProperties)
         */
        default Builder properties(Consumer<M2ManagedActionProperties.Builder> properties) {
            return properties(M2ManagedActionProperties.builder().applyMutation(properties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String runtime;

        private String vpcEndpointServiceName;

        private Integer listenerPort;

        private String actionType;

        private M2ManagedActionProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedApplicationStepInput model) {
            applicationId(model.applicationId);
            runtime(model.runtime);
            vpcEndpointServiceName(model.vpcEndpointServiceName);
            listenerPort(model.listenerPort);
            actionType(model.actionType);
            properties(model.properties);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public final String getVpcEndpointServiceName() {
            return vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final Integer getListenerPort() {
            return listenerPort;
        }

        public final void setListenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(M2ManagedActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final M2ManagedActionProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        public final void setProperties(M2ManagedActionProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(M2ManagedActionProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public M2ManagedApplicationStepInput build() {
            return new M2ManagedApplicationStepInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
