/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an output file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputFile implements SdkPojo, Serializable, ToCopyableBuilder<OutputFile.Builder, OutputFile> {
    private static final SdkField<String> FILE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileLocation").getter(getter(OutputFile::fileLocation)).setter(setter(Builder::fileLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileLocation;

    private OutputFile(BuilderImpl builder) {
        this.fileLocation = builder.fileLocation;
    }

    /**
     * <p>
     * The file location of the output file.
     * </p>
     * 
     * @return The file location of the output file.
     */
    public final String fileLocation() {
        return fileLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputFile)) {
            return false;
        }
        OutputFile other = (OutputFile) obj;
        return Objects.equals(fileLocation(), other.fileLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputFile").add("FileLocation", fileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileLocation":
            return Optional.ofNullable(clazz.cast(fileLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputFile, T> g) {
        return obj -> g.apply((OutputFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputFile> {
        /**
         * <p>
         * The file location of the output file.
         * </p>
         * 
         * @param fileLocation
         *        The file location of the output file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileLocation(String fileLocation);
    }

    static final class BuilderImpl implements Builder {
        private String fileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputFile model) {
            fileLocation(model.fileLocation);
        }

        public final String getFileLocation() {
            return fileLocation;
        }

        public final void setFileLocation(String fileLocation) {
            this.fileLocation = fileLocation;
        }

        @Override
        public final Builder fileLocation(String fileLocation) {
            this.fileLocation = fileLocation;
            return this;
        }

        @Override
        public OutputFile build() {
            return new OutputFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
