/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTestRunResponse extends AppTestResponse implements
        ToCopyableBuilder<StartTestRunResponse.Builder, StartTestRunResponse> {
    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testRunId").getter(getter(StartTestRunResponse::testRunId)).setter(setter(Builder::testRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunId").build()).build();

    private static final SdkField<String> TEST_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testRunStatus").getter(getter(StartTestRunResponse::testRunStatusAsString))
            .setter(setter(Builder::testRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RUN_ID_FIELD,
            TEST_RUN_STATUS_FIELD));

    private final String testRunId;

    private final String testRunStatus;

    private StartTestRunResponse(BuilderImpl builder) {
        super(builder);
        this.testRunId = builder.testRunId;
        this.testRunStatus = builder.testRunStatus;
    }

    /**
     * <p>
     * The test run ID of the test run.
     * </p>
     * 
     * @return The test run ID of the test run.
     */
    public final String testRunId() {
        return testRunId;
    }

    /**
     * <p>
     * The test run status of the test run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testRunStatus}
     * will return {@link TestRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #testRunStatusAsString}.
     * </p>
     * 
     * @return The test run status of the test run.
     * @see TestRunStatus
     */
    public final TestRunStatus testRunStatus() {
        return TestRunStatus.fromValue(testRunStatus);
    }

    /**
     * <p>
     * The test run status of the test run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testRunStatus}
     * will return {@link TestRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #testRunStatusAsString}.
     * </p>
     * 
     * @return The test run status of the test run.
     * @see TestRunStatus
     */
    public final String testRunStatusAsString() {
        return testRunStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(testRunStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTestRunResponse)) {
            return false;
        }
        StartTestRunResponse other = (StartTestRunResponse) obj;
        return Objects.equals(testRunId(), other.testRunId())
                && Objects.equals(testRunStatusAsString(), other.testRunStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTestRunResponse").add("TestRunId", testRunId())
                .add("TestRunStatus", testRunStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testRunId":
            return Optional.ofNullable(clazz.cast(testRunId()));
        case "testRunStatus":
            return Optional.ofNullable(clazz.cast(testRunStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTestRunResponse, T> g) {
        return obj -> g.apply((StartTestRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartTestRunResponse> {
        /**
         * <p>
         * The test run ID of the test run.
         * </p>
         * 
         * @param testRunId
         *        The test run ID of the test run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunId(String testRunId);

        /**
         * <p>
         * The test run status of the test run.
         * </p>
         * 
         * @param testRunStatus
         *        The test run status of the test run.
         * @see TestRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestRunStatus
         */
        Builder testRunStatus(String testRunStatus);

        /**
         * <p>
         * The test run status of the test run.
         * </p>
         * 
         * @param testRunStatus
         *        The test run status of the test run.
         * @see TestRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestRunStatus
         */
        Builder testRunStatus(TestRunStatus testRunStatus);
    }

    static final class BuilderImpl extends AppTestResponse.BuilderImpl implements Builder {
        private String testRunId;

        private String testRunStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTestRunResponse model) {
            super(model);
            testRunId(model.testRunId);
            testRunStatus(model.testRunStatus);
        }

        public final String getTestRunId() {
            return testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getTestRunStatus() {
            return testRunStatus;
        }

        public final void setTestRunStatus(String testRunStatus) {
            this.testRunStatus = testRunStatus;
        }

        @Override
        public final Builder testRunStatus(String testRunStatus) {
            this.testRunStatus = testRunStatus;
            return this;
        }

        @Override
        public final Builder testRunStatus(TestRunStatus testRunStatus) {
            this.testRunStatus(testRunStatus == null ? null : testRunStatus.toString());
            return this;
        }

        @Override
        public StartTestRunResponse build() {
            return new StartTestRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
