/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a test configuration summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TestConfigurationSummary.Builder, TestConfigurationSummary> {
    private static final SdkField<String> TEST_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testConfigurationId").getter(getter(TestConfigurationSummary::testConfigurationId))
            .setter(setter(Builder::testConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TestConfigurationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(TestConfigurationSummary::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Integer> LATEST_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("latestVersion").getter(getter(TestConfigurationSummary::latestVersion))
            .setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final SdkField<String> TEST_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testConfigurationArn").getter(getter(TestConfigurationSummary::testConfigurationArn))
            .setter(setter(Builder::testConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestConfigurationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(TestConfigurationSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(TestConfigurationSummary::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CONFIGURATION_ID_FIELD,
            NAME_FIELD, STATUS_REASON_FIELD, LATEST_VERSION_FIELD, TEST_CONFIGURATION_ARN_FIELD, STATUS_FIELD,
            CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String testConfigurationId;

    private final String name;

    private final String statusReason;

    private final Integer latestVersion;

    private final String testConfigurationArn;

    private final String status;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private TestConfigurationSummary(BuilderImpl builder) {
        this.testConfigurationId = builder.testConfigurationId;
        this.name = builder.name;
        this.statusReason = builder.statusReason;
        this.latestVersion = builder.latestVersion;
        this.testConfigurationArn = builder.testConfigurationArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The test configuration ID of the test configuration summary.
     * </p>
     * 
     * @return The test configuration ID of the test configuration summary.
     */
    public final String testConfigurationId() {
        return testConfigurationId;
    }

    /**
     * <p>
     * The name of the test configuration summary.
     * </p>
     * 
     * @return The name of the test configuration summary.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status reason of the test configuration summary.
     * </p>
     * 
     * @return The status reason of the test configuration summary.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The latest version of the test configuration summary.
     * </p>
     * 
     * @return The latest version of the test configuration summary.
     */
    public final Integer latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The test configuration ARN of the test configuration summary.
     * </p>
     * 
     * @return The test configuration ARN of the test configuration summary.
     */
    public final String testConfigurationArn() {
        return testConfigurationArn;
    }

    /**
     * <p>
     * The status of the test configuration summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestConfigurationLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test configuration summary.
     * @see TestConfigurationLifecycle
     */
    public final TestConfigurationLifecycle status() {
        return TestConfigurationLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the test configuration summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestConfigurationLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test configuration summary.
     * @see TestConfigurationLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time of the test configuration summary.
     * </p>
     * 
     * @return The creation time of the test configuration summary.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last update time of the test configuration summary.
     * </p>
     * 
     * @return The last update time of the test configuration summary.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(testConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConfigurationSummary)) {
            return false;
        }
        TestConfigurationSummary other = (TestConfigurationSummary) obj;
        return Objects.equals(testConfigurationId(), other.testConfigurationId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(testConfigurationArn(), other.testConfigurationArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestConfigurationSummary").add("TestConfigurationId", testConfigurationId()).add("Name", name())
                .add("StatusReason", statusReason()).add("LatestVersion", latestVersion())
                .add("TestConfigurationArn", testConfigurationArn()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testConfigurationId":
            return Optional.ofNullable(clazz.cast(testConfigurationId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "testConfigurationArn":
            return Optional.ofNullable(clazz.cast(testConfigurationArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestConfigurationSummary, T> g) {
        return obj -> g.apply((TestConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestConfigurationSummary> {
        /**
         * <p>
         * The test configuration ID of the test configuration summary.
         * </p>
         * 
         * @param testConfigurationId
         *        The test configuration ID of the test configuration summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigurationId(String testConfigurationId);

        /**
         * <p>
         * The name of the test configuration summary.
         * </p>
         * 
         * @param name
         *        The name of the test configuration summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status reason of the test configuration summary.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the test configuration summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The latest version of the test configuration summary.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the test configuration summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(Integer latestVersion);

        /**
         * <p>
         * The test configuration ARN of the test configuration summary.
         * </p>
         * 
         * @param testConfigurationArn
         *        The test configuration ARN of the test configuration summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigurationArn(String testConfigurationArn);

        /**
         * <p>
         * The status of the test configuration summary.
         * </p>
         * 
         * @param status
         *        The status of the test configuration summary.
         * @see TestConfigurationLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestConfigurationLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test configuration summary.
         * </p>
         * 
         * @param status
         *        The status of the test configuration summary.
         * @see TestConfigurationLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestConfigurationLifecycle
         */
        Builder status(TestConfigurationLifecycle status);

        /**
         * <p>
         * The creation time of the test configuration summary.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the test configuration summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last update time of the test configuration summary.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last update time of the test configuration summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String testConfigurationId;

        private String name;

        private String statusReason;

        private Integer latestVersion;

        private String testConfigurationArn;

        private String status;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestConfigurationSummary model) {
            testConfigurationId(model.testConfigurationId);
            name(model.name);
            statusReason(model.statusReason);
            latestVersion(model.latestVersion);
            testConfigurationArn(model.testConfigurationArn);
            status(model.status);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getTestConfigurationId() {
            return testConfigurationId;
        }

        public final void setTestConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
        }

        @Override
        public final Builder testConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Integer getLatestVersion() {
            return latestVersion;
        }

        public final void setLatestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final String getTestConfigurationArn() {
            return testConfigurationArn;
        }

        public final void setTestConfigurationArn(String testConfigurationArn) {
            this.testConfigurationArn = testConfigurationArn;
        }

        @Override
        public final Builder testConfigurationArn(String testConfigurationArn) {
            this.testConfigurationArn = testConfigurationArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestConfigurationLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public TestConfigurationSummary build() {
            return new TestConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
